#ifndef _VIRTUAL_CD_
#define _VIRTUAL_CD__

#include <stdio.h>
#include "IStorageDevice.h"
#ifdef Mona
#include "sys/types.h"
#else
#include "types.h"
#endif


class VirtualCD : public IStorageDevice
{
public:
    VirtualCD(FILE* fp);
    virtual ~VirtualCD();

public:
    int open();
    int close();
    int read(dword lba, void* buf, int size);
    int write(dword lba, void* buf, int size);
    int ioctl(void* p);
    int getLogicalBlockSize() const {return 2048;}

private:
    FILE* fp;
};

#endif
