#include "ISO9660.h"
#include "VirtualCD.h"

#include <stdio.h>
#include <string.h>

using namespace MonAPI;

int main(int argc, char *argv[])
{
    if (argc < 4)
    {
        printf("usage: ISO9660.exe comand isoImage filePath\n");
        printf("command: read, ls\n");
        return 1;
    }

    char* command  = argv[1];
    char* isoImage = argv[2];
    char* filePath = argv[3];

    FILE* fp = fopen(isoImage, "rb");

    if (fp == NULL)
    {
        printf("file %s can not read\n", isoImage);
        return 1;
    }

    IStorageDevice* cd = new VirtualCD(fp);
    ISO9660* iso = new ISO9660(cd, "");

    if (!iso->Initialize())
    {
        printf("Initialize Error = %d\n", iso->GetLastError());
        delete iso;
        delete cd;
        fclose(fp);
        return 1;
    }

    if (strcmp(command, "read") == 0)
    {
        File* file = iso->GetFile(filePath);


        if (file == NULL)
        {
            printf("file not found\n");
            delete iso;
            delete cd;
            fclose(fp);
            return -1;
        }

        char* buffer = new char[file->GetSize()];
        file->Seek(0, SEEK_SET);
        file->Read(buffer, file->GetSize());

        for (dword i = 0; i < file->GetSize(); i++)
        {
            printf("%c", buffer[i]);
        }

        delete [] buffer;
    }
    else if (strcmp(command, "ls") == 0)
    {
        _A<CString> files = iso->GetFileSystemEntries(filePath);

        FOREACH (CString, file, files)
        {
            printf("%s\n", (const char*)file);
        }
        END_FOREACH
    }
    else
    {
        printf("command %s not supported\n", command);
        delete iso;
        delete cd;
        fclose(fp);
        return 1;
    }

    delete iso;
    delete cd;
    fclose(fp);

    return 0;
}
