/*!
    \file  mypciinf.cpp
    \brief Get PCI Information

    Copyright (c) 2004 Yamami
    All rights reserved.
    License=MIT/X Licnese

    \author  Yamami
    \version $Revision: 1.5 $
    \date   create:2004/05/09 update:$Date: 2004/11/30 14:04:44 $
*/

#include <monapi.h>
#include <monapi/messages.h>
#include <monapi/io.h>
#include <monapi/CString.h>
#include "pciinfo.h"

using namespace MonAPI;

int MonaMain(List<char*>* pekoe) {

    int reti;
    dword c_deviceid;
    dword InValue;

    word Vendor;
    word Device;

    syscall_get_io();

    CString bundlePath = MonAPI::System::getBundlePath();
    //pciinfot@CI[v
    monapi_cmemoryinfo* pciinfData = monapi_call_file_decompress_bz2_file(bundlePath + "/" + PCIINFO_FILE, MONAPI_TRUE);
    //G[
    if(pciinfData == NULL){
        printf("PCI DATA FILE OPEN ERROR !!!\n");
    }

    printf("PCI Information !!!\n");

    //oXԍ0ɂāAfoCXԍ0`31̂ꂼɂāAx_[IDǂݏo
    for(c_deviceid = 0; c_deviceid < 32 ; c_deviceid++ ){
        reti = lookup_pci_hw( c_deviceid , 0, 0 ,0, &InValue);
        if (InValue != 0xFFFFFFFF){
            //x_[ID̎擾
            Vendor = InValue & 0x0000FFFF;
            Device = InValue >> 16;
            //x_[/foCX̂̎擾
            CString VendorName;
            CString DeviceName;

            CString Dummy = getPciInfName(pciinfData->Data , InValue , &VendorName , &DeviceName);
            printf("DeviceNo=%d , Vendor=%x VendorName=%s Device=%x DeviceName=%s \n" ,c_deviceid , Vendor , (const char*)VendorName , Device , (const char*)DeviceName );
        }
    }


    monapi_cmemoryinfo_dispose(pciinfData);
    monapi_cmemoryinfo_delete(pciinfData);


    return 0;
}



/*!
    \brief lookup_pci_hw
        PCIfoCXT
    \param  dword deviceid [in] foCXԍ
    \param  dword func [in] t@NVԍ
    \param  dword bus [in] oXԍ
    \param  dword regaddr [in] WX^AhX
    \param  dword * InValue [OUT] 擾WX^̒l
    \return int 

    \author Yamami
    \date   create:2004/05/15 update:2004/05/15
*/

int lookup_pci_hw( dword deviceid , dword func , dword bus , dword regaddr , dword *InValue)
{

    dword   outvalue;
    dword   outport;
    dword   inport;
    dword   tmp;

    //printf("lookup_pci_hw !!!\n");

    tmp = 0;
    //PCI CONFIG_ADDRESSWX^̒lݒ
    //bit0-1F0ɌŒ
    //bit2-7FWX^AhX

    //bit8-10F@\ԍ
    //bit11-15FfoCXԍ

    //bit16-23FoXԍ
    //bit24-30FU[uŁA0ɌŒ
    //bit31FCl[urbgŁA1ɌŒ
    //WX^ rbgʒu 31,30EEEE0(32rbg)

    //;Cl[urbgƁAoXԍZbgB
    outvalue = 0x8000;
    outvalue = outvalue | bus;
    outvalue = outvalue << 16;

    //foCXԍA@\ԍݒ
    tmp = deviceid;
    tmp = tmp << 3;
    tmp = tmp + func;
    tmp = tmp << 8;

    outvalue = outvalue + tmp;

    tmp = 0;
    //WX^AhX̎w
    tmp = regaddr;
    tmp = tmp << 2;

    outvalue = outvalue + tmp;


    //I/O|[g̎w (0x0cf8A32bitARead/Write)
    outport = PCI_CONFIG_ADDRESS_ADDR;

    //ŁAfobOvgĂ݂B
    //printf("Value= %x \n" , outvalue);
    //printf("Port= %x \n" , outport);

    outp32(outport,outvalue);


    //CONFIG_DATAWX^i0x0cfc`0x0cffACӂ̃TCYARead/Writej
    inport = PCI_CONFIG_DATA_ADDR;
    *InValue = inp32(inport);

    //Cl[urbg̃NA
    outp32(outport,0);

    return 0;
}




/*!
    \brief IsLineSeparator
        Zp[^

    \param  char ch [IN] LN^
    \return bool Zp[^Ȃtrue ȊOȂfalse
    \author Tino
    \date   create:2004/06/111 update:2004/06/11
*/

inline bool IsLineSeparator(char ch)
{
    return ch == '\r' || ch == '\n' || ch == '\0';
}


/*!
    \brief getPciInfName
        PCI񖼏(x_[AfoCX)擾
        PCIWX^l ɂƂAPCIINF.TXT Yx_[̃x_̂擾BB
    \param  byte* PciInfData [IN] PCIf[^
    \param  dword InValue [IN] PCIWX^l(x_[CD & foCXCD)
    \param  CString& VendorName [OUT] x_[
    \param  CString& DeviceName [OUT] foCX

    \return MonAPI::CString dummy(_~[߂l)

    \author Yamami
    \date   create:2004/05/16 update:2004/06/11
*/

CString getPciInfName( byte* PciInfData, dword InValue , CString* VendorName , CString* DeviceName){

    word Vendor;
    word Device;

    //x_[ID̎擾
    Vendor = InValue & 0x0000FFFF;
    Device = InValue >> 16;

    char VendorHex[5];    //x_[CDi[p
    char DeviceHex[5];    //x_[CDi[p
    sprintf(VendorHex, "%04X", Vendor);
    sprintf(DeviceHex, "%04X", Device);

    //NULL܂ŌJԂ
    while (*PciInfData != 0){

        //printf("%c",*PciInfData);

        //܂Ax_[̂T
        //CZp[^Ȃ玟̕
        if (IsLineSeparator(*PciInfData)){
            PciInfData++;
        }
        else if (strncmp((const char*)PciInfData, VendorHex, 4) == 0){
            const char* ps = (const char*)(PciInfData + 5), * pe = ps;
            for (; !IsLineSeparator(*pe); pe++);

            //return CString(ps, pe - ps);
            //x_[m
            *VendorName = CString(ps, pe - ps);

            //printf("%s\n",(const char*)VendorName);

            //x_[ȉ̃foCXB
            //1sǂݔ΂
            for (; !IsLineSeparator(*PciInfData); PciInfData++);
            while (*PciInfData != 0){
                if (IsLineSeparator(*PciInfData)){
                    PciInfData++;

                    //CZp[^̎^uȂAfoCX
                    if (strncmp((const char*)PciInfData, "\t", 1) == 0){
                        PciInfData++;
                        if (strncmp((const char*)PciInfData, DeviceHex, 4) == 0){
                            const char* ps = (const char*)(PciInfData + 5), * pe = ps;
                            for (; !IsLineSeparator(*pe); pe++);
                            *DeviceName = CString(ps, pe - ps);

                            //printf("%s\n",(const char*)DeviceName);

                            return "dumy";
                        }
                        else{
                            //̃foCX
                            for (; !IsLineSeparator(*PciInfData); PciInfData++);
                        }
                    }
                    //x_[ύX܂œǂŌȂAsƂB
                    else{
                        *DeviceName = "???";
                        //printf("%s\n",(const char*)DeviceName);
                        return "dumy";
                    }
                }
                else{
                    printf("tobashi\n");

                    //ǂɂYȂs͓ǂݔ΂
                    for (; !IsLineSeparator(*PciInfData); PciInfData++);
                }

            }
        }
        else{
            //ǂɂYȂs͓ǂݔ΂
            for (; !IsLineSeparator(*PciInfData); PciInfData++);
        }
    }

    // s
    *VendorName = "???";
    *DeviceName = "???";
    return "???";
}
