#include <monapi.h>
#include <monapi/messages.h>
#include "ReversiBoard.h"

using namespace MonAPI;

/*----------------------------------------------------------------------
    Monaץꥱ
----------------------------------------------------------------------*/
class myApplication : public MonaApplication, public Observer {

  public:
    myApplication();
    virtual ~myApplication() {}

  public:
    virtual int main(List<char*>* pekoe);
    virtual void onKeyDown(int keycode, int modifiers);
    virtual void onMouseClick(int x, int y);
    virtual void update(Observable* o, void* arg);

  public:
    virtual void init();
    virtual void drawBoard();
    virtual void drawPieces(int x, int y);

  public:
    static const int PIECE_SIZE = 40;

  protected:
    ReversiBoard* board;
    Screen* virtualScreen;
    Screen screen;

};

/*----------------------------------------------------------------------
    Mainؿ
----------------------------------------------------------------------*/
int MonaMain(List<char*>* pekoe) {

    return (new myApplication())->main(pekoe);
}

/*----------------------------------------------------------------------
    myApplication
----------------------------------------------------------------------*/

// 󥹥ȥ饯
myApplication::myApplication() : MonaApplication() {

    if (!monapi_register_to_server(ID_MOUSE_SERVER, MONAPI_TRUE))
    {
        printf("Reversi:Mouse regist error\n");
        exit(1);
    }
}

// main
int myApplication::main(List<char*>* pekoe) {

    // 
    init();

    // Ĥν֤
    drawBoard();

    // ٥ȤԤ
    run();
    return 0;
}

// Ĥ
void myApplication::drawBoard() {

    for (int x = 0; x < ReversiBoard::BOARDW; x++) {
        for (int y = 0; y < ReversiBoard::BOARDH; y++) {
            drawPieces(x, y);
        }
    }
}

// (x, y)ˤҤȤ
void myApplication::drawPieces(int x, int y) {

    int piece = this->board->getPiece(x, y);
    int s = PIECE_SIZE;

    // ΢ХåեVRAMž
    switch(piece) {

    case(ReversiBoard::BLACK):
        Screen::bitblt(&screen, x * s, y * s, s, s, virtualScreen, 0, 0);
        break;
    case(ReversiBoard::WHITE):
        Screen::bitblt(&screen, x * s, y * s, s, s, virtualScreen, s, 0);
        break;
    case(ReversiBoard::EMPTY):
        Screen::bitblt(&screen, x * s, y * s, s, s, virtualScreen, 2 * s, 0);
        break;
    default:
        break;
    }
}

// ϤϤʤ
void myApplication::onKeyDown(int keycode, int modifiers) {
}

// ޥå٥
void myApplication::onMouseClick(int x, int y) {

    // ĤΤɤå줿
    int bx = (x - x % PIECE_SIZE) / PIECE_SIZE;
    int by = (y - y % PIECE_SIZE) / PIECE_SIZE;

    // ϰϥå
    if (!board->checkRange(bx, by)) {
        return;
    }

    // ߤΥץ쥤䡼ޤ򤪤
    int current = board->getCurrentHand();
    if (!(board->setPiece(bx, by, current))) {
        return;
    }

    // Ҥä֤뤳ޤ示
    while (board->existNotReversedPieces()) {

        board->reverseNext();
    }

    // ץ쥤䡼Ƚ
    board->setNextHand();
}

// ĤƤѹäȤδؿΤ
void myApplication::update(Observable* o, void* arg) {

    if (arg == NULL) {
        drawBoard();
    } else {

        Point2D* point = (Point2D*)arg;
        sleep(100);
        drawPieces(point->x, point->y);
    }
}

void myApplication::init() {

    // Ĥ
    this->board = new ReversiBoard();

    // ĤѹäΤƤ餦
    this->board->addObserver(this);

    // ΢ХåեѤ˲ۥ꡼
    virtualScreen = new VirtualScreen(200 * 1024);

    // ʤȤݡݡʤ΢Хåե
    int s = PIECE_SIZE;
    int s1 = (int)(0.5 * s);
    virtualScreen->fillRect16(0, 0, s, s, Color::rgb(0x00, 0xFF, 0x00));
    virtualScreen->fillRect16(s , 0, s, s, Color::rgb(0x00, 0xFF, 0x00));
    virtualScreen->fillCircle16(s1 * 3, s1, s1 - 4, Color::rgb(0xFF, 0xFF, 0xFF));
    virtualScreen->fillCircle16(s1, s1, s1 - 4, Color::rgb(0x00, 0x00, 0x00));
    virtualScreen->fillRect16(s * 2, 0, s, s, Color::rgb(0x00, 0xFF, 0x00));

    for (int x = 0; x < 3 * s; x++) {
        virtualScreen->putPixel16(x, s - 1, Color::rgb(0x00, 0x00, 0x00));
    }

    for (int x = 0; x < 3 * s; x++) {
        virtualScreen->putPixel16(x, 0, Color::rgb(0x00, 0x00, 0x00));
    }

    for (int x = 0; x <= 3 * s; x += s) {
        for (int y = 0; y < 3 * s; y++) {
            virtualScreen->putPixel16(x - 1, y, Color::rgb(0x00, 0x00, 0x00));
        }
    }
}
