/*!
    \file  Pci.h
    \brief PCICu wb_

    class Pci

    Copyright (c) 2004 Yamami
    All rights reserved.
    License=MIT/X Licnese

    \author  Yamami 
    \version $Revision: 1.1 $
    \date   create:2004/10/15 update:$Date: 2004/10/18 09:09:44 $
*/

#ifndef _LIB_PCI_INF
#define _LIB_PCI_INF


#include <sys/types.h>
#include <monapi/CString.h>

using namespace MonAPI;

/*! 
 *  \struct PciPacket
 *  \brief PciPacket\ p
 *   //PCI CONFIG_ADDRESSWX^̒lݒ
 *   //bit0-1F0ɌŒ
 *   //bit2-7FWX^AhX
 *   //bit8-10F@\ԍ
 *   //bit11-15FfoCXԍ
 *   //bit16-23FoXԍ
 *   //bit24-30FU[uŁA0ɌŒ
 *   //bit31FCl[urbgŁA1ɌŒ
 *
 *   //WX^ rbgʒu 31,30EEEE0(32rbg)
 */
typedef union
{
   dword command;
   struct
   {
       unsigned reserved1 : 2;
       unsigned reg       : 6;
       unsigned function  : 3;
       unsigned device    : 5;
       unsigned bus       : 8;
       unsigned reserved2 : 7;
       unsigned enabled   : 1;
   } p;
} PciPacket;


/*! 
 *  \enum PciPacket
 *  \brief PCIfoCXe錾
 */
enum
{
   REG_CONFIG_ADDRESS = 0x0CF8,
   REG_CONFIG_DATA    = 0x0CFC,

   PCI_VENDOR_ID      = 0x00,
   PCI_DEVICE_ID      = 0x02,
   PCI_STATUS         = 0x06,
   PCI_REVISION       = 0x08,
   PCI_API            = 0x09,
   PCI_SUBCLASS       = 0x0a,
   PCI_BASECLASS      = 0x0b,
   PCI_HEADER         = 0x0e,
   PCI_BASE_ADDRESS1  = 0x10,
   PCI_BASE_ADDRESS2  = 0x14,
   PCI_BASE_ADDRESS3  = 0x18,
   PCI_BASE_ADDRESS4  = 0x1C,
   PCI_BASE_ADDRESS5  = 0x20,
   PCI_IRQ_LINE       = 0x3C,
   PCI_IRQ_PIN        = 0x3D
};


/*! 
 *  \struct PciInf
 *  \brief PciInf PCIfoCX\
 */
typedef struct
{
    int  Exist;       //݊mF(݂=0  , ݂Ȃ=0ȊO)
    byte DeviceNo;
    word Vendor;
    word Device;
    CString VendorName;
    CString DeviceName;
    dword BaseAd;
    dword  IrqLine;
} PciInf;



//sR[h
#define CHR_CRLF 0x0D0A


//GCAX錾
#define uchar unsigned char
#define int32 long
#define uint32 unsigned long
#define float32 float
#define int16 short
#define uint16 unsigned short




/*!
    Pci class
*/
class Pci
{
    
  public:
    
    //RXgN^
    Pci();
    ~Pci();

    PciInf* CheckPciExist(word , word );
    
  private:
    dword ReadConfig(byte , byte , byte , byte , byte );
    MonAPI::CString getPciInfName( byte* , dword , MonAPI::CString* , MonAPI::CString* );
    bool IsLineSeparator(char );
};




#endif
