/*
 * GetNewAddress.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.api;

import org.monache.lib.api.result.GetNewAddressResult;
import org.monache.lib.jsonrpc.JsonRPCClient;

/**
 * getnewaddress<br>
 * ウォレットに新しく受け取り用アドレスを作成するためのAPIです。
 * 
 * @author monache.org
 * @since 1.0
 */
public interface GetNewAddress extends CoinAPI {

	/**
	 * 新しく受け取り用のアドレスを作成します。
	 * 
	 * @param jsonRPCClient JSON-RPCクライアント
	 * @return 実行結果
	 * @throws CoinAPIException 失敗
	 * @since 1.0
	 */
	public GetNewAddressResult call(JsonRPCClient jsonRPCClient) throws CoinAPIException;

	/**
	 * 新しく受け取り用のアドレスを作成し、任意の口座名を設定します。
	 * 
	 * @param jsonRPCClient JSON-RPCクライアント
	 * @param account アドレスの口座名(ラベル)
	 * @return 実行結果
	 * @throws CoinAPIException 失敗
	 * @since 1.0
	 */
	public GetNewAddressResult call(JsonRPCClient jsonRPCClient, String account) throws CoinAPIException;
	
}
