/*
 * SendMany.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.api;

import java.math.BigDecimal;
import java.util.Map;

import org.monache.lib.api.result.SendManyResult;
import org.monache.lib.jsonrpc.JsonRPCClient;

/**
 * sendmany<br>
 * 送金元の口座名を指定して、複数の送金先に対し送金をするAPIです。
 * 
 * @author monache.org
 * @since 1.0
 */
public interface SendMany extends CoinAPI {

	
	public SendManyResult call(JsonRPCClient jsonRPCClient, String fromAccount, Map<String, BigDecimal> addressAmount) throws CoinAPIException;

	public SendManyResult call(JsonRPCClient jsonRPCClient, String fromAccount, Map<String, BigDecimal> addressAmount, Long minconf) throws CoinAPIException;

	public SendManyResult call(JsonRPCClient jsonRPCClient, String fromAccount, Map<String, BigDecimal> addressAmount, String comment) throws CoinAPIException;

	/**
	 * 複数のアドレスに対し、送金します。
	 * 
	 * @param jsonRPCClient JSON-RPCクライアント
	 * @param fromAccount 送金元口座(ラベル)
	 * @param addressAmount 送金先アドレス(アドレス名、金額)
	 * @param minconf
	 * @param comment
	 * @return 実行結果
	 * @throws CoinAPIException
	 * @since 1.0
	 */
	public SendManyResult call(JsonRPCClient jsonRPCClient, String fromAccount, Map<String, BigDecimal> addressAmount, Long minconf, String comment) throws CoinAPIException;
	
}
