/*
 * SendToAddress.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.api;

import java.math.BigDecimal;

import org.monache.lib.api.result.SendToAddressResult;
import org.monache.lib.jsonrpc.JsonRPCClient;

/**
 * sendtoaddress<br>
 * 送金をするAPIです。
 * 
 * @author monache.org
 * @since 1.0
 */
public interface SendToAddress extends CoinAPI {

	/**
	 * 送金します。
	 * 
	 * @param jsonRPCClient JSON-RPCクライアント
	 * @param toAddress 送金先アドレス
	 * @param amount 金額
	 * @return 実行結果
	 * @throws CoinAPIException 失敗
	 * @since 1.0
	 */
	public SendToAddressResult call(JsonRPCClient jsonRPCClient, String toAddress, BigDecimal amount) throws CoinAPIException;

	/**
	 * 送金します。
	 * 
	 * @param jsonRPCClient JSON-RPCクライアント
	 * @param toAddress
	 * @param amount
	 * @param comment
	 * @param commentTo
	 * @return
	 * @throws CoinAPIException
	 * @since 1.0
	 */
	public SendToAddressResult call(JsonRPCClient jsonRPCClient, String toAddress, BigDecimal amount, String comment, String commentTo) throws CoinAPIException;
}
