/*
 * DefaultCoinAPIFactory.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.api.impl;

import org.monache.lib.api.CoinAPIException;
import org.monache.lib.api.CoinAPIFactory;
import org.monache.lib.api.GetBalance;
import org.monache.lib.api.GetNewAddress;
import org.monache.lib.api.GetRawTransaction;
import org.monache.lib.api.GetTransaction;
import org.monache.lib.api.SendFrom;
import org.monache.lib.api.SendMany;
import org.monache.lib.api.SendToAddress;
import org.monache.lib.api.ValidateAddress;
import org.monache.lib.api.WalletLock;
import org.monache.lib.api.WalletPassphrase;

/**
 * デフォルトの暗号通貨用APIオブジェクトを生成するクラス。
 * DIコンテナを利用される場合は、本クラスを使わずにDIでAPIオブジェクトの生成をされることをお勧めします。
 * 
 * @author monache.org
 * @since 1.0
 */
public class DefaultCoinAPIFactory extends CoinAPIFactory {

	public static DefaultCoinAPIFactory newInstance() throws CoinAPIException {
		DefaultCoinAPIFactory factory =  new DefaultCoinAPIFactory();
		return factory;
	}

	/*
	 * (非 Javadoc)
	 * @see org.monache.lib.api.CoinAPIFactory#getWalletPassphrase()
	 * @since 1.0
	 */
	@Override
	public WalletPassphrase getWalletPassphrase() throws CoinAPIException {
		return new WalletPassphraseImpl();
	}

	/*
	 * (非 Javadoc)
	 * @see org.monache.lib.api.CoinAPIFactory#getWalletLock()
	 * @since 1.0
	 */
	@Override
	public WalletLock getWalletLock() throws CoinAPIException {
		return new WalletLockImpl();
	}

	/*
	 * (非 Javadoc)
	 * @see org.monache.lib.api.CoinAPIFactory#getGetNewAddress()
	 * @since 1.0
	 */
	@Override
	public GetNewAddress getGetNewAddress() throws CoinAPIException {
		return new GetNewAddressImpl();
	}

	/*
	 * (非 Javadoc)
	 * @see org.monache.lib.api.CoinAPIFactory#getGetBalance()
	 * @since 1.0
	 */
	@Override
	public GetBalance getGetBalance() throws CoinAPIException {
		return new GetBalanceImpl();
	}

	/*
	 * (非 Javadoc)
	 * @see org.monache.lib.api.CoinAPIFactory#getSendToAddress()
	 * @since 1.0
	 */
	@Override
	public SendToAddress getSendToAddress() throws CoinAPIException {
		return new SendToAddressImpl();
	}

	/*
	 * (非 Javadoc)
	 * @see org.monache.lib.api.CoinAPIFactory#getSendFrom()
	 * @since 1.0
	 */
	@Override
	public SendFrom getSendFrom() throws CoinAPIException {
		return new SendFromImpl();
	}

	/* (非 Javadoc)
	 * @see org.monache.lib.api.CoinAPIFactory#getGetRawTransaction()
	 * @since 1.0
	 */
	@Override
	public GetRawTransaction getGetRawTransaction() throws CoinAPIException {
		return new GetRawTransactionImpl();
	}

	/* (非 Javadoc)
	 * @see org.monache.lib.api.CoinAPIFactory#getValidateAddress()
	 * @since 1.0
	 */
	@Override
	public ValidateAddress getValidateAddress() throws CoinAPIException {
		return new ValidateAddressImpl();
	}

	/* (非 Javadoc)
	 * @see org.monache.lib.api.CoinAPIFactory#getGetTransaction()
	 * @since 1.0
	 */
	@Override
	public GetTransaction getGetTransaction() throws CoinAPIException {
		return new GetTransactionImpl();
	}

	/* (非 Javadoc)
	 * @see org.monache.lib.api.CoinAPIFactory#getSendMany()
	 * @since 1.0
	 */
	@Override
	public SendMany getSendMany() throws CoinAPIException {
		return new SendManyImpl();
	}


}
