/*
 * GetBalanceImpl.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.api.impl;

import org.monache.lib.api.AbstractCoinAPI;
import org.monache.lib.api.CoinAPIException;
import org.monache.lib.api.GetBalance;
import org.monache.lib.api.response.GetBalanceResponseObject;
import org.monache.lib.api.result.GetBalanceResult;
import org.monache.lib.jsonrpc.JsonRPCClient;
import org.monache.lib.jsonrpc.JsonRPCv1RequestObject;

/**
 * 
 * 
 * @author monache.org
 * @since 1.0
 */
public class GetBalanceImpl extends AbstractCoinAPI implements GetBalance {

	protected static final String METHOD = "getbalance";
	
	/**
	 * 
	 * @since 1.0
	 */
	public GetBalanceImpl() {
	}

	/*
	 * (非 Javadoc)
	 * @see org.monache.lib.api.GetBalance#call(org.monache.lib.jsonrpc.JsonRPCClient)
	 * @since 1.0
	 */
	public GetBalanceResult call(JsonRPCClient jsonRPCClient) throws CoinAPIException {
		return call(jsonRPCClient, null);
	}

	/*
	 * (非 Javadoc)
	 * @see org.monache.lib.api.GetBalance#call(org.monache.lib.jsonrpc.JsonRPCClient, java.lang.String)
	 * @since 1.0
	 */
	public GetBalanceResult call(JsonRPCClient jsonRPCClient, String account) throws CoinAPIException {
		return call(jsonRPCClient, account, null);
	}

	/*
	 * (非 Javadoc)
	 * @see org.monache.lib.api.GetBalance#call(org.monache.lib.jsonrpc.JsonRPCClient, java.lang.String, java.lang.Long)
	 * @since 1.0
	 */
	public GetBalanceResult call(JsonRPCClient jsonRPCClient, String account, Long minconf)
			throws CoinAPIException {
		try {
			if (jsonRPCClient == null) {
				throw new NullPointerException("jsonRPCClient is null.");
			}
			
			// request
			JsonRPCv1RequestObject requestObject = new JsonRPCv1RequestObject();
			requestObject.setMethod(METHOD);
			if (account == null && minconf == null) {
			} else if (account != null && minconf == null) {
				requestObject.setParams(new Object[]{account});
			} else {
				if (account == null) {
					account = ARG_UNSPECIFIED;
				}
				requestObject.setParams(new Object[]{account, minconf});
			}

			// JSON-RPC call
			return jsonRPCClient.call(requestObject, GetBalanceResponseObject.class).getResultObject();

		} catch (Exception e) {
			// JsonRPCException
			throw new CoinAPIException("Error: " + e.getMessage(), e);
		}
	}

}
