/*
 * GetBalanceImpl.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.api.impl;

import org.monache.lib.api.AbstractCoinAPI;
import org.monache.lib.api.CoinAPIException;
import org.monache.lib.api.GetTransaction;
import org.monache.lib.api.response.GetTransactionResponseObject;
import org.monache.lib.api.result.GetTransactionResult;
import org.monache.lib.jsonrpc.JsonRPCClient;
import org.monache.lib.jsonrpc.JsonRPCv1RequestObject;

/**
 * 
 * 
 * @author monache.org
 * @since 1.0
 */
public class GetTransactionImpl extends AbstractCoinAPI implements GetTransaction {

	protected static final String METHOD = "gettransaction";
	
	/**
	 * 
	 * @since 1.0
	 */
	public GetTransactionImpl() {
	}

	/* (非 Javadoc)
	 * @see org.monache.lib.api.ValidateAddress#call(org.monache.lib.jsonrpc.JsonRPCClient, java.lang.String)
	 * @since 1.0
	 */
	public GetTransactionResult call(JsonRPCClient jsonRPCClient,
			String transactionId) throws CoinAPIException {
		try {
			if (jsonRPCClient == null) {
				throw new NullPointerException("jsonRPCClient is null.");
			}
			if (transactionId == null || transactionId.length() == 0) {
				throw new NullPointerException("transactionId is null or empty.");
			}

			// request
			JsonRPCv1RequestObject requestObject = new JsonRPCv1RequestObject();
			requestObject.setMethod(METHOD);
			requestObject.setParams(new Object[]{transactionId});

			// JSON-RPC call
			return jsonRPCClient.call(requestObject, GetTransactionResponseObject.class).getResultObject();

		} catch (Exception e) {
			// JsonRPCException
			throw new CoinAPIException("Error: " + e.getMessage(), e);
		}
	}



}
