/*
 * SendManyImpl.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.api.impl;

import java.math.BigDecimal;
import java.util.Map;

import org.monache.lib.api.AbstractCoinAPI;
import org.monache.lib.api.CoinAPIException;
import org.monache.lib.api.SendMany;
import org.monache.lib.api.response.SendManyResponseObject;
import org.monache.lib.api.result.SendManyResult;
import org.monache.lib.jsonrpc.JsonRPCClient;
import org.monache.lib.jsonrpc.JsonRPCv1RequestObject;

/**
 * 
 * 
 * @author monache.org
 * @since 
 */
public class SendManyImpl extends AbstractCoinAPI implements SendMany {

	protected static final String METHOD = "sendmany";

	public SendManyImpl() {
	}

	/* (非 Javadoc)
	 * @see org.monache.lib.api.SendMany#call(org.monache.lib.jsonrpc.JsonRPCClient, java.lang.String, java.util.Map)
	 * @since 1.0
	 */
	public SendManyResult call(JsonRPCClient jsonRPCClient, String fromAccount,
			Map<String, BigDecimal> addressAmount) throws CoinAPIException {
		return call(jsonRPCClient, fromAccount, addressAmount, null, null);
	}

	/* (非 Javadoc)
	 * @see org.monache.lib.api.SendMany#call(org.monache.lib.jsonrpc.JsonRPCClient, java.lang.String, java.util.Map, java.lang.Integer)
	 * @since 1.0
	 */
	public SendManyResult call(JsonRPCClient jsonRPCClient, String fromAccount,
			Map<String, BigDecimal> addressAmount, Long minconf)
			throws CoinAPIException {
		return call(jsonRPCClient, fromAccount, addressAmount, minconf, null);
	}

	/* (非 Javadoc)
	 * @see org.monache.lib.api.SendMany#call(org.monache.lib.jsonrpc.JsonRPCClient, java.lang.String, java.util.Map, java.lang.String)
	 * @since 1.0
	 */
	public SendManyResult call(JsonRPCClient jsonRPCClient, String fromAccount,
			Map<String, BigDecimal> addressAmount, String comment)
			throws CoinAPIException {
		
		return call(jsonRPCClient, fromAccount, addressAmount, null, comment);

	}

	/* (非 Javadoc)
	 * @see org.monache.lib.api.SendMany#call(org.monache.lib.jsonrpc.JsonRPCClient, java.lang.String, java.util.Map, java.lang.Integer, java.lang.String)
	 * @since 1.0
	 */
	public SendManyResult call(JsonRPCClient jsonRPCClient, String fromAccount,
			Map<String, BigDecimal> addressAmount, Long minconf,
			String comment) throws CoinAPIException {

		try {
			if (jsonRPCClient == null) {
				throw new NullPointerException("jsonRPCClient is null.");
			}
			if (fromAccount == null || fromAccount.length() == 0) {
				throw new NullPointerException("fromAccount is null.");
			}
			if (addressAmount == null || addressAmount.size() == 0) {
				throw new NullPointerException("addressAmount is null.");
			}

			// request
			JsonRPCv1RequestObject requestObject = new JsonRPCv1RequestObject();
			requestObject.setMethod(METHOD);
			if (minconf == null && comment == null) {
				requestObject.setParams(new Object[]{fromAccount, addressAmount});
			} else {
				if (minconf == null) {
					minconf = new Long(1);
				}
				if (comment == null) {
					comment = "";
				}
				requestObject.setParams(new Object[]{fromAccount, addressAmount, minconf, comment});
			}

			// JSON-RPC call
			return jsonRPCClient.call(requestObject, SendManyResponseObject.class).getResultObject();

		} catch (Exception e) {
			// JsonRPCException
			throw new CoinAPIException("Error: " + e.getMessage(), e);
		}

	}

}
