/*
 * SendToAddressImpl.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.api.impl;

import java.math.BigDecimal;

import org.monache.lib.api.AbstractCoinAPI;
import org.monache.lib.api.CoinAPIException;
import org.monache.lib.api.SendToAddress;
import org.monache.lib.api.response.SendToAddressResponseObject;
import org.monache.lib.api.result.SendToAddressResult;
import org.monache.lib.jsonrpc.JsonRPCClient;
import org.monache.lib.jsonrpc.JsonRPCv1RequestObject;

/**
 * 
 * 
 * @author monache.org
 * @since 
 */
public class SendToAddressImpl extends AbstractCoinAPI implements SendToAddress {

	protected static final String METHOD = "sendtoaddress";

	public SendToAddressImpl() {
	}

	/*
	 * (非 Javadoc)
	 * @see org.monache.lib.api.SendToAddress#call(org.monache.lib.jsonrpc.JsonRPCClient, java.lang.String, java.math.BigDecimal)
	 * @since 1.0
	 */
	public SendToAddressResult call(JsonRPCClient jsonRPCClient,
			String toAddress, BigDecimal amount) throws CoinAPIException {
		return call(jsonRPCClient, toAddress, amount, null, null);
	}

	/*
	 * (非 Javadoc)
	 * @see org.monache.lib.api.SendToAddress#call(org.monache.lib.jsonrpc.JsonRPCClient, java.lang.String, java.math.BigDecimal, java.lang.String, java.lang.String)
	 * @since 1.0
	 */
	public SendToAddressResult call(JsonRPCClient jsonRPCClient,
			String toAddress, BigDecimal amount, String comment,
			String commentTo) throws CoinAPIException {

		try {
			if (jsonRPCClient == null) {
				throw new NullPointerException("jsonRPCClient is null.");
			}
			if (toAddress == null || toAddress.length() == 0) {
				throw new NullPointerException("toAddress is null or empty.");
			}
			if (amount == null) {
				throw new NullPointerException("amount is null.");
			}

			// request
			JsonRPCv1RequestObject requestObject = new JsonRPCv1RequestObject();
			requestObject.setMethod(METHOD);
			if (comment == null && commentTo == null) {
				requestObject.setParams(new Object[]{toAddress, amount});
			} else {
				if (comment == null) {
					comment = "";
				}
				if (commentTo == null) {
					commentTo = "";
				}
				requestObject.setParams(new Object[]{toAddress, amount, comment, commentTo});
			}

			// JSON-RPC call
			return jsonRPCClient.call(requestObject, SendToAddressResponseObject.class).getResultObject();

		} catch (Exception e) {
			// JsonRPCException
			throw new CoinAPIException("Error: " + e.getMessage(), e);
		}
	}

}
