/*
 * GetBalanceMock.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.api.mock;

import java.math.BigDecimal;

import org.monache.lib.api.AbstractCoinAPI;
import org.monache.lib.api.CoinAPIException;
import org.monache.lib.api.GetBalance;
import org.monache.lib.api.result.GetBalanceResult;
import org.monache.lib.jsonrpc.JsonRPCClient;

/**
 * 
 * 
 * @author monache.org
 * @since 1.0
 */
public class GetBalanceMock extends AbstractCoinAPI implements GetBalance {
	
	/**
	 * 
	 * @since 1.0
	 */
	public GetBalanceMock() {
	}

	/*
	 * (非 Javadoc)
	 * @see org.monache.lib.api.GetBalance#call(org.monache.lib.jsonrpc.JsonRPCClient)
	 * @since 1.0
	 */
	public GetBalanceResult call(JsonRPCClient jsonRPCClient) throws CoinAPIException {
		return call(jsonRPCClient, null);
	}

	/*
	 * (非 Javadoc)
	 * @see org.monache.lib.api.GetBalance#call(org.monache.lib.jsonrpc.JsonRPCClient, java.lang.String)
	 * @since 1.0
	 */
	public GetBalanceResult call(JsonRPCClient jsonRPCClient, String account) throws CoinAPIException {
		return call(jsonRPCClient, account, null);
	}

	/*
	 * (非 Javadoc)
	 * @see org.monache.lib.api.GetBalance#call(org.monache.lib.jsonrpc.JsonRPCClient, java.lang.String, java.lang.Long)
	 * @since 1.0
	 */
	public GetBalanceResult call(JsonRPCClient jsonRPCClient, String account, Long minconf)
			throws CoinAPIException {
		GetBalanceResult result = new GetBalanceResult();
		result.setBalance(new BigDecimal(getResult()));
		result.setJsonString("{\"result\":" + getResult() + ",\"error\":" + getError() + ",\"id\":" + getId() + "}");
		return result;
	}

	private String result = null;
	private String error = null;
	private String id = null;

	/**
	 * @return result
	 * @since 1.0
	 */
	public String getResult() {
		return result;
	}

	/**
	 * @param result セットする result
	 * @since 1.0
	 */
	public void setResult(String result) {
		this.result = result;
	}

	/**
	 * @return error
	 * @since 1.0
	 */
	public String getError() {
		return error;
	}

	/**
	 * @param error セットする error
	 * @since 1.0
	 */
	public void setError(String error) {
		this.error = error;
	}

	/**
	 * @return id
	 * @since 1.0
	 */
	public String getId() {
		return id;
	}

	/**
	 * @param id セットする id
	 * @since 1.0
	 */
	public void setId(String id) {
		this.id = id;
	}

	
	

}
