/*
 * ResponseObject.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.api.response;

import org.monache.lib.jsonrpc.JsonRPCErrorObject;
import org.monache.lib.jsonrpc.JsonRPCResponseObject;

/**
 * 
 * 
 * @author monache.org
 * @since 1.0
 */
public abstract class ResponseObject extends JsonRPCResponseObject {

	private JsonRPCErrorObject error = null;
	private String id = null;

	/**
	 * @return error
	 * @since 1.0
	 */
	public JsonRPCErrorObject getError() {
		return error;
	}
	/**
	 * @param error セットする error
	 * @since 1.0
	 */
	public void setError(JsonRPCErrorObject error) {
		this.error = error;
	}
	/**
	 * @return id
	 * @since 1.0
	 */
	public String getId() {
		return id;
	}
	/**
	 * @param id セットする id
	 * @since 1.0
	 */
	public void setId(String id) {
		this.id = id;
	}
}
