/*
 * Details.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.api.result;

import java.math.BigDecimal;

import org.monache.lib.json.JsonMember;

/**
 * 
 * 
 * @author monache.org
 * @since 1.0
 */
public class Details {

	@JsonMember(name="account")
	private String account = null;
	@JsonMember(name="address")
	private String address = null;
	@JsonMember(name="category")
	private String category = null;
	@JsonMember(name="amount")
	private BigDecimal amount = null;
	@JsonMember(name="fee")
	private BigDecimal fee = null;
	
	/**
	 * 
	 * @since 1.0
	 */
	public Details() {
		// TODO 自動生成されたコンストラクター・スタブ
	}

	/**
	 * @return account
	 * @since 1.0
	 */
	public String getAccount() {
		return account;
	}

	/**
	 * @param account セットする account
	 * @since 1.0
	 */
	public void setAccount(String account) {
		this.account = account;
	}

	/**
	 * @return address
	 * @since 1.0
	 */
	public String getAddress() {
		return address;
	}

	/**
	 * @param address セットする address
	 * @since 1.0
	 */
	public void setAddress(String address) {
		this.address = address;
	}

	/**
	 * @return category
	 * @since 1.0
	 */
	public String getCategory() {
		return category;
	}

	/**
	 * @param category セットする category
	 * @since 1.0
	 */
	public void setCategory(String category) {
		this.category = category;
	}

	/**
	 * @return amount
	 * @since 1.0
	 */
	public BigDecimal getAmount() {
		return amount;
	}

	/**
	 * @param amount セットする amount
	 * @since 1.0
	 */
	public void setAmount(BigDecimal amount) {
		this.amount = amount;
	}

	/**
	 * @return fee
	 * @since 1.0
	 */
	public BigDecimal getFee() {
		return fee;
	}

	/**
	 * @param fee セットする fee
	 * @since 1.0
	 */
	public void setFee(BigDecimal fee) {
		this.fee = fee;
	}

	
}
