/*
 * ValidateAddressResult.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.api.result;

import org.monache.lib.json.JsonMember;

/**
 * 
 * 
 * @author monache.org
 * @since 1.0
 */
public class ValidateAddressResult {

	// JSON文字列
	private String jsonString = null;

	// ただしアドレスの場合はtrue、それ以外はfalse
	@JsonMember(name="isvalid")
	private Boolean isvalid = false;
	
	// 検証したアドレス
	@JsonMember(name="address")
	private String address = null;
	
	// 自身のウォレットのアドレスの場合はtrue、それ以外はfalse
	@JsonMember(name="ismine")
	private Boolean ismine = false;
	
	// 以下は自身のアドレスの場合のみ
	
	@JsonMember(name="isscript")
	private Boolean isscript = false;
	
	// 
	@JsonMember(name="publey")
	private String publey = null;
	
	// 
	@JsonMember(name="iscompressed")
	private Boolean iscompressed = false;
	
	// 口座名(ラベル名)
	@JsonMember(name="account")
	private String account = null;

	/**
	 * @return jsonString
	 * @since 1.0
	 */
	public String getJsonString() {
		return jsonString;
	}

	/**
	 * @param jsonString セットする jsonString
	 * @since 1.0
	 */
	public void setJsonString(String jsonString) {
		this.jsonString = jsonString;
	}

	/**
	 * @return isvalid
	 * @since 1.0
	 */
	public Boolean getIsvalid() {
		return isvalid;
	}

	/**
	 * @param isvalid セットする isvalid
	 * @since 1.0
	 */
	public void setIsvalid(Boolean isvalid) {
		this.isvalid = isvalid;
	}

	/**
	 * @return address
	 * @since 1.0
	 */
	public String getAddress() {
		return address;
	}

	/**
	 * @param address セットする address
	 * @since 1.0
	 */
	public void setAddress(String address) {
		this.address = address;
	}

	/**
	 * @return ismine
	 * @since 1.0
	 */
	public Boolean getIsmine() {
		return ismine;
	}

	/**
	 * @param ismine セットする ismine
	 * @since 1.0
	 */
	public void setIsmine(Boolean ismine) {
		this.ismine = ismine;
	}

	/**
	 * @return isscript
	 * @since 1.0
	 */
	public Boolean getIsscript() {
		return isscript;
	}

	/**
	 * @param isscript セットする isscript
	 * @since 1.0
	 */
	public void setIsscript(Boolean isscript) {
		this.isscript = isscript;
	}

	/**
	 * @return publey
	 * @since 1.0
	 */
	public String getPubley() {
		return publey;
	}

	/**
	 * @param publey セットする publey
	 * @since 1.0
	 */
	public void setPubley(String publey) {
		this.publey = publey;
	}

	/**
	 * @return iscompressed
	 * @since 1.0
	 */
	public Boolean getIscompressed() {
		return iscompressed;
	}

	/**
	 * @param iscompressed セットする iscompressed
	 * @since 1.0
	 */
	public void setIscompressed(Boolean iscompressed) {
		this.iscompressed = iscompressed;
	}

	/**
	 * @return account
	 * @since 1.0
	 */
	public String getAccount() {
		return account;
	}

	/**
	 * @param account セットする account
	 * @since 1.0
	 */
	public void setAccount(String account) {
		this.account = account;
	}

	
}
