/*
 * JSonicHelper.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package dustbox.org.monache.lib.json;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.monache.lib.fw.IllegalImplementException;
import org.monache.lib.json.JsonMember;

/**
 *
 * 
 * @author monache.org
 * @since 1.0
 */
@Deprecated
public class JsonUtil {

	@Deprecated 
	public static <T> T newObject(Object obj, Class<T> newClass)
			throws SecurityException, IllegalImplementException {

		// オブジェクトを生成、必ずPOJOでなければならない
		T ret = null;
		try {
			ret = newClass.getConstructor().newInstance();
		} catch (SecurityException e) {
			throw e;
		} catch (Exception e) {
			throw new IllegalImplementException(e);
		}

		for (Field field : newClass.getDeclaredFields()) {
			Annotation ano = field.getAnnotation(JsonMember.class);
			if ( ano == null) {
				continue;
			}
			JsonMember jsonMember = (JsonMember) ano;
			try {
				Object arg = null;
				// 値がJSONの場合
				if (obj instanceof Map) {
					Map<?,?> jsonMap = (Map<?, ?>) obj;
					arg = jsonMap.get(jsonMember.name());
					if (arg instanceof Map) {
						arg = newObject((Map<?, ?>) arg, field.getType());

					} else if (arg instanceof List) {
						arg = newObjectList((List<?>) arg, field.getType().getComponentType());
					}

				// 値が配列の場合
				} else if (obj instanceof List) {
					arg = newObjectList((List<?>) obj, field.getType().getComponentType());
					
				} else {
					arg = obj;
				}
				if (arg != null) {
					if (arg.getClass() == BigDecimal.class) {
						if (field.getType() == BigInteger.class) {
							arg = ((BigDecimal)arg).toBigInteger();
						} else if (field.getType() == Integer.class) {
							arg = ((BigDecimal)arg).intValue();
						} else if (field.getType() == Long.class) {
							arg = ((BigDecimal)arg).longValue();
						}
					}
				}
				field.set(ret, arg);

			} catch (SecurityException e) {
				throw e;
			} catch (Exception e) {
				throw new IllegalImplementException(e);
			}
		}
		
		return ret;
	}

	@Deprecated
	@SuppressWarnings("unchecked")
	private static <T> T[] newObjectList(List<?> list, Class<T> newClass) 
			throws SecurityException, IllegalImplementException {
		List<T> retList = new ArrayList<T>();
		for (Object obj : list) {
			if (obj instanceof Map) {
				retList.add((T) newObject(obj, newClass));
			} else {
				retList.add((T) obj);
			}
		}

		T[] retArray = (T[]) Array.newInstance(newClass, retList.size());
		for (int i = 0; i < retArray.length; i++) {
			retArray[i] = retList.get(i);
		}
		
		return retArray;
	}

}
