/*
 * Decompiled with CFR 0.152.
 */
package monalipse.server.giko;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import monalipse.MonalipsePlugin;
import monalipse.editors.ThreadViewerEditor;
import monalipse.server.BBSServerManager;
import monalipse.server.IBBSBoard;
import monalipse.server.IBBSReference;
import monalipse.server.ILinkedLineFragment;
import monalipse.server.IResponseEnumeration;
import monalipse.server.IThreadContentProvider;
import monalipse.server.LinkedObject;
import monalipse.server.Response;
import monalipse.server.giko.Board;
import monalipse.server.giko.GikoServer;
import monalipse.utils.CancelableRunner;
import monalipse.widgets.ColoredText;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

class ThreadContentProvider
implements IAdaptable,
IThreadContentProvider,
IBBSReference {
    private static final Logger logger = MonalipsePlugin.getLogger();
    private static HttpClient SUBMIT_HTTP_CLIENT = GikoServer.createHttpClient();
    private static long serverTime = System.currentTimeMillis();
    private Board board;
    private URL boardURL;
    private String urlHint;
    private String id;
    private int index;
    private String name;
    private int responses;
    private Prefetcher prefetcher;
    private static final PatternAction NUM_REF_PATTERN = new PatternAction(Pattern.compile("(>|\uff1e)+(([0-9\uff10-\uff19]+)(->*([0-9\uff10-\uff19]+))?)")){

        public String getLink(String urlBase, Matcher m) {
            String start = ThreadContentProvider.toASCIIDigits(m.group(3));
            String end = m.group(5);
            end = end == null ? start : ThreadContentProvider.toASCIIDigits(end);
            return String.valueOf(urlBase) + start + "-" + end;
        }
    };
    private static final PatternAction NAME_NUM_REF_PATTERN = new PatternAction(Pattern.compile("[0-9\uff10-\uff19]+")){

        public String getLink(String urlBase, Matcher m) {
            String num = ThreadContentProvider.toASCIIDigits(m.group());
            return String.valueOf(urlBase) + num + "-" + num;
        }

        public boolean next(Matcher m) {
            return m.matches();
        }

        public boolean isLink() {
            return false;
        }
    };
    private static final PatternAction TRIP_DECL_PATTERN = new PatternAction(Pattern.compile("\u25c6([\\p{Alnum}\\./]{8,10})")){

        public String getLink(String urlBase, Matcher m) {
            return "trip:" + m.group(1);
        }

        public boolean next(Matcher m) {
            return m.find();
        }

        public boolean isLink() {
            return false;
        }
    };
    private static final PatternAction URL_REF_PATTERN = new PatternAction(Pattern.compile("(((h?t)?t)?p)?(s?://\\p{Alnum}[\\p{Alnum}\\.\\-_:]+(/[\\p{Alnum}!#%&'*+,-./:;=?@\\\\^_`\\|~]*)?)")){

        public String getLink(String urlBase, Matcher m) {
            return "http" + m.group(4);
        }
    };
    private static final PatternAction ID_DECL_PATTERN = new PatternAction(Pattern.compile("ID:(.{8})")){

        public String getLink(String urlBase, Matcher m) {
            return "id:" + m.group(1).trim();
        }

        public boolean isLink() {
            return false;
        }
    };
    private static final PatternAction[] NAME_PATTERN_SET = new PatternAction[]{NUM_REF_PATTERN, NAME_NUM_REF_PATTERN, TRIP_DECL_PATTERN};
    private static final PatternAction[] MAIL_PATTERN_SET = new PatternAction[]{NUM_REF_PATTERN};
    private static final PatternAction[] DATE_PATTERN_SET = new PatternAction[]{ID_DECL_PATTERN};
    private static final PatternAction[] BODY_PATTERN_SET = new PatternAction[]{NUM_REF_PATTERN, URL_REF_PATTERN};
    static /* synthetic */ Class class$0;

    public ThreadContentProvider(Board board, URL boardURL, String id, int index, String name, int responses) {
        this.board = board;
        this.boardURL = boardURL;
        this.id = id;
        this.index = index;
        this.name = name;
        this.responses = responses;
    }

    public boolean isActive() {
        return this.board.containsID(this.id);
    }

    private String getURLHint() {
        if (this.urlHint == null) {
            String baseURL = this.boardURL.toExternalForm();
            int ss = baseURL.indexOf("//");
            if (ss != -1 && this.id.endsWith(".dat")) {
                int s = baseURL.indexOf(47, ss + 2);
                this.urlHint = String.valueOf(baseURL.substring(0, s)) + "/test/read.cgi" + baseURL.substring(s, baseURL.length()) + this.id.substring(0, this.id.length() - 4) + "/";
            } else {
                this.urlHint = "";
            }
        }
        return this.urlHint;
    }

    public URL getURL() {
        try {
            return new URL(String.valueOf(this.getURLHint()) + "l50");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public IFolder getLogFolder() {
        return this.board.getLogFolder();
    }

    public IFile getLogFile() {
        return this.getLogFolder().getFile(this.id);
    }

    public IBBSBoard getBoard() {
        return this.board;
    }

    public String getID() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getResponses(null, 0, 0);
        }
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public int getResponseNumber() {
        return -1;
    }

    public int getResponseCountHint() {
        return this.responses;
    }

    public boolean hasNewResponses() {
        int cached = this.getCachedCount();
        return cached > 0 && cached < this.getResponseCountHint();
    }

    public boolean threadChanged(IResourceChangeEvent event) {
        return MonalipsePlugin.resourceModified(7, event.getDelta(), (IResource)this.getLogFile());
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ThreadContentProvider) {
            ThreadContentProvider thread = (ThreadContentProvider)obj;
            return thread.getLogFolder().equals((Object)this.getLogFolder()) && thread.getID().equals(this.getID());
        }
        return false;
    }

    public LinkedObject[] getLinkedObjects() {
        ArrayList list = new ArrayList();
        LogFile log = null;
        try {
            IFile file = this.getLogFile();
            MonalipsePlugin.ensureSynchronized(file);
            if (file.exists() && (log = LogFile.of(new DataInputStream(new BufferedInputStream(file.getContents())))) != null) {
                int i = 0;
                while (i < log.responseCount) {
                    log.readLinkedObject(this, list);
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (log != null) {
            log.close();
        }
        LinkedObject[] objects = new LinkedObject[list.size()];
        list.toArray(objects);
        return objects;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean submitResponse(CancelableRunner.ICancelableProgressMonitor monitor, String name, String mail, String body) {
        HttpClient httpClient = SUBMIT_HTTP_CLIENT;
        synchronized (httpClient) {
            monitor.beginTask("submitting...", 6);
            try {
                try {
                    boolean bl;
                    monitor.worked(1);
                    URL url = new URL(this.getBoard().getURL(), "../test/bbs.cgi");
                    String success = "\u66f8\u304d\u3053\u307f\u307e\u3057\u305f";
                    String retry = "\u78ba\u8a8d";
                    BBSServerManager.configureHttpClient(SUBMIT_HTTP_CLIENT, url);
                    monitor.subTask("POST");
                    PostMethod post = this.createResponsePostData(monitor, url, name, mail, body);
                    try {
                        boolean res;
                        this.removePathAttribute(SUBMIT_HTTP_CLIENT);
                        SUBMIT_HTTP_CLIENT.executeMethod((HttpMethod)post);
                        MonalipsePlugin.log(logger, (HttpMethod)post);
                        String resp = post.getResponseBodyAsString();
                        System.err.println(resp);
                        if (resp.indexOf(retry) != -1) {
                            monitor.subTask("retry POST with sid");
                            post.releaseConnection();
                            post = this.createResponsePostData(monitor, url, name, mail, body);
                            Matcher m = Pattern.compile("name.*=.*time.*value.*=[^\\p{Digit}]*(\\p{Digit}+)").matcher(resp);
                            if (m.find()) {
                                post.removeParameter("time");
                                post.addParameter("time", m.group(1));
                                serverTime = Long.parseLong(m.group(1));
                                try {
                                    Thread.sleep(6000L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            BBSServerManager.configureHttpClient(SUBMIT_HTTP_CLIENT, url);
                            this.removePathAttribute(SUBMIT_HTTP_CLIENT);
                            SUBMIT_HTTP_CLIENT.executeMethod((HttpMethod)post);
                            MonalipsePlugin.log(logger, (HttpMethod)post);
                            System.err.println(post.getResponseBodyAsString());
                        }
                        boolean bl2 = res = post.getResponseBodyAsString().indexOf(success) != -1;
                        if (!res) {
                            SUBMIT_HTTP_CLIENT = GikoServer.createHttpClient();
                        }
                        bl = res;
                        Object var12_17 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_18 = null;
                        post.releaseConnection();
                        throw throwable;
                    }
                    post.releaseConnection();
                    Object var15_19 = null;
                    monitor.done();
                    return bl;
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Object var15_21 = null;
            }
            catch (Throwable throwable) {
                Object var15_20 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return false;
        }
    }

    private void removePathAttribute(HttpClient hc) {
        Cookie[] c = hc.getState().getCookies();
        int i = 0;
        while (i < c.length) {
            c[i].setPathAttributeSpecified(false);
            ++i;
        }
    }

    private PostMethod createResponsePostData(CancelableRunner.ICancelableProgressMonitor monitor, URL url, String name, String mail, String body) {
        PostMethod post = GikoServer.createPostMethod();
        post.setPath(url.getFile());
        post.setRequestHeader("Referer", this.getBoard().getURL().toExternalForm());
        String bbs = this.getBoard().getURL().getFile();
        post.addParameter("submit", "\u66f8\u304d\u8fbc\u3080");
        post.addParameter("bbs", bbs.substring(1, bbs.length() - 1));
        post.addParameter("key", this.id.substring(0, this.id.lastIndexOf(46)));
        post.addParameter("time", String.valueOf(serverTime));
        post.addParameter("FROM", name);
        post.addParameter("mail", mail);
        post.addParameter("MESSAGE", body);
        return post;
    }

    public IResponseEnumeration getResponses(CancelableRunner.ICancelableProgressMonitor monitor, int sequence, int rangeStart, boolean prefetch) {
        LogFile log = null;
        try {
            IFile file = this.getLogFile();
            MonalipsePlugin.ensureSynchronized(file);
            if (file.exists() && (log = LogFile.of(new DataInputStream(new BufferedInputStream(file.getContents())))) != null) {
                boolean partial;
                if (prefetch) {
                    this.prefetcher = PartialPrefetcher.create(log, new URL(this.board.getURL(), "dat/" + this.id));
                }
                boolean bl = partial = log.sequence == sequence;
                if (partial) {
                    try {
                        if (log.responseCount < rangeStart) {
                            throw new IOException();
                        }
                        int i = 0;
                        while (i < rangeStart) {
                            log.skipResponse();
                            ++i;
                        }
                    }
                    catch (IOException iOException) {
                        log.close();
                        log = LogFile.of(new DataInputStream(new BufferedInputStream(file.getContents())));
                        return new ThreadLogReader(monitor, log.title, log, false, log.sequence, log.isActive);
                    }
                }
                return new ThreadLogReader(monitor, log.title, log, partial, log.sequence, log.isActive);
            }
            if (prefetch) {
                this.prefetcher = FullPrefetcher.create(new URL(this.board.getURL(), "dat/" + this.id));
            }
        }
        catch (CoreException e) {
            this.releasePrefetcher();
            e.printStackTrace();
        }
        catch (IOException e) {
            this.releasePrefetcher();
            e.printStackTrace();
        }
        if (log != null) {
            log.close();
        }
        return new NullResponseEnumeration(this.getURL().toExternalForm(), sequence);
    }

    private void releasePrefetcher() {
        if (this.prefetcher != null) {
            this.prefetcher.release();
            this.prefetcher = null;
        }
    }

    /*
     * Exception decompiling
     */
    public String getResponses(List responseReceiver, int start, int end) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 187->190)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IResponseEnumeration updateResponses(CancelableRunner.ICancelableProgressMonitor monitor, int sequence, int rangeStart) {
        AccessContext context = new AccessContext();
        context.progressRemaining = 100;
        context.title = this.getURL().toExternalForm();
        monitor.beginTask("downloading...", context.progressRemaining);
        try {
            IResponseEnumeration e = this.getPartialContent(monitor, sequence, rangeStart, context);
            if (e != null) {
                return e;
            }
            ++sequence;
            if (!context.notFound) {
                e = this.getFullContent(monitor, sequence, rangeStart, context);
                if (e != null) {
                    return e;
                }
            } else {
                this.releasePrefetcher();
            }
            ArrayList<String> boardURLs = new ArrayList<String>();
            boardURLs.add(this.getBoard().getURL().toExternalForm());
            if (!boardURLs.contains(this.boardURL.toExternalForm())) {
                boardURLs.add(this.boardURL.toExternalForm());
            }
            String[] obs = this.board.getObsoleteURLs();
            int i = 0;
            while (i < obs.length) {
                if (!boardURLs.contains(obs[i])) {
                    boardURLs.add(obs[i]);
                }
                ++i;
            }
            i = 0;
            while (i < boardURLs.size()) {
                try {
                    URL url = new URL((String)boardURLs.get(i));
                    e = this.getPublicLogContent(monitor, sequence, rangeStart, context, url);
                    if (e != null) {
                        return e;
                    }
                    e = this.getOysterLogContent(monitor, sequence, rangeStart, context, url);
                    if (e != null) {
                        return e;
                    }
                }
                catch (MalformedURLException malformedURLException) {}
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new NullResponseEnumeration(context.title, sequence);
    }

    private static String getResponseHeaderString(Header header) {
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IResponseEnumeration getPartialContent(CancelableRunner.ICancelableProgressMonitor monitor, int sequence, int rangeStart, AccessContext context) throws IOException {
        file = this.getLogFile();
        try {
            block23: {
                MonalipsePlugin.ensureSynchronized(file);
                if (file.exists() == false) return null;
                log = LogFile.of(new DataInputStream(new BufferedInputStream(file.getContents())));
                try {
                    block22: {
                        if (log == null) ** GOTO lbl-1000
                        url = new URL(this.board.getURL(), "dat/" + this.id);
                        if (this.prefetcher == null) {
                            this.prefetcher = PartialPrefetcher.create(log, url);
                        }
                        context.title = log.title;
                        context.lastModified = log.lastModified;
                        v0 = partial = log.sequence == sequence;
                        if (!partial) ** GOTO lbl-1000
                        logs = new ArrayList<Response>();
                        lastResponse = null;
                        if (rangeStart <= log.responseCount) {
                            while (log.available()) {
                                lastResponse = log.readResponse();
                                logs.add(lastResponse);
                            }
                        }
                        context.progressRemaining -= 10;
                        monitor.worked(10);
                        monitor.subTask("GET " + url);
                        get = this.prefetcher.getResult();
                        try {
                            if (lastResponse == null) ** GOTO lbl70
                            if (get.getStatusLine().getStatusCode() != 206) ** GOTO lbl59
                            cin = new RangeAnalyzeInputStream(log.httpRangeStart, get.getResponseBodyAsStream());
                            r = new BufferedReader(new InputStreamReader((InputStream)cin, "Windows-31J"));
                            contentLength = Integer.parseInt(ThreadContentProvider.getResponseHeaderString(get.getResponseHeader("Content-Length")));
                            resp = LogFile.parseResponse(r, logs.size(), this.getURLHint(), null);
                            if (resp != null && lastResponse.equals(resp)) {
                                e = new ThreadDownloader(monitor.getRunner().getSubProgressMonitor(monitor, context.progressRemaining), log.title, (HttpMethod)get, r, cin, true, log.sequence, ThreadContentProvider.getResponseHeaderString(get.getResponseHeader("Last-Modified")), logs, rangeStart, contentLength, file, true);
                                get = null;
                                var19_20 = e;
                                var17_22 = null;
                                if (get == null) break block22;
                            }
                            ** GOTO lbl-1000
                        }
                        catch (Throwable var18_30) {
                            var17_24 = null;
                            if (get == null) throw var18_30;
                            get.releaseConnection();
                            throw var18_30;
                        }
                        get.releaseConnection();
                    }
                    var20_26 = null;
                    if (log != null) {
                        log.close();
                    }
                    this.prefetcher = null;
                    return var19_20;
lbl-1000:
                    // 1 sources

                    {
                        r.close();
                        ** GOTO lbl70
lbl59:
                        // 1 sources

                        if (get.getStatusLine().getStatusCode() != 304) ** GOTO lbl-1000
                        var19_21 = new ArrayThreadReader(log.title, true, log.sequence, logs, rangeStart, true);
                        var17_23 = null;
                        if (get == null) break block23;
                    }
                    get.releaseConnection();
                    break block23;
lbl-1000:
                    // 1 sources

                    {
                        if (get.getStatusLine().getStatusCode() != 404 && get.getStatusLine().getStatusCode() != 302) ** GOTO lbl70
                        context.notFound = true;
                    }
                    {
lbl70:
                        // 4 sources

                        var17_25 = null;
                        if (get != null) {
                            get.releaseConnection();
                        }
                        ** GOTO lbl-1000
                    }
                }
                catch (Throwable var21_31) {
                    var20_28 = null;
                    if (log != null) {
                        log.close();
                    }
                    this.prefetcher = null;
                    throw var21_31;
                }
            }
            var20_27 = null;
            if (log != null) {
                log.close();
            }
            this.prefetcher = null;
            return var19_21;
lbl-1000:
            // 3 sources

            {
                var20_29 = null;
                if (log != null) {
                    log.close();
                }
                this.prefetcher = null;
                return null;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
        catch (HttpException e) {
            e.printStackTrace();
            context.lastModified = null;
        }
        return null;
    }

    private IResponseEnumeration getFullContent(CancelableRunner.ICancelableProgressMonitor monitor, int sequence, int rangeStart, AccessContext context) throws IOException {
        context.progressRemaining -= 10;
        monitor.worked(10);
        try {
            URL url = new URL(this.board.getURL(), "dat/" + this.id);
            monitor.subTask("GET " + url);
            logger.finest("full " + url);
            if (this.prefetcher == null) {
                return this.getResponse(url, (HttpMethod)GikoServer.createGetMethod(), context.lastModified, monitor.getRunner().getSubProgressMonitor(monitor, context.progressRemaining), context.title, sequence, this.getLogFile(), false, true);
            }
            return this.getPrefetchedResponse(monitor, context.title, sequence, this.getLogFile(), false, true);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private IResponseEnumeration getPublicLogContent(CancelableRunner.ICancelableProgressMonitor monitor, int sequence, int rangeStart, AccessContext context, URL boardURL) throws IOException {
        context.progressRemaining -= 10;
        monitor.worked(10);
        try {
            void var6_6;
            URL url;
            if (14 <= this.id.length()) {
                url = new URL(boardURL, "kako/" + this.id.substring(0, 4) + "/" + this.id.substring(0, 5) + "/" + this.id + ".gz");
            } else if (this.id.length() == 13) {
                url = new URL(boardURL, "kako/" + this.id.substring(0, 3) + "/" + this.id + ".gz");
            } else {
                return null;
            }
            monitor.subTask("GET " + var6_6);
            logger.finest("log " + var6_6);
            return this.getResponse((URL)var6_6, (HttpMethod)GikoServer.createGetMethod(), context.lastModified, monitor.getRunner().getSubProgressMonitor(monitor, context.progressRemaining), context.title, sequence, this.getLogFile(), false, false);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private IResponseEnumeration getOysterLogContent(CancelableRunner.ICancelableProgressMonitor monitor, int sequence, int rangeStart, AccessContext context, URL boardURL) throws IOException {
        String sid = GikoServer.getOysterSessionID(monitor.getRunner().getSubProgressMonitor(monitor, 10));
        context.progressRemaining -= 10;
        if (sid != null) {
            context.progressRemaining -= 10;
            monitor.worked(10);
            try {
                URL url = new URL(boardURL, "/test/offlaw.cgi");
                GetMethod get = GikoServer.createGetMethod();
                String bbs = boardURL.getFile();
                get.setQueryString(new NameValuePair[]{new NameValuePair("bbs", bbs.substring(1, bbs.length() - 1)), new NameValuePair("key", this.id.substring(0, this.id.lastIndexOf(46))), new NameValuePair("sid", sid), new NameValuePair("raw", "0.0")});
                monitor.subTask("GET " + url);
                logger.finest("oyster " + url);
                return this.getResponse(url, (HttpMethod)get, context.lastModified, monitor.getRunner().getSubProgressMonitor(monitor, context.progressRemaining), context.title, sequence, this.getLogFile(), true, false);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private IResponseEnumeration getResponse(URL url, HttpMethod method, String lastModified, CancelableRunner.ICancelableProgressMonitor monitor, String title, int sequence, IFile file, boolean oyster, boolean active) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 165->171)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IResponseEnumeration getPrefetchedResponse(CancelableRunner.ICancelableProgressMonitor monitor, String title, int sequence, IFile file, boolean oyster, boolean active) throws IOException {
        try {
            GetMethod method;
            block12: {
                NullResponseEnumeration nullResponseEnumeration;
                block13: {
                    IResponseEnumeration iResponseEnumeration;
                    block10: {
                        block11: {
                            method = null;
                            try {
                                method = this.prefetcher.getResult();
                                if (method.getStatusCode() == 200) {
                                    IResponseEnumeration e = this.createDownloader((HttpMethod)method, monitor, title, sequence, file, oyster, active);
                                    method = null;
                                    iResponseEnumeration = e;
                                    Object var9_13 = null;
                                    if (method == null) break block10;
                                    break block11;
                                }
                                if (method.getStatusCode() != 304) break block12;
                                nullResponseEnumeration = new NullResponseEnumeration(this.getURL().toExternalForm(), sequence);
                                break block13;
                            }
                            catch (Throwable throwable) {
                                Object var9_15 = null;
                                if (method != null) {
                                    method.releaseConnection();
                                }
                                this.prefetcher = null;
                                throw throwable;
                            }
                        }
                        method.releaseConnection();
                    }
                    this.prefetcher = null;
                    return iResponseEnumeration;
                }
                Object var9_14 = null;
                if (method != null) {
                    method.releaseConnection();
                }
                this.prefetcher = null;
                return nullResponseEnumeration;
            }
            Object var9_16 = null;
            if (method != null) {
                method.releaseConnection();
            }
            this.prefetcher = null;
            return null;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        return null;
    }

    private IResponseEnumeration createDownloader(HttpMethod method, CancelableRunner.ICancelableProgressMonitor monitor, String title, int sequence, IFile file, boolean oyster, boolean active) throws IOException, UnsupportedEncodingException {
        RangeAnalyzeInputStream cin = new RangeAnalyzeInputStream(0, GikoServer.getResponseBodyAsStream(method));
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)cin, "Windows-31J"));
        int contentLength = 0;
        String cenc = ThreadContentProvider.getResponseHeaderString(method.getResponseHeader("Content-Encoding"));
        String tenc = ThreadContentProvider.getResponseHeaderString(method.getResponseHeader("Transfer-Encoding"));
        String len = ThreadContentProvider.getResponseHeaderString(method.getResponseHeader("Content-Length"));
        if (oyster && (cenc != null && cenc.equals("gzip") || tenc != null && tenc.equals("chunked"))) {
            contentLength = this.readContentLength(r);
        } else if (len != null) {
            contentLength = Integer.parseInt(len);
        }
        return new ThreadDownloader(monitor, title, method, r, cin, false, sequence, ThreadContentProvider.getResponseHeaderString(method.getResponseHeader("Last-Modified")), new ArrayList(), 0, contentLength, file, active);
    }

    private int readContentLength(Reader r) throws IOException {
        if (r.read() != 43 || r.read() != 79 || r.read() != 75 || r.read() != 32) {
            return 0;
        }
        int ch = r.read();
        StringBuffer buf = new StringBuffer();
        while (ch != 47) {
            buf.append((char)ch);
            ch = r.read();
        }
        ch = r.read();
        while (ch != 47) {
            ch = r.read();
        }
        r.read();
        return Integer.parseInt(buf.toString());
    }

    /*
     * Exception decompiling
     */
    public int getCachedCount() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [5 : 149->155)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void prefetchToolTip(ColoredText.ToolTipTarget target) {
        if (target instanceof HoverLineFragment) {
            ((HoverLineFragment)target).prefetchToolTip();
        }
    }

    public Point fillToolTip(Composite parent, ColoredText sourceText, int maxWidth, ColoredText.ToolTipTarget target, String sourceTitle) {
        if (target instanceof HoverLineFragment) {
            return ((HoverLineFragment)target).fillToolTip(parent, sourceText, maxWidth, sourceTitle);
        }
        return null;
    }

    public Point fillToolTip(Composite parent, ColoredText sourceText, int maxWidth, String selection, String sourceTitle) {
        return HoverLineFragment.fillToolTip(parent, sourceText, maxWidth, selection, sourceTitle);
    }

    private static String toASCIIDigits(String str) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if ('\uff10' <= ch && ch <= '\uff19') {
                ch = (char)(48 + (ch - 65296));
            }
            buf.append(ch);
            ++i;
        }
        return buf.toString();
    }

    static /* synthetic */ String access$3(ThreadContentProvider threadContentProvider) {
        return threadContentProvider.getURLHint();
    }

    static /* synthetic */ Board access$4(ThreadContentProvider threadContentProvider) {
        return threadContentProvider.board;
    }

    private static class AccessContext {
        public int progressRemaining;
        public boolean notFound;
        public String lastModified;
        public String title;

        AccessContext() {
        }
    }

    private interface Prefetcher {
        public GetMethod getResult() throws HttpException, IOException;

        public void release();
    }

    private static class PartialPrefetcher
    implements Prefetcher,
    Runnable {
        private HttpClient hc = GikoServer.createHttpClient();
        private GetMethod get = GikoServer.createGetMethod();
        private Object result;

        PartialPrefetcher(LogFile log, URL url) {
            BBSServerManager.configureHttpClient(this.hc, url);
            this.get.setPath(url.getFile());
            this.get.setRequestHeader("Range", "bytes=" + log.httpRangeStart + "-");
            this.get.setRequestHeader("If-Modified-Since", log.lastModified);
        }

        public static PartialPrefetcher create(LogFile log, URL url) {
            PartialPrefetcher pf = new PartialPrefetcher(log, url);
            Thread t = new Thread(pf);
            t.setPriority(10);
            t.start();
            return pf;
        }

        public synchronized void run() {
            try {
                logger.finest("partial " + this.get.getPath());
                this.hc.executeMethod((HttpMethod)this.get);
                MonalipsePlugin.log(logger, (HttpMethod)this.get);
                this.result = this.get;
            }
            catch (HttpException e) {
                this.result = e;
                this.get.releaseConnection();
            }
            catch (IOException e) {
                this.result = e;
                this.get.releaseConnection();
            }
            catch (RuntimeException e) {
                this.result = e;
                this.get.releaseConnection();
            }
            this.notify();
        }

        public synchronized GetMethod getResult() throws HttpException, IOException {
            while (this.result == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.result instanceof HttpException) {
                throw (HttpException)((Object)this.result);
            }
            if (this.result instanceof IOException) {
                throw (IOException)this.result;
            }
            if (this.result instanceof RuntimeException) {
                throw (RuntimeException)this.result;
            }
            return this.get;
        }

        public void release() {
            this.get.releaseConnection();
        }
    }

    private static class FullPrefetcher
    implements Prefetcher,
    Runnable {
        private HttpClient hc = GikoServer.createHttpClient();
        private GetMethod get = GikoServer.createGetMethod();
        private Object result;

        FullPrefetcher(URL url) {
            BBSServerManager.configureHttpClient(this.hc, url);
            this.get.setPath(url.getFile());
            this.get.setRequestHeader("Accept-Encoding", "gzip");
        }

        public static FullPrefetcher create(URL url) {
            FullPrefetcher pf = new FullPrefetcher(url);
            Thread t = new Thread(pf);
            t.setPriority(10);
            t.start();
            return pf;
        }

        public synchronized void run() {
            try {
                logger.finest("partial " + this.get.getPath());
                this.hc.executeMethod((HttpMethod)this.get);
                MonalipsePlugin.log(logger, (HttpMethod)this.get);
                this.result = this.get;
            }
            catch (HttpException e) {
                this.result = e;
                this.get.releaseConnection();
            }
            catch (IOException e) {
                this.result = e;
                this.get.releaseConnection();
            }
            catch (RuntimeException e) {
                this.result = e;
                this.get.releaseConnection();
            }
            this.notify();
        }

        public synchronized GetMethod getResult() throws HttpException, IOException {
            while (this.result == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.result instanceof HttpException) {
                throw (HttpException)((Object)this.result);
            }
            if (this.result instanceof IOException) {
                throw (IOException)this.result;
            }
            if (this.result instanceof RuntimeException) {
                throw (RuntimeException)this.result;
            }
            return this.get;
        }

        public void release() {
            this.get.releaseConnection();
        }
    }

    private class ThreadDownloader
    implements IResponseEnumeration,
    CancelableRunner.ICancelableRunnableWithProgress {
        private CancelableRunner.ICancelableProgressMonitor monitor;
        private String title;
        private BufferedReader r;
        private RangeAnalyzeInputStream cin;
        private boolean partial;
        private int sequence;
        private String lastModified;
        private List log;
        private IFile logFile;
        private int position;
        private int contentRange;
        private int contentLength;
        private boolean closed;
        private boolean active;
        private HttpMethod method;
        private boolean getLog;
        static /* synthetic */ Class class$0;

        public ThreadDownloader(CancelableRunner.ICancelableProgressMonitor monitor, String title, HttpMethod method, BufferedReader r, RangeAnalyzeInputStream cin, boolean partial, int sequence, String lastModified, List log, int position, int contentLength, IFile logFile, boolean active) {
            this.monitor = monitor;
            this.title = title;
            this.method = method;
            this.r = r;
            this.cin = cin;
            this.partial = partial;
            this.sequence = sequence;
            this.lastModified = lastModified;
            this.log = log;
            this.position = position;
            this.contentLength = contentLength;
            this.logFile = logFile;
            this.active = active;
            this.contentRange = cin.getRange();
            monitor.getRunner().run(null, this);
            try {
                serverTime = Date.parse(method.getResponseHeader("Date").getValue()) / 1000L;
            }
            catch (RuntimeException runtimeException) {}
        }

        /*
         * Exception decompiling
         */
        public void run(CancelableRunner.ICancelableProgressMonitor mon) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [3 : 267->271)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void setLog(int pos) throws IOException {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            LogFile.writeLogFile(dout, this.sequence, this.title, this.lastModified, this.active, pos, this.log);
            dout.close();
            byte[] bytes = bout.toByteArray();
            Display.getDefault().asyncExec(new Runnable(this, bytes){
                final /* synthetic */ ThreadDownloader this$1;
                private final /* synthetic */ byte[] val$bytes;
                {
                    this.this$1 = threadDownloader;
                    this.val$bytes = byArray;
                }

                public void run() {
                    try {
                        NullProgressMonitor monitor = new NullProgressMonitor();
                        ThreadContentProvider.access$4(ThreadDownloader.access$0(this.this$1)).createLogFolder((IProgressMonitor)monitor);
                        IFile cache = ThreadDownloader.access$0(this.this$1).getLogFile();
                        MonalipsePlugin.ensureSynchronized(cache);
                        if (cache.exists()) {
                            cache.setContents((InputStream)new ByteArrayInputStream(this.val$bytes), false, false, (IProgressMonitor)monitor);
                        } else {
                            cache.create((InputStream)new ByteArrayInputStream(this.val$bytes), false, (IProgressMonitor)monitor);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            });
        }

        public int getSequenceNumber() {
            return this.sequence;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isPartialContent() {
            return this.partial;
        }

        public boolean isReady() {
            return !this.closed && this.position < this.log.size();
        }

        public boolean hasNextResponse() {
            return !this.closed || this.position < this.log.size();
        }

        public Response getNextResponse() throws InterruptedException {
            ThreadDownloader threadDownloader = this;
            synchronized (threadDownloader) {
                while (!this.closed && this.position == this.log.size()) {
                    this.wait();
                }
            }
            if (this.position < this.log.size()) {
                return (Response)this.log.get(this.position++);
            }
            return null;
        }

        public void close() {
            block7: {
                try {
                    if (!this.getLog) break block7;
                    try {
                        IFile iFile = ThreadContentProvider.this.getLogFile();
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("monalipse.editors.ThreadViewerEditor");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        iFile.setPersistentProperty(new QualifiedName(clazz.getName(), "cached"), String.valueOf(this.log.size()));
                    }
                    catch (CoreException coreException) {}
                    this.setLog(this.cin.getRange());
                }
                catch (IOException iOException) {}
            }
        }

        public boolean isWritable() {
            return this.active;
        }

        static /* synthetic */ ThreadContentProvider access$0(ThreadDownloader threadDownloader) {
            return threadDownloader.ThreadContentProvider.this;
        }
    }

    private class ArrayThreadReader
    implements IResponseEnumeration {
        private String title;
        private boolean partial;
        private int sequence;
        private List log;
        private int position;
        private boolean active;

        public ArrayThreadReader(String title, boolean partial, int sequence, List log, int position, boolean active) {
            this.title = title;
            this.partial = partial;
            this.sequence = sequence;
            this.log = log;
            this.position = position;
            this.active = active;
        }

        public int getSequenceNumber() {
            return this.sequence;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isPartialContent() {
            return this.partial;
        }

        public boolean isReady() {
            return this.position < this.log.size();
        }

        public boolean hasNextResponse() {
            return this.position < this.log.size();
        }

        public Response getNextResponse() throws InterruptedException {
            if (this.position < this.log.size()) {
                return (Response)this.log.get(this.position++);
            }
            return null;
        }

        public void close() {
        }

        public boolean isWritable() {
            return this.active;
        }
    }

    private static class ThreadLogReader
    implements IResponseEnumeration {
        private CancelableRunner.ICancelableProgressMonitor monitor;
        private String title;
        private LogFile log;
        private int sequence;
        private boolean partial;
        private boolean active;

        public ThreadLogReader(CancelableRunner.ICancelableProgressMonitor monitor, String title, LogFile log, boolean partial, int sequence, boolean active) {
            this.monitor = monitor;
            this.title = title;
            this.log = log;
            this.sequence = sequence;
            this.partial = partial;
            this.active = active;
            monitor.beginTask("rendering...", log.responseCount);
        }

        public int getSequenceNumber() {
            return this.sequence;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isPartialContent() {
            return this.partial;
        }

        public boolean isReady() {
            return this.hasNextResponse();
        }

        public boolean hasNextResponse() {
            return this.log != null && this.log.available();
        }

        public Response getNextResponse() {
            try {
                this.monitor.worked(1);
                return this.log.readResponse();
            }
            catch (IOException iOException) {
                this.close();
                return null;
            }
        }

        public void close() {
            if (this.log != null) {
                this.log.close();
            }
            this.log = null;
            if (this.monitor != null) {
                this.monitor.done();
            }
            this.monitor = null;
        }

        public boolean isWritable() {
            return this.active;
        }
    }

    private static class NullResponseEnumeration
    implements IResponseEnumeration {
        private String title;
        private int sequence;

        public NullResponseEnumeration(String title, int sequence) {
            this.title = title;
            this.sequence = sequence;
        }

        public int getSequenceNumber() {
            return this.sequence;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isPartialContent() {
            return true;
        }

        public boolean isReady() {
            return false;
        }

        public boolean hasNextResponse() {
            return false;
        }

        public Response getNextResponse() {
            return null;
        }

        public void close() {
        }

        public boolean isWritable() {
            return false;
        }
    }

    private static class LogFile {
        private static final int LOG_FILE_VERSION = 15;
        private static final int RESPONSE_BODY_INDENT = 32;
        private static final int STYLE_UNDERLINE = 1;
        private static final int STYLE_LINK = 2;
        private DataInputStream din;
        public int version;
        public int sequence;
        public String title;
        public String lastModified;
        public boolean isActive;
        public int httpRangeStart;
        public int responseCount;
        private int responseRead;

        /*
         * Exception decompiling
         */
        public static LogFile of(DataInputStream din) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 44->47)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        LogFile(DataInputStream din) throws IOException {
            this.din = din;
            this.version = 15;
            this.sequence = din.readInt();
            this.title = din.readUTF();
            this.lastModified = din.readUTF();
            this.isActive = din.readInt() != 0;
            this.httpRangeStart = din.readInt();
            this.responseCount = din.readInt();
        }

        public void close() {
            try {
                if (this.din != null) {
                    this.din.close();
                }
                this.din = null;
            }
            catch (IOException iOException) {}
        }

        public boolean available() {
            return this.responseRead < this.responseCount;
        }

        public void skipResponse() throws IOException {
            ++this.responseRead;
            this.din.skipBytes(this.din.readShort());
            this.skipFragments();
            this.skipFragments();
            this.skipFragments();
            int lineCount = this.din.readInt();
            int i = 0;
            while (i < lineCount) {
                this.skipFragments();
                ++i;
            }
        }

        private void skipFragments() throws IOException {
            int fragmentCount = this.din.readInt();
            int j = 0;
            while (j < fragmentCount) {
                this.din.skipBytes(12);
                this.din.skipBytes(this.din.readShort() + 8);
                ++j;
            }
        }

        public Response readResponse() throws IOException {
            ++this.responseRead;
            String text = this.din.readUTF();
            ColoredText.LineFragment[] name = this.readLineFragments(text);
            ColoredText.LineFragment[] mail = this.readLineFragments(text);
            ColoredText.LineFragment[] date = this.readLineFragments(text);
            ColoredText.Line[] body = new ColoredText.Line[this.din.readInt()];
            int i = 0;
            while (i < body.length) {
                ColoredText.Line line = new ColoredText.Line(32);
                int fragmentCount = this.din.readInt();
                int j = 0;
                while (j < fragmentCount) {
                    line.addLineFragment(this.readLineFragment(text));
                    ++j;
                }
                body[i] = line;
                ++i;
            }
            return new Response(this.responseRead, name, mail, date, body, null, null);
        }

        private ColoredText.LineFragment[] readLineFragments(String text) throws IOException {
            ColoredText.LineFragment[] fragments = new ColoredText.LineFragment[this.din.readInt()];
            int i = 0;
            while (i < fragments.length) {
                fragments[i] = this.readLineFragment(text);
                ++i;
            }
            return fragments;
        }

        private ColoredText.LineFragment readLineFragment(String text) throws IOException {
            int offset = this.din.readInt();
            int length = this.din.readInt();
            int style = this.din.readInt();
            boolean isLink = (style & 2) != 0;
            String link = "";
            if (isLink) {
                link = this.din.readUTF();
            } else {
                this.din.skipBytes(this.din.readShort());
            }
            int color = this.din.readInt();
            int font = this.din.readInt();
            if (isLink) {
                if (color == 1) {
                    return new LinkedLineFragment(text, offset, length, color, font, (style & 1) != 0, false, link);
                }
                return new HoverLineFragment(text, offset, length, color, font, (style & 1) != 0, false, link);
            }
            return new MarkedLineFragment(text, offset, length, color, font, (style & 1) != 0, false);
        }

        public void readLinkedObject(ThreadContentProvider thread, List receiver) throws IOException {
            ++this.responseRead;
            HashMap urls = new HashMap();
            this.din.skipBytes(this.din.readShort());
            this.readLinkedLineFragments(thread, receiver, urls);
            this.readLinkedLineFragments(thread, receiver, urls);
            this.readLinkedLineFragments(thread, receiver, urls);
            int lineCount = this.din.readInt();
            int i = 0;
            while (i < lineCount) {
                this.readLinkedLineFragments(thread, receiver, urls);
                ++i;
            }
        }

        private void readLinkedLineFragments(ThreadContentProvider thread, List receiver, Map urls) throws IOException {
            int fragmentCount = this.din.readInt();
            int j = 0;
            while (j < fragmentCount) {
                this.readLinkedLineFragment(thread, receiver, urls);
                ++j;
            }
        }

        private void readLinkedLineFragment(ThreadContentProvider thread, List receiver, Map urls) throws IOException {
            boolean isLink;
            this.din.skipBytes(8);
            int style = this.din.readInt();
            boolean bl = isLink = (style & 2) != 0;
            if (isLink) {
                String link = this.din.readUTF();
                try {
                    if (!urls.containsKey(link) && LinkedObject.matches(link)) {
                        receiver.add(new LinkedObject(thread, this.responseRead, new URL(link)));
                        urls.put(link, link);
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            } else {
                this.din.skipBytes(this.din.readShort());
            }
            this.din.skipBytes(8);
        }

        private static int skipWhitespace(Reader r) throws IOException {
            int ch = r.read();
            while (ch != -1 && Character.isWhitespace((char)ch)) {
                ch = r.read();
            }
            return ch;
        }

        private static void convertMatches(String text, List receiver, int color, int font, PatternAction[] patterns, boolean newMark, String urlBase) {
            int done = 0;
            Matcher[] matchers = new Matcher[patterns.length];
            int i = 0;
            while (i < matchers.length) {
                matchers[i] = patterns[i].matcher(text);
                ++i;
            }
            boolean[] matchs = new boolean[matchers.length];
            int i2 = 0;
            while (i2 < matchs.length) {
                matchs[i2] = patterns[i2].next(matchers[i2]);
                ++i2;
            }
            while (true) {
                int start = Integer.MAX_VALUE;
                int first = -1;
                int i3 = 0;
                while (i3 < matchs.length) {
                    if (matchs[i3] && matchers[i3].start() < start) {
                        start = matchers[i3].start();
                        first = i3;
                    }
                    ++i3;
                }
                if (first == -1) break;
                int end = matchers[first].end();
                if (done <= start) {
                    String link = patterns[first].getLink(urlBase, matchers[first]);
                    receiver.add(new MarkedLineFragment(text, done, start - done, color, font, false, newMark));
                    if (start < end) {
                        if (patterns[first].isLink()) {
                            receiver.add(new LinkedLineFragment(text, start, end - start, 1, font, true, newMark, link));
                        } else {
                            receiver.add(new HoverLineFragment(text, start, end - start, color, font, true, newMark, link));
                        }
                    }
                    done = end;
                }
                matchs[first] = patterns[first].next(matchers[first]);
                if (!matchs[first] || matchers[first].start() != start) continue;
                matchs[first] = false;
            }
            receiver.add(new MarkedLineFragment(text, done, text.length() - done, color, font, false, newMark));
        }

        private static void addLine(List lineReceiver, List fragments) {
            ColoredText.Line line = new ColoredText.Line(32);
            int j = 0;
            while (j < fragments.size()) {
                line.addLineFragment((ColoredText.LineFragment)fragments.get(j));
                ++j;
            }
            lineReceiver.add(line);
        }

        private static ColoredText.LineFragment[] readToken(String text, int start, int end, List lineReceiver, int color, int font, PatternAction[] patterns, boolean newMark, String urlBase, boolean escapeComma) throws IOException {
            ArrayList<MarkedLineFragment> fragments = new ArrayList<MarkedLineFragment>();
            StringBuffer buf = new StringBuffer(128);
            while (start < end && text.charAt(start) == ' ') {
                ++start;
            }
            int i = start;
            while (i < end) {
                block60: {
                    int e;
                    int ch = text.charAt(i);
                    if (ch == 60) {
                        e = text.indexOf(62, i + 1);
                        if (end <= e || e == -1) {
                            buf.append('<');
                        } else {
                            String tag = text.substring(i + 1, e).toLowerCase();
                            i = e;
                            if (buf.length() > 0 && buf.charAt(buf.length() - 1) == ' ' && tag.equals("br")) {
                                buf.deleteCharAt(buf.length() - 1);
                            }
                            if (buf.length() > 0) {
                                if (patterns == null) {
                                    fragments.add(new MarkedLineFragment(buf.toString(), 0, buf.length(), color, font, false, newMark));
                                } else {
                                    LogFile.convertMatches(buf.toString(), fragments, color, font, patterns, newMark, urlBase);
                                }
                                buf = new StringBuffer(128);
                            }
                            if (tag.equals("b")) {
                                font = 1;
                            } else if (tag.equals("/b")) {
                                font = 0;
                            } else if (tag.startsWith("font") && (tag.indexOf("red") != -1 || tag.indexOf("tomato") != -1)) {
                                color = 3;
                            } else if (tag.startsWith("font") && tag.indexOf("forestgreen") != -1) {
                                color = 4;
                            } else if (lineReceiver != null && tag.equals("br")) {
                                LogFile.addLine(lineReceiver, fragments);
                                fragments.clear();
                                while (i + 1 < end && text.charAt(i + 1) == ' ') {
                                    ++i;
                                }
                            } else {
                                tag.startsWith("a ");
                            }
                        }
                    } else if (ch == 38 && i + 1 < end) {
                        if (text.charAt(++i) == '#' && i + 1 < end) {
                            int radix = 10;
                            if (text.charAt(++i) == 'x' && i + 1 < end) {
                                radix = 16;
                            }
                            int e2 = ++i;
                            while (e2 < end && Character.isDigit(text.charAt(e2)) && e2 - i < 5) {
                                ++e2;
                            }
                            try {
                                buf.append((char)Integer.parseInt(text.substring(i, e2), radix));
                                if (e2 < end && text.charAt(e2) == ';') {
                                    i = e2;
                                    break block60;
                                }
                                i = e2 - 1;
                            }
                            catch (NumberFormatException numberFormatException) {
                                buf.append("&#");
                                if (radix == 16) {
                                    buf.append('x');
                                }
                                --i;
                            }
                        } else {
                            e = i;
                            while (e < end && Character.isLetter(text.charAt(e)) && e - i < 6) {
                                ++e;
                            }
                            String ref = text.substring(i, e);
                            if (ref.equals("lt")) {
                                buf.append('<');
                            } else if (ref.equals("gt")) {
                                buf.append('>');
                            } else if (ref.equals("amp")) {
                                buf.append('&');
                            } else if (ref.equals("apos")) {
                                buf.append('\'');
                            } else if (ref.equals("quot")) {
                                buf.append('\"');
                            } else if (ref.equals("hearts")) {
                                buf.append('\u2665');
                            } else if (ref.equals("thinsp")) {
                                buf.append('\u2009');
                            } else if (ref.equals("nbsp")) {
                                buf.append(' ');
                            } else if (ref.equals("ensp")) {
                                buf.append('\u2002');
                            } else if (ref.equals("emsp")) {
                                buf.append('\u2003');
                            } else {
                                buf.append('&').append(String.valueOf(ref) + (text.charAt(e) == ';' ? ";" : ""));
                            }
                            i = e < end && text.charAt(e) == ';' ? e : e - 1;
                        }
                    } else {
                        if (escapeComma && ch == 65312 && i + 1 < end && text.charAt(i + 1) == '\uff40') {
                            ++i;
                            ch = 44;
                        }
                        buf.append((char)ch);
                        if (ch == 32) {
                            while (i + 1 < end && text.charAt(i + 1) == ' ') {
                                ++i;
                            }
                        }
                    }
                }
                ++i;
            }
            if (buf.length() > 0 && buf.charAt(buf.length() - 1) == ' ' && lineReceiver != null) {
                buf.deleteCharAt(buf.length() - 1);
            }
            if (buf.length() > 0) {
                if (patterns == null) {
                    fragments.add(new MarkedLineFragment(buf.toString(), 0, buf.length(), color, font, false, newMark));
                } else {
                    LogFile.convertMatches(buf.toString(), fragments, color, font, patterns, newMark, urlBase);
                }
            }
            if (lineReceiver != null) {
                LogFile.addLine(lineReceiver, fragments);
                fragments.clear();
            }
            ColoredText.LineFragment[] f = new ColoredText.LineFragment[fragments.size()];
            fragments.toArray(f);
            return f;
        }

        public static String getDelimiterOf(String line) {
            if (line == null) {
                return null;
            }
            if (line.indexOf("<>") != -1) {
                return "<>";
            }
            return ",";
        }

        public static Response parseResponse(BufferedReader r, int responseNumber, String urlBase, String delim) throws IOException {
            try {
                String line = r.readLine();
                if (line == null) {
                    return null;
                }
                if (delim == null) {
                    delim = LogFile.getDelimiterOf(line);
                }
                int nameEnd = line.indexOf(delim);
                int mailEnd = line.indexOf(delim, nameEnd + delim.length());
                int dateEnd = line.indexOf(delim, mailEnd + delim.length());
                int bodyEnd = line.lastIndexOf(delim);
                boolean escapeComma = delim.equals(",");
                if (nameEnd == -1 || mailEnd == -1 || dateEnd == -1 || bodyEnd == -1) {
                    String error = "(error)";
                    ColoredText.LineFragment[] name = LogFile.readToken(error, 0, error.length(), null, 4, 1, NAME_PATTERN_SET, false, urlBase, escapeComma);
                    ColoredText.LineFragment[] mail = LogFile.readToken(error, 0, error.length(), null, 5, 1, MAIL_PATTERN_SET, false, urlBase, escapeComma);
                    ColoredText.LineFragment[] date = LogFile.readToken(error, 0, error.length(), null, 0, 0, DATE_PATTERN_SET, true, urlBase, escapeComma);
                    ArrayList lineReceiver = new ArrayList();
                    LogFile.readToken(error, 0, error.length(), lineReceiver, 0, 0, BODY_PATTERN_SET, false, urlBase, escapeComma);
                    ColoredText.Line[] body = new ColoredText.Line[lineReceiver.size()];
                    lineReceiver.toArray(body);
                    return new Response(responseNumber, name, mail, date, body, delim, null);
                }
                ColoredText.LineFragment[] name = LogFile.readToken(line, 0, nameEnd, null, 4, 1, NAME_PATTERN_SET, false, urlBase, escapeComma);
                ColoredText.LineFragment[] mail = LogFile.readToken(line, nameEnd + delim.length(), mailEnd, null, 5, 1, MAIL_PATTERN_SET, false, urlBase, escapeComma);
                ColoredText.LineFragment[] date = LogFile.readToken(line, mailEnd + delim.length(), dateEnd, null, 0, 0, DATE_PATTERN_SET, true, urlBase, escapeComma);
                ArrayList lineReceiver = new ArrayList();
                LogFile.readToken(line, dateEnd + delim.length(), bodyEnd, lineReceiver, 0, 0, BODY_PATTERN_SET, false, urlBase, escapeComma);
                ColoredText.Line[] body = new ColoredText.Line[lineReceiver.size()];
                lineReceiver.toArray(body);
                String title = null;
                if (bodyEnd + delim.length() < line.length()) {
                    title = line.substring(bodyEnd + delim.length(), line.length());
                }
                return new Response(responseNumber, name, mail, date, body, delim, title);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        private static void writeLogFile(DataOutputStream dout, int sequence, String title, String lastModified, boolean isActive, int httpRangeStart, List logs) throws IOException {
            dout.writeInt(15);
            dout.writeInt(sequence);
            dout.writeUTF(title);
            dout.writeUTF(lastModified);
            dout.writeInt(isActive ? 1 : 0);
            dout.writeInt(httpRangeStart);
            dout.writeInt(logs.size());
            int i = 0;
            while (i < logs.size()) {
                Response resp = (Response)logs.get(i);
                ColoredText.LineFragment[] name = resp.getName();
                ColoredText.LineFragment[] mail = resp.getMail();
                ColoredText.LineFragment[] date = resp.getDate();
                ColoredText.Line[] body = resp.getBody();
                StringBuffer buf = new StringBuffer();
                LogFile.appendLineFragments(buf, name);
                LogFile.appendLineFragments(buf, mail);
                LogFile.appendLineFragments(buf, date);
                int j = 0;
                while (j < body.length) {
                    buf.append(body[j].getText());
                    ++j;
                }
                dout.writeUTF(buf.toString());
                int textOffset = 0;
                textOffset = LogFile.writeLineFragments(dout, textOffset, name);
                textOffset = LogFile.writeLineFragments(dout, textOffset, mail);
                textOffset = LogFile.writeLineFragments(dout, textOffset, date);
                dout.writeInt(body.length);
                int j2 = 0;
                while (j2 < body.length) {
                    ColoredText.Line line = body[j2];
                    dout.writeInt(line.getLineFragmentCount());
                    int k = 0;
                    while (k < line.getLineFragmentCount()) {
                        textOffset = LogFile.writeLineFragment(dout, textOffset, line.getLineFragmentAt(k));
                        ++k;
                    }
                    ++j2;
                }
                ++i;
            }
        }

        private static void appendLineFragments(StringBuffer buf, ColoredText.LineFragment[] fragments) {
            int i = 0;
            while (i < fragments.length) {
                buf.append(fragments[i].getText());
                ++i;
            }
        }

        private static int writeLineFragments(DataOutputStream dout, int textOffset, ColoredText.LineFragment[] fragments) throws IOException {
            dout.writeInt(fragments.length);
            int i = 0;
            while (i < fragments.length) {
                textOffset = LogFile.writeLineFragment(dout, textOffset, fragments[i]);
                ++i;
            }
            return textOffset;
        }

        private static int writeLineFragment(DataOutputStream dout, int textOffset, ColoredText.LineFragment fragment) throws IOException {
            int style;
            dout.writeInt(textOffset);
            dout.writeInt(fragment.getTextLength());
            int n = style = fragment.getUnderline() ? 1 : 0;
            if (fragment instanceof HoverLineFragment) {
                dout.writeInt(style | 2);
                dout.writeUTF(((HoverLineFragment)fragment).getURL());
            } else {
                dout.writeInt(style);
                dout.writeUTF("");
            }
            dout.writeInt(fragment.getColor());
            dout.writeInt(fragment.getFont());
            return textOffset + fragment.getTextLength();
        }
    }

    private static abstract class PatternAction {
        private Pattern pattern;

        public PatternAction(Pattern pattern) {
            this.pattern = pattern;
        }

        public Matcher matcher(String text) {
            return this.pattern.matcher(text);
        }

        public boolean next(Matcher m) {
            return m.find();
        }

        public boolean isLink() {
            return true;
        }

        public abstract String getLink(String var1, Matcher var2);
    }

    private static class LinkedLineFragment
    extends HoverLineFragment
    implements ColoredText.LinkTarget {
        public LinkedLineFragment(String text, int offset, int length, int color, int font, boolean underline, boolean newMark, String href) {
            super(text, offset, length, color, font, underline, newMark, href);
        }

        public int getTargetResponseNumber() {
            String href = super.getURL();
            String pos = href.substring(href.lastIndexOf(47) + 1, href.length());
            Pattern p = Pattern.compile("(\\p{Digit}+)(-(\\p{Digit}+)?)?");
            Matcher m = p.matcher(pos);
            if (m.lookingAt()) {
                return Integer.parseInt(m.group(1));
            }
            return -1;
        }
    }

    private static class HoverLineFragment
    extends MarkedLineFragment
    implements ColoredText.ToolTipTarget,
    ILinkedLineFragment {
        private String href;

        public HoverLineFragment(String text, int offset, int length, int color, int font, boolean underline, boolean newMark, String href) {
            super(text, offset, length, color, font, underline, newMark);
            this.href = href;
        }

        public void prefetchToolTip() {
        }

        public String getURL() {
            return this.href;
        }

        public int getTargetResponseNumber() {
            return -1;
        }

        public Point fillToolTip(Composite parent, ColoredText sourceText, int maxWidth, String sourceTitle) {
            ArrayList<Response> responses = new ArrayList<Response>();
            String toolTipTitle = null;
            if (this.href.startsWith("id:") || this.href.startsWith("trip:")) {
                int i = 0;
                while (i < sourceText.getLineCount()) {
                    ColoredText.Line line = sourceText.getLineAt(i);
                    if (line instanceof Response.HeaderLine) {
                        int fragment;
                        Response resp = ((Response.HeaderLine)line).getResponse();
                        int n = fragment = this.href.startsWith("id:") ? 4 : 1;
                        if (resp.hasLink(fragment, this.href)) {
                            responses.add(resp);
                        }
                    }
                    ++i;
                }
            } else if (this.href.startsWith("http")) {
                try {
                    IThreadContentProvider cp = BBSServerManager.getThreadContentProviderOf(new URL(this.href));
                    if (cp != null) {
                        String targetTitle;
                        String pos = this.href.substring(this.href.lastIndexOf(47) + 1, this.href.length());
                        Pattern p = Pattern.compile("(\\p{Digit}+)(-(\\p{Digit}+)?)?");
                        Matcher m = p.matcher(pos);
                        if (m.lookingAt()) {
                            int start;
                            String s = m.group(1);
                            int end = start = Integer.parseInt(s);
                            String e = m.group(3);
                            if (e != null) {
                                end = Integer.parseInt(e);
                            }
                            if (end < start) {
                                int t = start;
                                start = end;
                                end = t;
                            }
                            targetTitle = cp.getResponses(responses, start, end);
                        } else {
                            targetTitle = cp.getResponses(responses, 1, 1);
                        }
                        if (targetTitle != null && sourceTitle != null && !sourceTitle.trim().equals(targetTitle.trim())) {
                            toolTipTitle = targetTitle;
                        }
                        if (responses.size() == 0 && cp.getName().length() > 0) {
                            return ThreadViewerEditor.createColoredTextToolTip(parent, sourceText, maxWidth, cp.getName(), null);
                        }
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            }
            Response[] r = new Response[responses.size()];
            responses.toArray(r);
            return HoverLineFragment.createToolTip(parent, sourceText, maxWidth, toolTipTitle, r);
        }

        public static Point fillToolTip(Composite parent, ColoredText sourceText, int maxWidth, String selection, String sourceTitle) {
            ColoredText.Line line;
            int i;
            ArrayList<Response> responses = new ArrayList<Response>();
            try {
                int num = Integer.parseInt(selection.trim());
                i = 0;
                while (i < sourceText.getLineCount()) {
                    Response.HeaderLine rhl;
                    line = sourceText.getLineAt(i);
                    if (line instanceof Response.HeaderLine && num == (rhl = (Response.HeaderLine)line).getReponseNumber()) {
                        responses.add(rhl.getResponse());
                    }
                    ++i;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            if (responses.size() == 0) {
                Response.HeaderLine rhl = null;
                i = 0;
                while (i < sourceText.getLineCount()) {
                    line = sourceText.getLineAt(i);
                    if (line instanceof Response.HeaderLine) {
                        rhl = (Response.HeaderLine)line;
                    }
                    if (rhl != null && line.toString().indexOf(selection) != -1) {
                        responses.add(rhl.getResponse());
                        rhl = null;
                    }
                    ++i;
                }
            }
            Response[] r = new Response[responses.size()];
            responses.toArray(r);
            return HoverLineFragment.createToolTip(parent, sourceText, maxWidth, null, r);
        }

        private static Point createToolTip(Composite parent, ColoredText sourceText, int maxWidth, String title, Response[] responses) {
            if (responses.length > 0) {
                return ThreadViewerEditor.createColoredTextToolTip(parent, sourceText, maxWidth, title, responses);
            }
            return null;
        }
    }

    private static class MarkedLineFragment
    extends ColoredText.LineFragment
    implements Response.INewResponseLineFragment {
        private int color;
        private boolean newMark;

        public MarkedLineFragment(String text, int offset, int length, int color, int font, boolean underline, boolean newMark) {
            super(text, offset, length, newMark ? 3 : color, font, underline);
            this.color = color;
            this.newMark = newMark;
        }

        public void unmark() {
            if (this.newMark) {
                this.setColor(this.color);
            }
        }

        public int getColor() {
            return this.color;
        }
    }

    private static class RangeAnalyzeInputStream
    extends InputStream {
        private int range;
        private int lf;
        private int count;
        private InputStream in;

        public RangeAnalyzeInputStream(int range, InputStream in) {
            this.range = range;
            this.in = in;
            this.lf = range;
            this.count = range;
        }

        public int getRange() {
            return this.range;
        }

        public int read() throws IOException {
            int r = this.in.read();
            if (r == 10) {
                this.range = this.lf;
                this.lf = this.count + 1;
            }
            ++this.count;
            return r;
        }

        public int read(byte[] b) throws IOException {
            int r = this.in.read(b);
            int i = 0;
            while (i < r) {
                if (b[i] == 10) {
                    this.range = this.lf;
                    this.lf = this.count + i + 1;
                }
                ++i;
            }
            this.count += r;
            return r;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int r = this.in.read(b, off, len);
            int end = off + r;
            int i = off;
            while (i < end) {
                if (b[i] == 10) {
                    this.range = this.lf;
                    this.lf = this.count + i - off + 1;
                }
                ++i;
            }
            this.count += r;
            return r;
        }
    }
}

