/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConstants;
import org.apache.commons.httpclient.HttpMethod;

public class ChunkedInputStream
extends InputStream {
    private InputStream in;
    private int chunkSize;
    private int pos;
    private boolean eof = false;
    private boolean closed = false;
    private HttpMethod method;

    public ChunkedInputStream(InputStream in, HttpMethod method) throws IOException {
        if (in == null) {
            throw new NullPointerException("InputStream parameter");
        }
        if (method == null) {
            throw new NullPointerException("HttpMethod parameter");
        }
        this.in = in;
        this.method = method;
        this.chunkSize = ChunkedInputStream.getChunkSizeFromInputStream(in);
        if (this.chunkSize == 0) {
            this.eof = true;
            this.parseFooters();
        }
        this.pos = 0;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.eof) {
            return -1;
        }
        if (this.pos >= this.chunkSize) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        ++this.pos;
        return this.in.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.eof) {
            return -1;
        }
        if (this.pos >= this.chunkSize) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        len = Math.min(len, this.chunkSize - this.pos);
        int count = this.in.read(b, off, len);
        this.pos += count;
        return count;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    private void nextChunk() throws IOException {
        int cr = this.in.read();
        int lf = this.in.read();
        if (cr != 13 || lf != 10) {
            throw new IOException("CRLF expected at end of chunk: " + cr + "/" + lf);
        }
        this.chunkSize = ChunkedInputStream.getChunkSizeFromInputStream(this.in);
        this.pos = 0;
        if (this.chunkSize == 0) {
            this.eof = true;
            this.parseFooters();
        }
    }

    private static int getChunkSizeFromInputStream(InputStream in) throws IOException {
        int result;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int state = 0;
        while (state != -1) {
            int b = in.read();
            if (b == -1) {
                throw new IOException("chunked stream ended unexpectedly");
            }
            block1 : switch (state) {
                case 0: {
                    switch (b) {
                        case 13: {
                            state = 1;
                            break block1;
                        }
                        case 34: {
                            state = 2;
                        }
                    }
                    baos.write(b);
                    break;
                }
                case 1: {
                    if (b == 10) {
                        state = -1;
                        break;
                    }
                    throw new IOException("Protocol violation: Unexpected single newline character in chunk size");
                }
                case 2: {
                    switch (b) {
                        case 92: {
                            b = in.read();
                            baos.write(b);
                            break block1;
                        }
                        case 34: {
                            state = 0;
                        }
                    }
                    baos.write(b);
                    break;
                }
                default: {
                    throw new RuntimeException("assertion failed");
                }
            }
        }
        String dataString = HttpConstants.getString(baos.toByteArray());
        int separator = dataString.indexOf(59);
        dataString = separator > 0 ? dataString.substring(0, separator).trim() : dataString.trim();
        try {
            result = Integer.parseInt(dataString.trim(), 16);
        }
        catch (NumberFormatException e) {
            throw new IOException("Bad chunk size: " + dataString);
        }
        return result;
    }

    private void parseFooters() throws IOException {
        String line = this.readLine();
        while (line != null && !line.equals("")) {
            int colonPos = line.indexOf(58);
            if (colonPos != -1) {
                String key = line.substring(0, colonPos).trim();
                String val = line.substring(colonPos + 1).trim();
                Header footer = new Header(key, val);
                this.method.addResponseFooter(footer);
            }
            line = this.readLine();
        }
    }

    private String readLine() throws IOException {
        StringBuffer buf = new StringBuffer();
        while (true) {
            int ch;
            if ((ch = this.in.read()) < 0) {
                if (buf.length() != 0) break;
                return null;
            }
            if (ch == 13) continue;
            if (ch == 10) break;
            buf.append((char)ch);
        }
        return buf.toString();
    }

    public void close() throws IOException {
        block3: {
            if (this.closed) break block3;
            try {
                if (!this.eof) {
                    ChunkedInputStream.exhaustInputStream(this);
                }
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                this.eof = true;
                this.closed = true;
                throw throwable;
            }
            Object var1_3 = null;
            this.eof = true;
            this.closed = true;
        }
    }

    static void exhaustInputStream(InputStream inStream) throws IOException {
        byte[] buffer = new byte[1024];
        while (inStream.read(buffer) >= 0) {
        }
    }
}

