/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.Serializable;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Cookie
extends NameValuePair
implements Serializable,
Comparator {
    private String _comment;
    private String _domain;
    private Date _expiryDate;
    private String _path;
    private boolean _secure;
    private boolean _hasPathAttribute = false;
    private boolean _hasDomainAttribute = false;
    private int _version = 0;
    private static final RuleBasedCollator stringCollator = (RuleBasedCollator)Collator.getInstance(new Locale("en", "US", ""));
    private static final Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.httpclient.Cookie");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public Cookie() {
        this(null, "noname", null, null, null, false);
    }

    public Cookie(String domain, String name, String value) {
        this(domain, name, value, null, null, false);
    }

    public Cookie(String domain, String name, String value, String path, Date expires, boolean secure) {
        super(name, value);
        log.trace((Object)"enter Cookie(String, String, String, String, Date, boolean)");
        if (name == null) {
            throw new IllegalArgumentException("Cookie name may not be null");
        }
        if (name.equals("")) {
            throw new IllegalArgumentException("Cookie name may not be blank");
        }
        if (name.indexOf(32) != -1) {
            throw new IllegalArgumentException("Cookie name may not contain blanks");
        }
        if (name.startsWith("$")) {
            throw new IllegalArgumentException("Cookie name may not start with $");
        }
        this.setPath(path);
        this.setDomain(domain);
        this.setExpiryDate(expires);
        this.setSecure(secure);
    }

    public Cookie(String domain, String name, String value, String path, int maxAge, boolean secure) {
        this(domain, name, value, path, new Date(System.currentTimeMillis() + (long)maxAge * 1000L), secure);
    }

    public String getComment() {
        return this._comment;
    }

    public void setComment(String comment) {
        this._comment = comment;
    }

    public Date getExpiryDate() {
        return this._expiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this._expiryDate = expiryDate;
    }

    public boolean isPersistent() {
        return this._expiryDate != null;
    }

    public String getDomain() {
        return this._domain;
    }

    public void setDomain(String domain) {
        if (domain != null) {
            int ndx = domain.indexOf(":");
            if (ndx != -1) {
                domain = domain.substring(0, ndx);
            }
            this._domain = domain.toLowerCase();
        }
    }

    public String getPath() {
        return this._path;
    }

    public void setPath(String path) {
        this._path = path;
    }

    public boolean getSecure() {
        return this._secure;
    }

    public void setSecure(boolean secure) {
        this._secure = secure;
    }

    public int getVersion() {
        return this._version;
    }

    public void setVersion(int version) {
        this._version = version;
    }

    public boolean isExpired() {
        return this._expiryDate != null && this._expiryDate.getTime() <= System.currentTimeMillis();
    }

    public boolean isExpired(Date now) {
        return this._expiryDate != null && this._expiryDate.getTime() <= now.getTime();
    }

    public void setPathAttributeSpecified(boolean value) {
        this._hasPathAttribute = value;
    }

    public boolean isPathAttributeSpecified() {
        return this._hasPathAttribute;
    }

    public void setDomainAttributeSpecified(boolean value) {
        this._hasDomainAttribute = value;
    }

    public boolean isDomainAttributeSpecified() {
        return this._hasDomainAttribute;
    }

    public int hashCode() {
        return super.hashCode() ^ (this._path == null ? 0 : this._path.hashCode()) ^ (this._domain == null ? 0 : this._domain.hashCode());
    }

    public boolean equals(Object obj) {
        log.trace((Object)"enter Cookie.equals(Object)");
        if (obj != null && obj instanceof Cookie) {
            Cookie that = (Cookie)obj;
            return (this.getName() == null ? that.getName() == null : this.getName().equals(that.getName())) && (this.getPath() == null ? that.getPath() == null : this.getPath().equals(that.getPath())) && (this.getDomain() == null ? that.getDomain() == null : this.getDomain().equals(that.getDomain()));
        }
        return false;
    }

    public String toExternalForm() {
        return CookiePolicy.getSpecByVersion(this.getVersion()).formatCookie(this);
    }

    public boolean matches(String domain, int port, String path, boolean secure, Date date) {
        log.trace((Object)"enter Cookie.matches(Strinng, int, String, boolean, Date");
        CookieSpec matcher = CookiePolicy.getDefaultSpec();
        return matcher.match(domain, port, path, secure, this);
    }

    public boolean matches(String domain, int port, String path, boolean secure) {
        log.trace((Object)"enter Cookie.matches(String, int, String, boolean");
        return this.matches(domain, port, path, secure, new Date());
    }

    public static Header createCookieHeader(String domain, String path, Cookie[] cookies) {
        log.trace((Object)"enter Cookie.createCookieHeader(String, String, Cookie[])");
        return Cookie.createCookieHeader(domain, path, false, cookies);
    }

    public static Header createCookieHeader(String domain, String path, boolean secure, Cookie[] cookies) throws IllegalArgumentException {
        log.trace((Object)"enter Cookie.createCookieHeader(String, String, boolean, Cookie[])");
        if (domain == null) {
            throw new IllegalArgumentException("null domain in createCookieHeader.");
        }
        int port = secure ? 443 : 80;
        int ndx = domain.indexOf(":");
        if (ndx != -1) {
            try {
                port = Integer.parseInt(domain.substring(ndx + 1, domain.length()));
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Cookie.createCookieHeader():  Invalid port number in domain " + domain));
            }
        }
        return Cookie.createCookieHeader(domain, port, path, secure, cookies);
    }

    public static Header createCookieHeader(String domain, int port, String path, boolean secure, Cookie[] cookies) throws IllegalArgumentException {
        log.trace((Object)"enter Cookie.createCookieHeader(String, int, String, boolean, Cookie[])");
        return Cookie.createCookieHeader(domain, port, path, secure, new Date(), cookies);
    }

    public static Header createCookieHeader(String domain, int port, String path, boolean secure, Date now, Cookie[] cookies) throws IllegalArgumentException {
        log.trace((Object)"enter Cookie.createCookieHeader(String, int, String, boolean, Date, Cookie[])");
        CookieSpec matcher = CookiePolicy.getDefaultSpec();
        cookies = matcher.match(domain, port, path, secure, cookies);
        if (cookies != null && cookies.length > 0) {
            return matcher.formatCookieHeader(cookies);
        }
        return null;
    }

    public int compare(Object o1, Object o2) {
        log.trace((Object)"enter Cookie.compare(Object, Object)");
        if (!(o1 instanceof Cookie)) {
            throw new ClassCastException(o1.getClass().getName());
        }
        if (!(o2 instanceof Cookie)) {
            throw new ClassCastException(o2.getClass().getName());
        }
        Cookie c1 = (Cookie)o1;
        Cookie c2 = (Cookie)o2;
        if (c1.getPath() == null && c2.getPath() == null) {
            return 0;
        }
        if (c1.getPath() == null) {
            if (c2.getPath().equals("/")) {
                return 0;
            }
            return -1;
        }
        if (c2.getPath() == null) {
            if (c1.getPath().equals("/")) {
                return 0;
            }
            return 1;
        }
        return stringCollator.compare(c1.getPath(), c2.getPath());
    }

    public String toString() {
        return this.toExternalForm();
    }

    public static Cookie[] parse(String domain, int port, String path, Header setCookie) throws HttpException, IllegalArgumentException {
        log.trace((Object)"enter Cookie.parse(String, int, String, Header)");
        return Cookie.parse(domain, port, path, false, setCookie);
    }

    public static Cookie[] parse(String domain, String path, Header setCookie) throws HttpException, IllegalArgumentException {
        log.trace((Object)"enter Cookie.parse(String, String, Header)");
        return Cookie.parse(domain, 80, path, false, setCookie);
    }

    public static Cookie[] parse(String domain, String path, boolean secure, Header setCookie) throws HttpException {
        log.trace((Object)"enter Cookie.parse(String, String, boolean, Header)");
        return Cookie.parse(domain, secure ? 443 : 80, path, secure, setCookie);
    }

    public static Cookie[] parse(String domain, int port, String path, boolean secure, Header setCookie) throws HttpException, IllegalArgumentException {
        log.trace((Object)"enter Cookie.parse(String, int, String, boolean, Header)");
        CookieSpec parser = CookiePolicy.getDefaultSpec();
        Cookie[] cookies = parser.parse(domain, port, path, secure, setCookie);
        int i = 0;
        while (i < cookies.length) {
            Cookie cookie = cookies[i];
            CookieSpec validator = CookiePolicy.getSpecByVersion(cookie.getVersion());
            validator.validate(domain, port, path, secure, cookie);
            ++i;
        }
        return cookies;
    }
}

