/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResponseInputStream
extends InputStream {
    public static final Log log;
    public static final Log wireLog;
    private boolean closed = false;
    private boolean chunk = false;
    private boolean endChunk = false;
    private byte[] buffer = null;
    private int length = 0;
    private int pos = 0;
    private int count = 0;
    private int contentLength = -1;
    private InputStream stream = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.httpclient.ResponseInputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        wireLog = LogFactory.getLog((String)"httpclient.wire");
    }

    public ResponseInputStream(InputStream stream, boolean chunked, int contentLength) {
        log.trace((Object)"enter ResponseInputStream(InputStream, boolean, int)");
        if (stream == null) {
            throw new NullPointerException("InputStream parameter is null");
        }
        this.closed = false;
        this.count = 0;
        this.chunk = chunked;
        this.contentLength = contentLength;
        this.stream = stream;
    }

    public ResponseInputStream(InputStream stream, HttpMethod method) {
        Header contentLengthHeader;
        log.trace((Object)"enter ResponseInputStream(InputStream, HttpMethod)");
        if (stream == null) {
            throw new NullPointerException("InputStream parameter is null");
        }
        if (method == null) {
            throw new NullPointerException("HttpMethod parameter is null");
        }
        this.closed = false;
        this.count = 0;
        Header transferEncoding = method.getResponseHeader("transfer-encoding");
        if (transferEncoding != null && transferEncoding.getValue().toLowerCase().indexOf("chunked") != -1) {
            this.chunk = true;
        }
        if ((contentLengthHeader = method.getResponseHeader("content-length")) != null) {
            try {
                this.contentLength = Integer.parseInt(contentLengthHeader.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.stream = stream;
    }

    public void close() throws IOException {
        block10: {
            block9: {
                log.trace((Object)"enter ResponseInputStream.close()");
                if (this.closed) break block10;
                try {
                    if (this.chunk) {
                        while (!this.endChunk) {
                            int b = this.read();
                            if (b >= 0) {
                                continue;
                            }
                            break block9;
                        }
                        break block9;
                    }
                    if (this.length <= 0) break block9;
                    while (this.count < this.length) {
                        int b = this.read();
                        if (b >= 0) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    Object var2_5 = null;
                    this.closed = true;
                    throw throwable;
                }
            }
            Object var2_6 = null;
            this.closed = true;
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        log.trace((Object)"enter ResponseInputStream.read(byte, int, int)");
        int avail = this.length - this.pos;
        if (avail == 0 && !this.fillBuffer()) {
            return -1;
        }
        avail = this.length - this.pos;
        if (avail == 0) {
            return -1;
        }
        int toCopy = avail;
        if (toCopy < 0) {
            return -1;
        }
        if (avail > len) {
            toCopy = len;
        }
        System.arraycopy(this.buffer, this.pos, b, off, toCopy);
        this.pos += toCopy;
        return toCopy;
    }

    public int read() throws IOException {
        log.trace((Object)"enter ResponseInputStream.read()");
        if (this.pos == this.length && !this.fillBuffer()) {
            return -1;
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    private boolean fillBuffer() throws IOException {
        log.trace((Object)"enter ResponseInputStream.fillBuffer()");
        if (this.closed) {
            return false;
        }
        if (this.endChunk) {
            return false;
        }
        if (this.contentLength >= 0 && this.count >= this.contentLength) {
            return false;
        }
        this.pos = 0;
        if (this.chunk) {
            try {
                String numberValue = this.readLineFromStream();
                if (numberValue == null) {
                    throw new NumberFormatException("unable to find chunk length");
                }
                this.length = Integer.parseInt(numberValue.trim(), 16);
            }
            catch (NumberFormatException e) {
                this.length = -1;
                this.chunk = false;
                this.endChunk = true;
                this.closed = true;
                return false;
            }
            if (this.length == 0) {
                String trailingLine = this.readLineFromStream();
                while (!trailingLine.equals("")) {
                    trailingLine = this.readLineFromStream();
                }
                this.endChunk = true;
                return false;
            }
            if (this.buffer == null || this.length > this.buffer.length) {
                this.buffer = new byte[this.length];
            }
            int nbRead = 0;
            int currentRead = 0;
            while (nbRead < this.length) {
                try {
                    currentRead = this.stream.read(this.buffer, nbRead, this.length - nbRead);
                }
                catch (Throwable t) {
                    log.debug((Object)"Exception thrown reading chunk from response", t);
                    throw new IOException();
                }
                if (currentRead < 0) {
                    throw new IOException("Not enough bytes read");
                }
                nbRead += currentRead;
            }
            String blank = this.readLineFromStream();
        } else {
            try {
                if (this.buffer == null) {
                    this.buffer = new byte[4096];
                }
                this.length = this.stream.read(this.buffer);
                this.count += this.length;
            }
            catch (Throwable t) {
                log.debug((Object)"Exception thrown reading from response", t);
                throw new IOException(t.getMessage());
            }
        }
        return true;
    }

    private String readLineFromStream() throws IOException {
        log.trace((Object)"enter ResponseInputStream.ReadLineFromStream()");
        StringBuffer sb = new StringBuffer();
        while (true) {
            int ch;
            if ((ch = this.stream.read()) < 0) {
                if (sb.length() != 0) break;
                return null;
            }
            if (ch == 13) continue;
            if (ch == 10) break;
            sb.append((char)ch);
        }
        return sb.toString();
    }
}

