<?php
/**
 * Moony - the tiny web application framework
 *
 * @package   Moony
 * @author    YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @link      http://moony.sourceforge.jp/
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license   http://opensource.org/licenses/bsd-license.php The BSD License
 */

define('MOONY_VERSION', '0.11.1');
define('MOONY_ROOT_DIR', dirname(__FILE__));

define('MOONY_TEMPLATE_DIR_KEY', 'moony_template_dir');
define('MOONY_TOKEN_KEY', 'moony_token');
define('MOONY_HAS_ERROR_KEY', 'moony_has_error');
define('MOONY_ERROR_MESSAGES_KEY', 'moony_error_messages');

require_once MOONY_ROOT_DIR . '/Moony/Action.php';
require_once MOONY_ROOT_DIR . '/Moony/Converter.php';
require_once MOONY_ROOT_DIR . '/Moony/Flash.php';
require_once MOONY_ROOT_DIR . '/Moony/Registry.php';
require_once MOONY_ROOT_DIR . '/Moony/Request.php';
require_once MOONY_ROOT_DIR . '/Moony/Router.php';
require_once MOONY_ROOT_DIR . '/Moony/Session.php';
require_once MOONY_ROOT_DIR . '/Moony/Template.php';
require_once MOONY_ROOT_DIR . '/Moony/Validator.php';
require_once MOONY_ROOT_DIR . '/Moony/Template/Php.php';
require_once MOONY_ROOT_DIR . '/Moony/Template/Smarty.php';

/**
 * Moonyのフロントエンドクラスです。
 *
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @access public
 */
class Moony
{
    /**
     * アクションクラスを格納するディレクトリ
     * @var string
     */
    var $action_dir = 'actions';

    /**
     * テンプレートファイルを格納するディレクトリ
     * @var string
     */
    var $template_dir = 'templates';

    /**
     * 入力エンコーディング
     * @var string
     */
    var $input_encoding;

    /**
     * 出力エンコーディング
     * @var string
     */
    var $output_encoding;

    /**
     * 内部エンコーディング
     * @var string
     */
    var $internal_encoding;

    /**
     * テンプレートエンジンとしてSmartyを使うかどうか
     * @var boolean
     */
    var $use_smarty = false;

    /**
     * Smartyに設定するプロパティの連想配列
     * @var array
     */
    var $smarty_properties;

    /**
     * 実行するアクションを決定、処理を開始します。
     *
     * @access public
     */
    function start()
    {
        $router =& new Moony_Router();
        $router->route($this);
    }

    /**
     * アクションクラスを格納するディレクトリを設定します。
     * 初期設定値は「actions」です。
     *
     * @access public
     * @param string $action_dir アクションクラスを格納するディレクトリ
     */
    function setActionDir($action_dir)
    {
        $this->action_dir = rtrim($action_dir, '/\\');
    }

    /**
     * テンプレートファイルを格納するディレクトリを設定します。
     * 初期設定値は「templates」です。
     *
     * @access public
     * @param string $template_dir テンプレートファイルを格納するディレクトリ
     */
    function setTemplateDir($template_dir)
    {
        $this->template_dir = rtrim($template_dir, '/\\');
    }

    /**
     * 入力エンコーディングを設定します。
     * 設定した場合、リクエストパラメータの値は
     * 内部エンコーディングに変換されます。
     *
     * @access public
     * @param string $input_encoding 入力エンコーディング
     */
    function setInputEncoding($input_encoding)
    {
        $this->input_encoding = $input_encoding;
    }

    /**
     * 出力エンコーディングを設定します。
     * 設定した場合、出力時のデフォルトエンコーディングとして使用されます。
     *
     * @access public
     * @param string $output_encoding 出力エンコーディング
     */
    function setOutputEncoding($output_encoding)
    {
        $this->output_encoding = $output_encoding;
    }

    /**
     * 内部エンコーディングを設定します。
     * 設定されない場合、mb_internal_encodingの戻り値を
     * 内部エンコーディングとして使用します。
     *
     * @access public
     * @param string $internal_encoding 内部エンコーディング
     */
    function setInternalEncoding($internal_encoding)
    {
        $this->internal_encoding = $internal_encoding;
    }

    /**
     * テンプレートエンジンとしてSmartyを使用することにします。
     * $propertiesの個々の要素ははSmartyのプロパティとして設定されます。
     * （例: array('compile_dir' => 'templates_c')）
     *
     * @access public
     * @param array $properties Smartyに設定するプロパティの連想配列
     */
    function useSmarty($properties)
    {
        $this->use_smarty = true;
        $this->smarty_properties = $properties;
    }
}
?>
