<?php
/**
 * Moony - the tiny web application framework
 *
 * @package   Moony
 * @author    YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @link      http://moony.sourceforge.jp/
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license   http://opensource.org/licenses/bsd-license.php The BSD License
 */

/**
 * Moonyのレジストリクラスです。
 *
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @access public
 */
class Moony_Registry
{
    /**
     * 保管されている値の連想配列
     * @var array
     */
    var $vars;

    /**
     * 保管されている値を取得します。
     * 該当する値が存在しない場合、$defaultを返します。
     *
     * @access public
     * @static
     * @param string $name 値の名称
     * @param mixed $default 値が存在しない場合のデフォルト値
     * @return mixed 保管されている値
     */
    function get($name, $default = null)
    {
        $registry =& Moony_Registry::_getInstance();
        if (array_key_exists($name, $registry->vars)) {
            return $registry->vars[$name];
        }
        return $default;
    }

    /**
     * 値をレジストリに保管します。
     * $varが配列の場合、展開して全ての値を保管します。
     *
     * @access public
     * @static
     * @param string|array $var 保管する値の名称、または保管する値の連想配列
     * @param mixed $value 保管する値
     */
    function set($var, $value)
    {
        $registry =& Moony_Registry::_getInstance();
        if (is_array($var)) {
            foreach ($var as $name => $val) {
                $registry->vars[$name] = $val;
            }
        } else {
            $registry->vars[$var] = $value;
        }
    }

    /**
     * 値が保管されているかどうか調べます。
     *
     * @access public
     * @static
     * @param string $name 保管されている値の名称
     * @return boolean 保管されているかどうか
     */
    function exists($name)
    {
        $registry =& Moony_Registry::_getInstance();
        return array_key_exists($name, $registry->vars);
    }

    /**
     * 保管されている値を除去します。
     *
     * @access public
     * @static
     * @param string $name 除去する値の名称
     * @return mixed 除去された値
     */
    function remove($name)
    {
        $registry =& Moony_Registry::_getInstance();
        if (array_key_exists($name, $registry->vars)) {
            $value = $registry->vars[$name];
            unset($registry->vars[$name]);
            return $value;
        }
    }

    /**
     * 保管されている全ての値を消去します。
     *
     * @access public
     * @static
     */
    function clean()
    {
        $registry =& Moony_Registry::_getInstance();
        $registry->vars = array();
    }

    /**
     * このクラスのSingletonインスタンスを取得します。
     *
     * @access protected
     * @static
     * @return object Moony_Registry
     */
    function &_getInstance()
    {
        static $instance;
        if (is_null($instance)) {
            $instance = new Moony_Registry();
            $instance->vars = array();
        }
        return $instance;
    }
}
?>
