<?php
class Moony_ConverterTest extends UnitTestCase
{
    var $c;

    function setUp()
    {
        $this->c =& new Moony_Converter('UTF-8');
    }

    function testTrim()
    {
        $var1 = ' aaa ';
        $this->c->trim($var1);
        $this->assertEqual('aaa', $var1);

        $var2 = array(' aaa ', "bbb\n");
        $this->c->trim($var2);
        $this->assertEqual(array('aaa', 'bbb'), $var2);

        $var3 = 'baaab';
        $this->c->trim($var3, 'b');
        $this->assertEqual('aaa', $var3);

        $var4 = array('baaac', 'bcccb');
        $this->c->trim($var4, 'bc');
        $this->assertEqual(array('aaa', ''), $var4);
    }

    function testToUppercase()
    {
        $var1 = 'aaaA';
        $this->c->toUppercase($var1);
        $this->assertEqual('AAAA', $var1);

        $var2 = array('abcD', 'EfgH');
        $this->c->toUppercase($var2);
        $this->assertEqual(array('ABCD', 'EFGH'), $var2);
    }

    function testToLowercase()
    {
        $var1 = 'AAAa';
        $this->c->toLowercase($var1);
        $this->assertEqual('aaaa', $var1);

        $var2 = array('ABCd', 'eFGh');
        $this->c->toLowercase($var2);
        $this->assertEqual(array('abcd', 'efgh'), $var2);
    }

    function testToHiragana()
    {
        $var1 = 'アイウエオｶｷｸｹｺﾊﾞﾊﾟ';
        $this->c->toHiragana($var1);
        $this->assertEqual('あいうえおかきくけこばぱ', $var1);

        $var2 = array('あイｳえｵガギｸﾞｹ', 'sfdアｼﾊADし');
        $this->c->toHiragana($var2);
        $this->assertEqual(array('あいうえおがぎぐけ', 'sfdあしはADし'), $var2);
    }

    function testToKatakana()
    {
        $var1 = 'あいうえおｶｷｸｹｺﾊﾞﾊﾟ';
        $this->c->toKatakana($var1);
        $this->assertEqual('アイウエオカキクケコバパ', $var1);

        $var2 = array('あイｳえｵガギｸﾞｹ', 'sfdアｼﾊADし');
        $this->c->toKatakana($var2);
        $this->assertEqual(array('アイウエオガギグケ', 'sfdアシハADシ'), $var2);
    }

    function testToHalfWidth()
    {
        $var1 = '０１２ＡＳｄｄ';
        $this->c->toHalfWidth($var1);
        $this->assertEqual('012ASdd', $var1);

        $var2 = array('０ｄｇＤｓ，', 'ｓｆ９３２Ｄ');
        $this->c->toHalfWidth($var2);
        $this->assertEqual(array('0dgDs,', 'sf932D'), $var2);
    }

    function testToKana()
    {
        $var1 = 'とちはトシシ';
        $this->c->toKana($var1, 'kh');
        $this->assertEqual('ﾄﾁﾊﾄｼｼ', $var1);

        $var2 = array('ハハ氏とは', 'DSfdfシテハ');
        $this->c->toKana($var2, 'kh');
        $this->assertEqual(array('ﾊﾊ氏ﾄﾊ', 'DSfdfｼﾃﾊ'), $var2);
    }
}
?>
