<?php
class Moony_RegistryTest extends UnitTestCase
{
    function testGetSet()
    {
        $value = 'aaa';
        Moony_Registry::set('foo', $value);
        $this->assertEqual($value, Moony_Registry::get('foo'));
        $this->assertNull(Moony_Registry::get('fooo'));
        $this->assertEqual('bb', Moony_Registry::get('fooo', 'bb'));
    }

    function testRemove()
    {
        $value = 'aaa';
        Moony_Registry::set('foo', $value);
        $this->assertEqual($value, Moony_Registry::remove('foo'));
        $this->assertNull(Moony_Registry::get('foo'));
        $this->assertEqual('bb', Moony_Registry::get('foo', 'bb'));
    }

    function testClean()
    {
        Moony_Registry::set('foo', $value);
        Moony_Registry::clean();
        $this->assertNull(Moony_Registry::get('foo'));
        $this->assertEqual('bb', Moony_Registry::get('foo', 'bb'));
    }
}
?>
