<?php
class Moony_RequestTest extends UnitTestCase
{
    var $req;
    var $userfile;

    function setUp()
    {
        $this->userfile = array(
            'name' => 'a.txt',
            'type' => 'text/plain',
            'size' => 32,
            'tmp_name' => 'opqrstu',
            'error' => UPLOAD_ERR_OK
        );

        $_POST = array('foo' => 'a', 'bar' => 'bb');
        $_GET = array('foo' => 'A', 'baz' => 'CCC');
        $_FILES = array('userfile' => $this->userfile);
        $_SERVER['QUERY_STRING'] = 'sss';
        $this->req =& new Moony_Request();
    }

    function testGet()
    {
        $this->assertEqual('a', $this->req->get('foo'));
        $this->assertEqual('AAA', $this->req->get('fooo', 'AAA'));
        $this->assertNull($this->req->get('barrrr'));
        $this->assertEqual('CCC', $this->req->get('baz'));
    }

    function testGetAll()
    {
        $expected = array('foo' => 'a', 'bar' => 'bb', 'baz' => 'CCC');
        $this->assertEqual($expected, $this->req->getAll());
    }

    function testExists()
    {
        $this->assertTrue($this->req->exists('foo'));
        $this->assertFalse($this->req->exists('fooo'));
    }

    function testGetFile()
    {
        $this->assertEqual($this->userfile, $this->req->getFile('userfile'));
        $this->assertNull($this->req->getFile('non-userfile'));
    }

    function testGetQueryString()
    {
        $this->assertEqual('sss', $this->req->getQueryString());
    }

    function testConvertEncoding()
    {
        // TODO creates test cases
    }

    function testFilter()
    {
        $value = "\0abcdef\0";
        $this->assertEqual('abcdef', Moony_Request::filter($value));
    }
}
?>
