<?php
class Moony_ValidatorTest extends UnitTestCase
{
    var $v;

    function setUp()
    {
        $this->v =& new Moony_Validator('UTF-8');
    }

    function testValidateRequired1()
    {
        $this->v->validateRequired(null, 'error');
        $this->assertTrue($this->v->hasError());
    }

    function testValidateRequired2()
    {
        $this->v->validateRequired('a', 'error');
        $this->assertFalse($this->v->hasError());
    }

    function testValidateRequired3()
    {
        $this->v->validateRequired('', 'error');
        $this->assertTrue($this->v->hasError());
    }

    function testValidateRequired4()
    {
        $this->v->validateRequired(array('', 'aa'), 'error');
        $this->assertTrue($this->v->hasError());
    }

    function testValidateRequired5()
    {
        $this->v->validateRequired(array('ssf', 'aa'), 'error');
        $this->assertFalse($this->v->hasError());
    }

    function testValidatePattern1()
    {
        $this->v->validatePattern('1236', '/^[0-9]{4}$/', 'error');
        $this->assertFalse($this->v->hasError());
    }

    function testValidatePattern2()
    {
        $this->v->validatePattern('126a', '/^[0-9]{4}$/', 'error');
        $this->assertTrue($this->v->hasError());
    }

    function testValidatePattern3()
    {
        $this->v->validatePattern('あいう', '^[あ-お]+$', 'error', true);
        $this->assertFalse($this->v->hasError());
    }

    function testValidatePattern4()
    {
        $this->v->validatePattern('あかいう', '^[あ-お]+$', 'error', true);
        $this->assertTrue($this->v->hasError());
    }

    function testValidatePattern5()
    {
        $this->v->validatePattern(array('2345', '126a'), '/^[0-9]{4}$/', 'error');
        $this->assertTrue($this->v->hasError());
    }

    function testValidatePattern6()
    {
        $this->v->validatePattern(array('2345', '1260'), '/^[0-9]{4}$/', 'error');
        $this->assertFalse($this->v->hasError());
    }

    function testValidatePattern7()
    {
        $this->v->validatePattern(array('あかいう', 'あかいお'), '^[あ-お]+$', 'error', true);
        $this->assertTrue($this->v->hasError());
    }

    function testValidatePattern8()
    {
        $this->v->validatePattern(array('あおいう', 'あいいえお'), '^[あ-お]+$', 'error', true);
        $this->assertFalse($this->v->hasError());
    }

    function testValidateLength1()
    {
        $this->v->validateLength('abc', 0, 3, 'error');
        $this->assertFalse($this->v->hasError());
    }

    function testValidateLength2()
    {
        $this->v->validateLength('sabc', 0, 3, 'error');
        $this->assertTrue($this->v->hasError());
    }

    function testValidateLength3()
    {
        $this->v->validateLength('あいう', 0, 3, 'error', true, true);
        $this->assertFalse($this->v->hasError());
    }

    function testValidateLength4()
    {
        $this->v->validateLength('かきくけ', 0, 3, 'error', true, true);
        $this->assertTrue($this->v->hasError());
    }

    function testValidateLength5()
    {
        $this->v->validateLength(array('bsd', '23d'), 0, 3, 'error');
        $this->assertFalse($this->v->hasError());
    }

    function testValidateLength6()
    {
        $this->v->validateLength(array('bsdd', '23d'), 0, 3, 'error');
        $this->assertTrue($this->v->hasError());
    }

    function testValidateLength7()
    {
        $this->v->validateLength(array('あいう', 'かきく'), 0, 3, 'error', true, true);
        $this->assertFalse($this->v->hasError());
    }

    function testValidateLength8()
    {
        $this->v->validateLength(array('あいうえ', 'かきく'), 0, 3, 'error', true, true);
        $this->assertTrue($this->v->hasError());
    }

    function testValidateRange1()
    {
        $this->v->validateRange(25, 10, 30, 'error');
        $this->assertFalse($this->v->hasError());
    }

    function testValidateRange11()
    {
        $this->v->validateRange(25, 10, 30, 'error', false);
        $this->assertFalse($this->v->hasError());
    }

    function testValidateRange2()
    {
        $this->v->validateRange(35, 10, 30, 'error');
        $this->assertTrue($this->v->hasError());
    }

    function testValidateRange21()
    {
        $this->v->validateRange(30, 10, 30, 'error', false);
        $this->assertTrue($this->v->hasError());
    }

    function testValidateRange3()
    {
        $this->v->validateRange(array(25, 35), 10, 30, 'error');
        $this->assertTrue($this->v->hasError());
    }

    function testValidateRange31()
    {
        $this->v->validateRange(array(25, 30), 10, 30, 'error', false);
        $this->assertTrue($this->v->hasError());
    }

    function testValidateRange4()
    {
        $this->v->validateRange(array(25, 10), 10, 30, 'error');
        $this->assertFalse($this->v->hasError());
    }

    function testValidateRange41()
    {
        $this->v->validateRange(array(25, 13), 10, 30, 'error', false);
        $this->assertFalse($this->v->hasError());
    }

    function testValidateAlpha1()
    {
        $this->v->validateAlpha('abc', 'error');
        $this->assertFalse($this->v->hasError());
    }

    function testValidateAlpha2()
    {
        $this->v->validateAlpha('a0bc', 'error');
        $this->assertTrue($this->v->hasError());
    }

    function testValidateAlpha3()
    {
        $this->v->validateAlpha(array('abc', 'SBS'), 'error');
        $this->assertFalse($this->v->hasError());
    }

    function testValidateAlpha4()
    {
        $this->v->validateAlpha(array('sdf', 'Ssd2BS'), 'error');
        $this->assertTrue($this->v->hasError());
    }

    function testValidateAlnum1()
    {
        $this->v->validateAlnum('a034bc', 'error');
        $this->assertFalse($this->v->hasError());
    }

    function testValidateAlnum2()
    {
        $this->v->validateAlnum('a03,bc', 'error');
        $this->assertTrue($this->v->hasError());
    }

    function testValidateAlnum3()
    {
        $this->v->validateAlnum(array('ab324c', 'S234ffBS'), 'error');
        $this->assertFalse($this->v->hasError());
    }

    function testValidateAlnum4()
    {
        $this->v->validateAlnum(array('sd324fsff', 'Ss.dd2BS'), 'error');
        $this->assertTrue($this->v->hasError());
    }

    function testValidateDigit1()
    {
        $this->v->validateDigit('651656', 'error');
        $this->assertFalse($this->v->hasError());
    }

    function testValidateDigit2()
    {
        $this->v->validateDigit('543r32432', 'error');
        $this->assertTrue($this->v->hasError());
    }

    function testValidateDigit3()
    {
        $this->v->validateDigit(array('3245435', '897625'), 'error');
        $this->assertFalse($this->v->hasError());
    }

    function testValidateDigit4()
    {
        $this->v->validateDigit(array('53453m45', '356344'), 'error');
        $this->assertTrue($this->v->hasError());
    }

    function testValidateNumeric1()
    {
        $this->v->validateNumeric('65.1656', 'error');
        $this->assertFalse($this->v->hasError());
    }

    function testValidateNumeric2()
    {
        $this->v->validateNumeric('543r32.432', 'error');
        $this->assertTrue($this->v->hasError());
    }

    function testValidateNumeric3()
    {
        $this->v->validateNumeric(array('324.5435', '897625'), 'error');
        $this->assertFalse($this->v->hasError());
    }

    function testValidateNumeric4()
    {
        $this->v->validateNumeric(array('534.53m45', '3563.44'), 'error');
        $this->assertTrue($this->v->hasError());
    }

    function testValidateHiragana1()
    {
        $this->v->validateHiragana('あいう', 'error');
        $this->assertFalse($this->v->hasError());
    }

    function testValidateHiragana2()
    {
        $this->v->validateHiragana('あアいう', 'error');
        $this->assertTrue($this->v->hasError());
    }

    function testValidateHiragana3()
    {
        $this->v->validateHiragana(array('あいほーう', 'ぁぃぅ'), 'error');
        $this->assertFalse($this->v->hasError());
    }

    function testValidateHiragana4()
    {
        $this->v->validateHiragana(array('あいう', 'ｼﾄｼ'), 'error');
        $this->assertTrue($this->v->hasError());
    }

    function testValidateKatakana1()
    {
        $this->v->validateKatakana('アイーウ', 'error');
        $this->assertFalse($this->v->hasError());
    }

    function testValidateKatakana2()
    {
        $this->v->validateKatakana('アイはウ', 'error');
        $this->assertTrue($this->v->hasError());
    }

    function testValidateKatakana3()
    {
        $this->v->validateKatakana(array('ウスハハ', 'ァィゥ'), 'error');
        $this->assertFalse($this->v->hasError());
    }

    function testValidateKatakana4()
    {
        $this->v->validateKatakana(array('ハハフアハ', 'ｼﾄｼ'), 'error');
        $this->assertTrue($this->v->hasError());
    }

    function testValidateUserFunc1()
    {
        $this->v->validateUserFunc('moony', array($this, '_callback'), 'error');
        $this->assertFalse($this->v->hasError());
    }

    function testValidateUserFunc2()
    {
        $this->v->validateUserFunc('mooony', array($this, '_callback'), 'error');
        $this->assertTrue($this->v->hasError());
    }

    function testValidateUserFunc3()
    {
        $this->v->validateUserFunc(array('moony', 'MoONy'), array($this, '_callback'), 'error');
        $this->assertFalse($this->v->hasError());
    }

    function testValidateUserFunc4()
    {
        $this->v->validateUserFunc(array('mooony', 'MOony'), array($this, '_callback'), 'error');
        $this->assertTrue($this->v->hasError());
    }

    function testGetErrorMessages1()
    {
        $this->v->validateRequired(null, 'error');
        $errors = $this->v->getErrorMessages();
        $this->assertEqual('error', $errors[0]);
    }

    function testGetErrorMessages2()
    {
        $this->v->validateRequired(null);
        $errors = $this->v->getErrorMessages();
        $this->assertEqual(array(), $errors);
    }

    function _callback($var)
    {
        return strtolower($var) == 'moony';
    }
}
?>
