/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.common.action;

import java.util.Date;
import jp.mosp.common.common.BaseAction;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dao.CmUserDao;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.common.vo.PasswordVo;

public class PasswordAction
extends BaseAction {
    private static final String CMD_PASSWORD_SHOW = "C1050";
    private static final String CMD_PASSWORD_CHANGE = "C1051";
    private static final String CMD_PASS_FORCE = "C1052";

    public PasswordAction() {
        this.setCheckAuth(false);
    }

    public void action() throws Exception {
        this.prepareVo();
        this.setCmdMenu();
        if (this.cmd.equals(CMD_PASSWORD_SHOW)) {
            this.show();
        } else if (this.cmd.equals(CMD_PASSWORD_CHANGE)) {
            this.update();
        } else if (this.cmd.equals(CMD_PASS_FORCE)) {
            this.showForce();
        } else {
            throw new MospException(5001);
        }
    }

    protected BaseVo getSpecificVo() {
        return new PasswordVo(this.cfg, this.msg, this.nam, this.cmd, this.aspUser, this.user);
    }

    protected void show() throws Exception {
        this.chkInstance(this.getVo() instanceof PasswordVo);
        PasswordVo vo = (PasswordVo)this.getVo();
        vo.setUserId(this.user.getUserId());
        vo.setUserName(this.user.getUserName());
        vo.setMode(0);
    }

    protected void showForce() throws Exception {
        this.chkInstance(this.getVo() instanceof PasswordVo);
        PasswordVo vo = (PasswordVo)this.getVo();
        vo.setUserId(this.user.getUserId());
        vo.setUserName(this.user.getUserName());
        vo.setMode(1);
    }

    private void update() throws Exception {
        this.chkInstance(this.getVo() instanceof PasswordVo);
        PasswordVo vo = (PasswordVo)this.getVo();
        vo.setParams(this.request);
        this.getConnection();
        CmUserDao dao = new CmUserDao(this.cfg, this.cmd, this.aspUser, this.user, this.conn);
        CmUserDto dto = dao.findForUpdate(vo.getUserId());
        this.chkExist(dto);
        vo.validate(dto.getPassword());
        dto.setPassword(MospUtility.encrypt(vo.getHdnNewPassword(), this.hasMospSeJar()));
        dto.setChangePass(new Date());
        dao.update(dto);
        this.commit();
        vo.setMessage(MospUtility.getMessage(this.msg, "IC0002", ""));
        vo.setMode(0);
    }

    private void setCmdMenu() throws MospException {
        this.chkInstance(this.getVo() instanceof PasswordVo);
        PasswordVo vo = (PasswordVo)this.getVo();
        if (this.user.getAuthority().equals("90")) {
            vo.setCmdMenu("C1015");
        } else {
            vo.setCmdMenu("C1010");
        }
    }
}

