/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.common.common;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public abstract class DBConnBean {
    protected Connection conn = null;

    protected DBConnBean() {
    }

    protected void getConnection(String RDBDRIVER, String RDBNAME, String USERID, String PASSWORD) throws ClassNotFoundException, SQLException {
        Class.forName(RDBDRIVER);
        this.conn = DriverManager.getConnection(RDBNAME, USERID, PASSWORD);
        this.conn.setAutoCommit(false);
    }

    protected void getConnection(String DATASOURCE) throws NamingException, SQLException {
        DataSource ds = (DataSource)new InitialContext().lookup("java:comp/env/" + DATASOURCE);
        this.conn = ds.getConnection();
        this.conn.setAutoCommit(false);
    }

    protected void releaseConnection() throws SQLException {
        if (this.conn != null && !this.conn.isClosed()) {
            this.conn.close();
        }
        if (this.conn != null) {
            this.conn = null;
        }
    }

    protected void commit() throws SQLException {
        if (this.conn != null && !this.conn.isClosed()) {
            this.conn.commit();
        }
    }

    protected void rollback() throws SQLException {
        if (this.conn != null && !this.conn.isClosed()) {
            this.conn.rollback();
        }
    }
}

