/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.common.common;

import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KanaConvertUtility {
    private static String[] aryZenkakuKana = new String[]{"\u30a2", "\u30a4", "\u30a6", "\u30a8", "\u30aa", "\u30ab", "\u30ad", "\u30af", "\u30b1", "\u30b3", "\u30b5", "\u30b7", "\u30b9", "\u30bb", "\u30bd", "\u30bf", "\u30c1", "\u30c4", "\u30c6", "\u30c8", "\u30ca", "\u30cb", "\u30cc", "\u30cd", "\u30ce", "\u30cf", "\u30d2", "\u30d5", "\u30d8", "\u30db", "\u30de", "\u30df", "\u30e0", "\u30e1", "\u30e2", "\u30e4", "\u30e6", "\u30e8", "\u30e9", "\u30ea", "\u30eb", "\u30ec", "\u30ed", "\u30ef", "\u30f2", "\u30f3", "\u30ac", "\u30ae", "\u30b0", "\u30b2", "\u30b4", "\u30b6", "\u30b8", "\u30ba", "\u30bc", "\u30be", "\u30c0", "\u30c2", "\u30c5", "\u30c7", "\u30c9", "\u30d0", "\u30d3", "\u30d6", "\u30d9", "\u30dc", "\u30d1", "\u30d4", "\u30d7", "\u30da", "\u30dd", "\u30a1", "\u30a3", "\u30a5", "\u30a7", "\u30a9", "\u30e3", "\u30e5", "\u30e7", "\u30c3", "\u30fc", "\u3002", "\u300c", "\u300d", "\u3001", "\u30fb", "\u309b", "\u309c", "\u30f4", "\uff10", "\uff11", "\uff12", "\uff13", "\uff14", "\uff15", "\uff16", "\uff17", "\uff18", "\uff19", "\uff41", "\uff42", "\uff43", "\uff44", "\uff45", "\uff46", "\uff47", "\uff48", "\uff29", "\uff4a", "\uff4b", "\uff4c", "\uff4d", "\uff4e", "\uff4f", "\uff50", "\uff51", "\uff52", "\uff53", "\uff54", "\uff55", "\uff56", "\uff57", "\uff58", "\uff59", "\uff5a", "\uff21", "\uff22", "\uff23", "\uff24", "\uff25", "\uff26", "\uff27", "\uff28", "\uff29", "\uff2a", "\uff2b", "\uff2c", "\uff2d", "\uff2e", "\uff2f", "\uff30", "\uff31", "\uff32", "\uff33", "\uff34", "\uff35", "\uff36", "\uff37", "\uff38", "\uff39", "\uff3a"};
    private static String[] aryHankakuKana = new String[]{"\uff71", "\uff72", "\uff73", "\uff74", "\uff75", "\uff76", "\uff77", "\uff78", "\uff79", "\uff7a", "\uff7b", "\uff7c", "\uff7d", "\uff7e", "\uff7f", "\uff80", "\uff81", "\uff82", "\uff83", "\uff84", "\uff85", "\uff86", "\uff87", "\uff88", "\uff89", "\uff8a", "\uff8b", "\uff8c", "\uff8d", "\uff8e", "\uff8f", "\uff90", "\uff91", "\uff92", "\uff93", "\uff94", "\uff95", "\uff96", "\uff97", "\uff98", "\uff99", "\uff9a", "\uff9b", "\uff9c", "\uff66", "\uff9d", "\uff76\uff9e", "\uff77\uff9e", "\uff78\uff9e", "\uff79\uff9e", "\uff7a\uff9e", "\uff7b\uff9e", "\uff7c\uff9e", "\uff7d\uff9e", "\uff7e\uff9e", "\uff7f\uff9e", "\uff80\uff9e", "\uff81\uff9e", "\uff82\uff9e", "\uff83\uff9e", "\uff84\uff9e", "\uff8a\uff9e", "\uff8b\uff9e", "\uff8c\uff9e", "\uff8d\uff9e", "\uff8e\uff9e", "\uff8a\uff9f", "\uff8b\uff9f", "\uff8c\uff9f", "\uff8d\uff9f", "\uff8e\uff9f", "\uff67", "\uff68", "\uff69", "\uff6a", "\uff6b", "\uff6c", "\uff6d", "\uff6e", "\uff6f", "\uff70", "\uff61", "\uff62", "\uff63", "\uff64", "\uff65", "\uff9e", "\uff9f", "\uff73\uff9e", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "I", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static String[] aryHiraGana = new String[]{"\u3042", "\u3044", "\u3046", "\u3048", "\u304a", "\u304b", "\u304d", "\u304f", "\u3051", "\u3053", "\u3055", "\u3057", "\u3059", "\u305b", "\u305d", "\u305f", "\u3061", "\u3064", "\u3066", "\u3068", "\u306a", "\u306b", "\u306c", "\u306d", "\u306e", "\u306f", "\u3072", "\u3075", "\u3078", "\u307b", "\u307e", "\u307f", "\u3080", "\u3081", "\u3082", "\u3084", "\u3086", "\u3088", "\u3089", "\u308a", "\u308b", "\u308c", "\u308d", "\u308f", "\u3092", "\u3093", "\u304c", "\u304e", "\u3050", "\u3052", "\u3054", "\u3056", "\u3058", "\u305a", "\u305c", "\u305e", "\u3060", "\u3062", "\u3065", "\u3067", "\u3069", "\u3070", "\u3073", "\u3076", "\u3079", "\u307c", "\u3071", "\u3074", "\u3077", "\u307a", "\u307d", "\u3041", "\u3043", "\u3045", "\u3047", "\u3049", "\u3083", "\u3085", "\u3087", "\u3063", "\u30fc", "\u3002", "\u300c", "\u300d", "\u3001", "\u30fb", "\u309b", "\u309c", "\u3046\u309b", "\uff10", "\uff11", "\uff12", "\uff13", "\uff14", "\uff15", "\uff16", "\uff17", "\uff18", "\uff19", "\uff41", "\uff42", "\uff43", "\uff44", "\uff45", "\uff46", "\uff47", "\uff48", "\uff29", "\uff4a", "\uff4b", "\uff4c", "\uff4d", "\uff4e", "\uff4f", "\uff50", "\uff51", "\uff52", "\uff53", "\uff54", "\uff55", "\uff56", "\uff57", "\uff58", "\uff59", "\uff5a", "\uff21", "\uff22", "\uff23", "\uff24", "\uff25", "\uff26", "\uff27", "\uff28", "\uff29", "\uff2a", "\uff2b", "\uff2c", "\uff2d", "\uff2e", "\uff2f", "\uff30", "\uff31", "\uff32", "\uff33", "\uff34", "\uff35", "\uff36", "\uff37", "\uff38", "\uff39", "\uff3a"};

    public static String convZenkakuToHankaku(String input) {
        return KanaConvertUtility.convertKana(input, KanaConvertUtility.getAryZenkakuKana(), KanaConvertUtility.getAryHankakuKana());
    }

    public static String convHiraGanaToHankaku(String input) {
        return KanaConvertUtility.convertKana(input, KanaConvertUtility.getAryHiraGana(), KanaConvertUtility.getAryHankakuKana());
    }

    public static String convKataKanaToHiraGana(String input) {
        return KanaConvertUtility.convertKana(input, KanaConvertUtility.getAryZenkakuKana(), KanaConvertUtility.getAryHiraGana());
    }

    public static String convHiraGanaToKataKana(String input) {
        return KanaConvertUtility.convertKana(input, KanaConvertUtility.getAryHiraGana(), KanaConvertUtility.getAryZenkakuKana());
    }

    private static String convertKana(String input, String[] aryContain, String[] aryTarget) {
        StringBuffer output = new StringBuffer();
        block0: for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            for (int j = 0; j < aryContain.length; ++j) {
                if (String.valueOf(ch).equals(aryContain[j])) {
                    output.append(aryTarget[j]);
                    continue block0;
                }
                if (String.valueOf(ch).equals(aryContain[j]) || j != aryContain.length - 1) continue;
                output.append(ch);
            }
        }
        return output.toString();
    }

    public static String[] getAryHiraGana() {
        return (String[])aryHiraGana.clone();
    }

    public static String[] getAryHankakuKana() {
        return (String[])aryHankakuKana.clone();
    }

    public static String[] getAryZenkakuKana() {
        return (String[])aryZenkakuKana.clone();
    }

    public static String convHankakuToZenkaku(String input) {
        return KanaConvertUtility.convertZenkaku(input, KanaConvertUtility.getKataKanaMap());
    }

    public static String convHankakuToHiraGana(String input) {
        return KanaConvertUtility.convertZenkaku(input, KanaConvertUtility.getHiraGanaMap());
    }

    private static String convertZenkaku(String input, HashMap<String, String> targetMap) {
        StringBuffer output = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            String kana;
            char ch = input.charAt(i);
            int next = i + 1;
            char p = ' ';
            String han = String.valueOf(ch);
            if (next < input.length()) {
                p = input.charAt(next);
                han = han + p;
            }
            if ((kana = targetMap.get(han)) == null) {
                if (targetMap.get(String.valueOf(ch)) != null) {
                    output.append(targetMap.get(String.valueOf(ch)));
                    continue;
                }
                output.append(ch);
                continue;
            }
            output.append(kana);
            ++i;
        }
        return output.toString();
    }

    private static HashMap<String, String> getKataKanaMap() {
        HashMap<String, String> kataKanaMap = new HashMap<String, String>();
        for (int i = 0; i < aryHankakuKana.length; ++i) {
            kataKanaMap.put(aryHankakuKana[i], aryZenkakuKana[i]);
        }
        return kataKanaMap;
    }

    private static HashMap<String, String> getHiraGanaMap() {
        HashMap<String, String> hiraGanaMap = new HashMap<String, String>();
        for (int i = 0; i < aryHankakuKana.length; ++i) {
            hiraGanaMap.put(aryHankakuKana[i], aryHiraGana[i]);
        }
        return hiraGanaMap;
    }
}

