/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv;

import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;
import jp.sf.orangesignal.csv.CsvReader;

public class CsvResultSetMetaData
implements Serializable,
ResultSetMetaData {
    private static final long serialVersionUID = -177998106514695495L;
    private List<String> columns;

    public CsvResultSetMetaData(CsvReader reader) throws IOException {
        this.columns = reader.readValues();
        if (this.columns == null) {
            throw new IOException("No header is available");
        }
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public boolean isAutoIncrement(int column) {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) {
        return true;
    }

    @Override
    public boolean isSearchable(int column) {
        return false;
    }

    @Override
    public boolean isCurrency(int column) {
        return false;
    }

    @Override
    public int isNullable(int column) {
        return 2;
    }

    @Override
    public boolean isSigned(int column) {
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) {
        return Integer.MAX_VALUE;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        if (column < 1 || column > this.columns.size()) {
            throw new SQLException("Invalid column " + column);
        }
        return this.columns.get(column - 1);
    }

    @Override
    public String getSchemaName(int column) {
        return "";
    }

    @Override
    public int getPrecision(int column) {
        return 0;
    }

    @Override
    public int getScale(int column) {
        return 0;
    }

    @Override
    public String getTableName(int column) {
        return "";
    }

    @Override
    public String getCatalogName(int column) {
        return "";
    }

    @Override
    public int getColumnType(int column) {
        return 12;
    }

    @Override
    public String getColumnTypeName(int column) {
        return String.class.getName();
    }

    @Override
    public boolean isReadOnly(int column) {
        return true;
    }

    @Override
    public boolean isWritable(int column) {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) {
        return false;
    }

    @Override
    public String getColumnClassName(int column) {
        return String.class.getName();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("unwrap(Class) not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("isWrapperFor(Class) not supported");
    }
}

