/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.export.JRXmlExporterParameter;
import net.sf.jasperreports.engine.util.JRLoader;

public final class JasperExportManager {
    public static String exportReportToPdfFile(String sourceFileName) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(sourceFile);
        File destFile = new File(sourceFile.getParent(), jasperPrint.getName() + ".pdf");
        String destFileName = destFile.toString();
        JasperExportManager.exportReportToPdfFile(jasperPrint, destFileName);
        return destFileName;
    }

    public static void exportReportToPdfFile(String sourceFileName, String destFileName) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(sourceFileName);
        JasperExportManager.exportReportToPdfFile(jasperPrint, destFileName);
    }

    public static void exportReportToPdfFile(JasperPrint jasperPrint, String destFileName) throws JRException {
        JRPdfExporter exporter = new JRPdfExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, destFileName);
        exporter.exportReport();
    }

    public static void exportReportToPdfStream(InputStream inputStream, OutputStream outputStream) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(inputStream);
        JasperExportManager.exportReportToPdfStream(jasperPrint, outputStream);
    }

    public static void exportReportToPdfStream(JasperPrint jasperPrint, OutputStream outputStream) throws JRException {
        JRPdfExporter exporter = new JRPdfExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, outputStream);
        exporter.exportReport();
    }

    public static byte[] exportReportToPdf(JasperPrint jasperPrint) throws JRException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JRPdfExporter exporter = new JRPdfExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, baos);
        exporter.exportReport();
        return baos.toByteArray();
    }

    public static String exportReportToXmlFile(String sourceFileName, boolean isEmbeddingImages) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(sourceFile);
        File destFile = new File(sourceFile.getParent(), jasperPrint.getName() + ".jrpxml");
        String destFileName = destFile.toString();
        JasperExportManager.exportReportToXmlFile(jasperPrint, destFileName, isEmbeddingImages);
        return destFileName;
    }

    public static void exportReportToXmlFile(String sourceFileName, String destFileName, boolean isEmbeddingImages) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(sourceFileName);
        JasperExportManager.exportReportToXmlFile(jasperPrint, destFileName, isEmbeddingImages);
    }

    public static void exportReportToXmlFile(JasperPrint jasperPrint, String destFileName, boolean isEmbeddingImages) throws JRException {
        JRXmlExporter exporter = new JRXmlExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, destFileName);
        exporter.setParameter(JRXmlExporterParameter.IS_EMBEDDING_IMAGES, isEmbeddingImages ? Boolean.TRUE : Boolean.FALSE);
        exporter.exportReport();
    }

    public static void exportReportToXmlStream(InputStream inputStream, OutputStream outputStream) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(inputStream);
        JasperExportManager.exportReportToXmlStream(jasperPrint, outputStream);
    }

    public static void exportReportToXmlStream(JasperPrint jasperPrint, OutputStream outputStream) throws JRException {
        JRXmlExporter exporter = new JRXmlExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, outputStream);
        exporter.exportReport();
    }

    public static String exportReportToXml(JasperPrint jasperPrint) throws JRException {
        StringBuffer sbuffer = new StringBuffer();
        JRXmlExporter exporter = new JRXmlExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_STRING_BUFFER, sbuffer);
        exporter.exportReport();
        return sbuffer.toString();
    }

    public static String exportReportToHtmlFile(String sourceFileName) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(sourceFile);
        File destFile = new File(sourceFile.getParent(), jasperPrint.getName() + ".html");
        String destFileName = destFile.toString();
        JasperExportManager.exportReportToHtmlFile(jasperPrint, destFileName);
        return destFileName;
    }

    public static void exportReportToHtmlFile(String sourceFileName, String destFileName) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(sourceFileName);
        JasperExportManager.exportReportToHtmlFile(jasperPrint, destFileName);
    }

    public static void exportReportToHtmlFile(JasperPrint jasperPrint, String destFileName) throws JRException {
        JRHtmlExporter exporter = new JRHtmlExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, destFileName);
        exporter.exportReport();
    }

    private JasperExportManager() {
    }
}

