/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 振替日重複チェックエラーメッセージ。
 */
var MSG_TRANSFER_REPETITION_CHECK	= "TMW0216";

/**
 * 登録/削除確認メッセージ。
 */
var MSG_DIFFERENCE_REQUEST_CHECK	= "TMW0230";



/**
 * 画面読込時追加処理
 * @param 無し
 * @return 無し
 * @throws 実行時例外
 */
function onLoadExtra() {
	// 承認状況がNULLの場合は全項目を読取専用にする
	if (modeActivateDate== ""){
		setDisabled("pltEditRequestYear", false);
		setDisabled("pltEditRequestMonth", false);
		setDisabled("pltEditRequestDay", true);
		setDisabled("btnRequestDate", true);
		setDisabled("pltEditSubstitute", true);
		setDisabled("pltEditStartHour", true);
		setDisabled("pltEditStartMinute", true);
		setDisabled("pltEditEndHour", true);
		setDisabled("pltEditEndMinute", true);
		setDisabled("pltEditSubstitute1Year", true);
		setDisabled("pltEditSubstitute1Month", true);
		setDisabled("pltEditSubstitute1Day", true);
		setDisabled("pltEditSubstitute1Range", true);
		setDisabled("txtEditRequestReason", true);
		setDisabled("btnRegist", true);
		setDisabled("btnDraft", true);

		return;
	}
	// 出勤日が無効の場合は出勤年/月以外は編集不可にする
	var editRequestDay = getFormValue("pltEditRequestDay");
	if( editRequestDay == "" ){
		setDisabled("pltEditSubstitute", true);
		setDisabled("pltEditRequestDay", true);
		setDisabled("btnRequestDate", true);
		return;
	} else{
		setDisabled("pltEditSubstitute", false);
		setDisabled("pltEditRequestDay", false);
		setDisabled("btnRequestDate", false);
	}
	// 有効日(編集)モード確認
	if (modeActivateDate == MODE_ACTIVATE_DATE_FIXED) {
		// 有効日編集不可
		setDisabled("pltEditRequestYear", true);
		setDisabled("pltEditRequestMonth", true);
		setDisabled("pltEditRequestDay", true);
		setDisabled("pltEditSubstitute", true);
		var substitute = getFormValue("pltEditSubstitute");
		// 申請日が法定/所定休日で読取領域の変更(法定/所定休日判定方法は未実装)
		if( substitute == 1 ){
			// 法定休日で振替休暇申請
			setDisabled("pltEditStartHour", false);
			setDisabled("pltEditStartMinute", false);
			setDisabled("pltEditEndHour", false);
			setDisabled("pltEditEndMinute", false);
			setDisabled("pltEditSubstitute1Year", false);
			setDisabled("pltEditSubstitute1Month", false);
			setDisabled("pltEditSubstitute1Day", false);
			setDisabled("pltEditSubstitute1Range", true);
			// 所定休日で振替休暇申請
			setDisabled("pltEditStartHour", false);
			setDisabled("pltEditStartMinute", false);
			setDisabled("pltEditEndHour", false);
			setDisabled("pltEditEndMinute", false);
			setDisabled("pltEditSubstitute1Year", false);
			setDisabled("pltEditSubstitute1Month", false);
			setDisabled("pltEditSubstitute1Day", false);
			setDisabled("pltEditSubstitute1Range", false);
			var substitute1Range = getFormValue("pltEditSubstitute1Range");
		} else {
			// 法定休日で振替休暇非申請
			setDisabled("pltEditStartHour", false);
			setDisabled("pltEditStartMinute", false);
			setDisabled("pltEditEndHour", false);
			setDisabled("pltEditEndMinute", false);
			setDisabled("pltEditSubstitute1Year", true);
			setDisabled("pltEditSubstitute1Month", true);
			setDisabled("pltEditSubstitute1Day", true);
			setDisabled("pltEditSubstitute1Range", true);
		}
		// 所定、法定休日のチェック
		if(jsModeLegalHoliday == "on" ){
			// 法定
			if (jsModeWorkPlanFlag == "1"){
				// 申請する
				setDisabled("pltEditStartHour", true);
				setDisabled("pltEditStartMinute", true);
				setDisabled("pltEditEndHour", true);
				setDisabled("pltEditEndMinute", true);
				setDisabled("pltEditSubstitute1Year", false);
				setDisabled("pltEditSubstitute1Month", false);
				setDisabled("pltEditSubstitute1Day", false);
				setDisabled("pltEditSubstitute1Range", true);
			} else {
				// 申請しない
				setDisabled("pltEditStartHour", false);
				setDisabled("pltEditStartMinute", false);
				setDisabled("pltEditEndHour", false);
				setDisabled("pltEditEndMinute", false);
				setDisabled("pltEditSubstitute1Year", true);
				setDisabled("pltEditSubstitute1Month", true);
				setDisabled("pltEditSubstitute1Day", true);
				setDisabled("pltEditSubstitute1Range", true);
			}
		} else {
			if (jsModeWorkPlanFlag == "1"){
				// 申請する
				setDisabled("pltEditStartHour", true);
				setDisabled("pltEditStartMinute", true);
				setDisabled("pltEditEndHour", true);
				setDisabled("pltEditEndMinute", true);
				setDisabled("pltEditSubstitute1Year", false);
				setDisabled("pltEditSubstitute1Month", false);
				setDisabled("pltEditSubstitute1Day", false);
				setDisabled("pltEditSubstitute1Range", false);
			} else {
				// 申請しない
				setDisabled("pltEditStartHour", false);
				setDisabled("pltEditStartMinute", false);
				setDisabled("pltEditEndHour", false);
				setDisabled("pltEditEndMinute", false);
				setDisabled("pltEditSubstitute1Year", true);
				setDisabled("pltEditSubstitute1Month", true);
				setDisabled("pltEditSubstitute1Day", true);
				setDisabled("pltEditSubstitute1Range", true);
			}
		}
	} else {
		// 有効日編集可
		setDisabled("pltEditRequestYear", false);
		setDisabled("pltEditRequestMonth", false);
		setDisabled("pltEditRequestDay", false);
		setDisabled("pltEditSubstitute", false);
		// 編集項目の利用不可
		setDisabled("pltEditStartHour", false);
		setDisabled("pltEditStartMinute", false);
		setDisabled("pltEditEndHour", false);
		setDisabled("pltEditEndMinute", false);
		setDisabled("pltEditSubstitute1Year", true);
		setDisabled("pltEditSubstitute1Month", true);
		setDisabled("pltEditSubstitute1Day", true);
		setDisabled("pltEditSubstitute1Range", true);
	}
	// 勤務予定時刻の表示
	// 振替申請しない場合のみ、勤務予定時刻を行う
	if (jsModeWorkPlanFlag == "1"){
		setDisabled("pltEditStartHour", true);
		setDisabled("pltEditStartMinute", true);
		setDisabled("pltEditEndHour", true);
		setDisabled("pltEditEndMinute", true);
	} else {
		setDisabled("pltEditStartHour", false);
		setDisabled("pltEditStartMinute", false);
		setDisabled("pltEditEndHour", false);
		setDisabled("pltEditEndMinute", false);
	}
}

/**
 * 追加チェックを行う。<br>
 * @param aryMessage エラーメッセージ格納配列
 * @param event イベント
 * @return 無し
 */
function checkDateExtra(aryMessage, event) {
	checkDate("pltEditRequestYear", "pltEditRequestMonth", "pltEditRequestDay", aryMessage); 
}

/**
 * 申請関連のリクエストを送信する。<br>
 * 入力チェックを行った後、更新系確認メッセージを出し、リクエストを送信する。<br>
 * @param event イベントオブジェクト
 * @param cmd   コマンド 
 * @return 無し
 */
function submitApplication(event, cmd) {
	submitRegist(event, "divEdit", checkSubstituteDateExtra, cmd) ;	
}

/**
 * 下書時の追加チェックを行う。<br>
 * 期間終了日の入力チェックを行う。<br>
 */
function checkDraftExtra(aryMessage, event){
	// 振替休日が平日かの確認
	checkSubstituteDateExtra(aryMessage, event);
}

/**
 * 追加チェックを行う。<br>
 * @param aryMessage エラーメッセージ格納配列
 * @param event イベント
 * @return 無し
 */
function checkSubstituteDateExtra(aryMessage, event) {
	checkDate("pltEditSubstitute1Year", "pltEditSubstitute1Month", "pltEditSubstitute1Day", aryMessage); 
}

/**
 * 追加チェックを行う。<br>
 * @param aryMessage エラーメッセージ格納配列
 * @param event イベント
 * @return 無し
 */
function checkExtra(aryMessage, event) {
	// チェックボックス必須確認
	checkBoxRequired("ckbSelect", aryMessage);
}
