/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.platform.bean.message.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import java.util.Map;

import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.message.MessageSearchBeanInterface;
import jp.mosp.platform.dao.message.MessageDaoInterface;
import jp.mosp.platform.dto.message.MessageDtoInterface;

/**
 * メッセージテーブル検索クラス。
 *
 */
public class MessageSearchBean extends PlatformBean implements MessageSearchBeanInterface {
	
	/**
	 * メッセージテーブルDAO。
	 */
	private MessageDaoInterface	dao;
	
	/**
	 * メッセージNo。
	 */
	private String				messageNo;
	
	/**
	 * 対象年月。
	 */
	private Date				targetYearMonth;
	
	/**
	 * メッセージ区分。
	 */
	private String				messageType;
	
	/**
	 * 重要度。
	 */
	private String				messageImportance;
	
	/**
	 * メッセージタイトル。
	 */
	private String				messageTitle;
	
	/**
	 * 登録者氏名。
	 */
	private String				employeeName;
	
	/**
	 * 有効無効フラグ。
	 */
	private String				inactivateFlag;
	

	/**
	 * {@link PlatformBean#PlatformBean()}を実行する。<br>
	 */
	public MessageSearchBean() {
		super();
	}
	
	/**
	 * {@link PlatformBean#PlatformBean(MospParams, Connection)}を実行する。<br>
	 * @param mospParams MosP処理情報
	 * @param connection DBコネクション
	 */
	protected MessageSearchBean(MospParams mospParams, Connection connection) {
		super(mospParams, connection);
	}
	
	@Override
	public void initBean() throws MospException {
		dao = (MessageDaoInterface)createDao(MessageDaoInterface.class);
	}
	
	@Override
	public List<MessageDtoInterface> getSearchList() throws MospException {
		// Mapに検索条件を設定
		Map<String, Object> param = dao.getParamsMap();
		param.put(MessageDaoInterface.SEARCH_MESSAGE_NO, messageNo);
		param.put(MessageDaoInterface.SEARCH_START_DATE, getFirstDateOfMonth(targetYearMonth));
		param.put(MessageDaoInterface.SEARCH_END_DATE, getLastDateOfMonth(targetYearMonth));
		param.put(MessageDaoInterface.SEARCH_MESSAGE_TYPE, getInteger(messageType));
		param.put(MessageDaoInterface.SEARCH_MESSAGE_IMPORTANCE, getInteger(messageImportance));
		param.put(MessageDaoInterface.SEARCH_MESSAGE_TITLE, messageTitle);
		param.put(MessageDaoInterface.SEARCH_EMPLOYEE_NAME, employeeName);
		param.put(MessageDaoInterface.SEARCH_INACTIVATE_FLAG, getInteger(inactivateFlag));
		// 検索
		return dao.findForSearch(param);
	}
	
	@Override
	public void setMessageNo(String messageNo) {
		this.messageNo = messageNo;
	}
	
	@Override
	public void setTargetYearMonth(Date targetYearMonth) {
		this.targetYearMonth = getDateClone(targetYearMonth);
	}
	
	@Override
	public void setMessageType(String messageType) {
		this.messageType = messageType;
	}
	
	@Override
	public void setMessageImportance(String messageImportance) {
		this.messageImportance = messageImportance;
	}
	
	@Override
	public void setMessageTitle(String messageTitle) {
		this.messageTitle = messageTitle;
	}
	
	@Override
	public void setInactivateFlag(String inactivateFlag) {
		this.inactivateFlag = inactivateFlag;
	}
	
	@Override
	public void setEmployeeName(String employeeName) {
		this.employeeName = employeeName;
	}
	
}
