/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.platform.bean.workflow.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;

import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.workflow.ApprovalUnitReferenceBeanInterface;
import jp.mosp.platform.dao.workflow.ApprovalUnitDaoInterface;
import jp.mosp.platform.dto.workflow.ApprovalUnitDtoInterface;

/**
 * 承認ユニットマスタ参照クラス。
 */
public class ApprovalUnitReferenceBean extends PlatformBean implements ApprovalUnitReferenceBeanInterface {
	
	/**
	 * 承認ユニットマスタDAO。
	 */
	private ApprovalUnitDaoInterface	dao;
	

	/**
	 * コンストラクタ。
	 */
	public ApprovalUnitReferenceBean() {
	}
	
	/**
	 * コンストラクタ。
	 * @param mospParams MosPパラメータクラス
	 * @param connection DBコネクション
	 */
	public ApprovalUnitReferenceBean(MospParams mospParams, Connection connection) {
		super(mospParams, connection);
	}
	
	@Override
	public void initBean() throws MospException {
		dao = (ApprovalUnitDaoInterface)createDao(ApprovalUnitDaoInterface.class);
		
	}
	
	@Override
	public ApprovalUnitDtoInterface findForKey(String unitCode, Date activateDate) throws MospException {
		return dao.findForKey(unitCode, activateDate);
		
	}
	
	@Override
	public ApprovalUnitDtoInterface getApprovalUnitInfo(String unitCode, Date targetDate) throws MospException {
		return dao.findForInfo(unitCode, targetDate);
		
	}
	
	@Override
	public String[][] getCodedSelectArray(Date targetDate, boolean needBlank) throws MospException {
		// 一覧取得
		List<ApprovalUnitDtoInterface> list = dao.findForActivateDate(targetDate);
		// 一覧件数確認
		if (list.size() == 0) {
			// 対象データ無し
			return getNoObjectDataPulldown();
		}
		// プルダウン用配列及びインデックス準備
		String[][] array = prepareSelectArray(list.size(), needBlank);
		int idx = needBlank ? 1 : 0;
		// コードの最大文字数確認
		int codeLength = 0;
		for (ApprovalUnitDtoInterface dto : list) {
			if (dto.getUnitCode().length() > codeLength) {
				codeLength = dto.getUnitCode().length();
			}
		}
		// 配列作成
		for (ApprovalUnitDtoInterface dto : list) {
			array[idx][0] = dto.getUnitCode();
			array[idx][1] = getCodedName(dto.getUnitCode(), dto.getUnitName(), codeLength);
			idx++;
		}
		return array;
	}
	
	@Override
	public String getUnitName(String unitCode, Date targetDate) throws MospException {
		ApprovalUnitDtoInterface dto = getApprovalUnitInfo(unitCode, targetDate);
		if (dto == null) {
			return unitCode;
		}
		return dto.getUnitName();
	}
	
	@Override
	public List<ApprovalUnitDtoInterface> getApprovalUnitHistory(String unitCode) throws MospException {
		return dao.findForHistory(unitCode);
	}
	
	@Override
	public List<ApprovalUnitDtoInterface> findForApproverPersonalId(String personalId, Date targetDate)
			throws MospException {
		return dao.findForApproverPersonalId(personalId, targetDate);
	}
	
	@Override
	public List<ApprovalUnitDtoInterface> findForApproverSection(String sectionCode, String positionCode,
			Date targetDate) throws MospException {
		return dao.findForApproverSection(sectionCode, positionCode, targetDate);
	}
	
	@Override
	public boolean hasPersonalUnit(String personalId, Date startDate, Date endDate) throws MospException {
		// 個人IDが設定されている、有効日の範囲内で情報を取得
		List<ApprovalUnitDtoInterface> list = dao.findPersonTerm(personalId, startDate, endDate);
		// リスト確認
		if (list.isEmpty()) {
			return false;
		}
		// 期間内に個人で設定されているユニットが存在したら
		return true;
	}
	
}
