/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.platform.dao.human.base;

import jp.mosp.platform.base.PlatformDao;

/**
 * MosPプラットフォーム人事管理におけるDAOの基本機能を提供する。<br>
 *
 */
public abstract class PlatformHumanDao extends PlatformDao {
	
	/**
	 * フリーワードで個人IDを抽出するSQL条件文を取得する。<br>
	 * 社員一覧を検索する際等に用いる。<br>
	 * 設定するパラメータは、フリーワード検索対象列長×フリーワード配列長<br>
	 * @param aryTargetCol フリーワード検索対象列
	 * @param aryFreeWord  フリーワード配列
	 * @return フリーワードで個人IDを抽出するSQL条件文
	 */
	public static String getQueryForFreeWord(String[] aryTargetCol, String[] aryFreeWord) {
		// SQL作成準備
		StringBuffer sb = new StringBuffer();
		// フリーワード検索対象列毎に条件を追加
		for (int i = 0; i < aryTargetCol.length; i++) {
			sb.append(leftParenthesis());
			for (int j = 0; j < aryFreeWord.length; j++) {
				if (j == 0) {
					sb.append(leftParenthesis());
				}
				sb.append(like(aryTargetCol[i]));
				if (j + 1 != aryFreeWord.length) {
					sb.append(or());
				}
				
			}
			sb.append(rightParenthesis());
			sb.append(rightParenthesis());
			if (i + 1 != aryTargetCol.length) {
				sb.append(or());
			}
		}
		return sb.toString();
	}
	
}
