/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.platform.dto.workflow.impl;

import java.util.Date;

import jp.mosp.framework.base.BaseDto;
import jp.mosp.platform.dto.workflow.RouteApplicationReferenceDtoInterface;

/**
 * ルート適用参照DTOクラス。
 */
public class RouteApplicationReferenceDto extends BaseDto implements RouteApplicationReferenceDtoInterface {
	
	private static final long	serialVersionUID	= -5110600845994952787L;
	
	/**
	 * 設定適用の有効日。
	 */
	private Date				activateDate;
	
	/**
	 * 個人ID
	 */
	private String				personalId;
	
	/**
	 * 社員コード。
	 */
	private String				employeeCode;
	
	/**
	 * 氏名。
	 */
	private String				employeeName;
	
	/**
	 * 勤務地。
	 */
	private String				workPlace;
	
	/**
	 * 雇用契約。
	 */
	private String				employment;
	
	/**
	 * 所属。
	 */
	private String				section;
	
	/**
	 * 職位。
	 */
	private String				position;
	
	/**
	 * ワークフロー区分
	 */
	private int					workflowType;
	
	/**
	 * ルート適用コード。
	 */
	private String				routeApplicationCode;
	
	/**
	 * ルート適用名称。
	 */
	private String				routeApplicationName;
	
	/**
	 * ルートコード。
	 */
	private String				routeCode;
	
	/**
	 * ルート名称。
	 */
	private String				routeName;
	
	/**
	 * 承認者社員コード。
	 */
	private String				approverCode;
	
	/**
	 * 承認者氏名
	 */
	private String				approverName;
	
	/**
	 * 承認階層。
	 */
	private String				routeStage;
	
	/**
	 * 一次承認者。
	 */
	private String				firstApprovalName;
	
	/**
	 * 最終承認者。
	 */
	private String				endApprovalName;
	
	private String				firstName;
	private String				lastName;
	private String				sectionCode;
	private String				workPlaceCode;
	private String				positionCode;
	private String				employmentContractCode;
	

	/**
	 * @param firstName セットする firstName
	 */
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}
	
	/**
	 * @return firstName
	 */
	public String getFirstName() {
		return firstName;
	}
	
	/**
	 * @param lastName セットする lastName
	 */
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
	
	/**
	 * @return lastName
	 */
	public String getLastName() {
		return lastName;
	}
	
	/**
	 * @return sectionCode
	 */
	public String getSectionCode() {
		return sectionCode;
	}
	
	/**
	 * @param sectionCode セットする sectionCode
	 */
	public void setSectionCode(String sectionCode) {
		this.sectionCode = sectionCode;
	}
	
	/**
	 * @return workPlaceCode
	 */
	public String getWorkPlaceCode() {
		return workPlaceCode;
	}
	
	/**
	 * @param workPlaceCode セットする workPlaceCode
	 */
	public void setWorkPlaceCode(String workPlaceCode) {
		this.workPlaceCode = workPlaceCode;
	}
	
	/**
	 * @return positionCode
	 */
	public String getPositionCode() {
		return positionCode;
	}
	
	/**
	 * @param positionCode セットする positionCode
	 */
	public void setPositionCode(String positionCode) {
		this.positionCode = positionCode;
	}
	
	/**
	 * @return employeeCode
	 */
	public String getEmployeeCode() {
		return employeeCode;
	}
	
	/**
	 * @param employeeCode セットする employeeCode
	 */
	public void setEmployeeCode(String employeeCode) {
		this.employeeCode = employeeCode;
	}
	
	/**
	 * @return employeeName
	 */
	public String getEmployeeName() {
		return employeeName;
	}
	
	/**
	 * @param employeeName セットする employeeName
	 */
	public void setEmployeeName(String employeeName) {
		this.employeeName = employeeName;
	}
	
	/**
	 * @return workPlace
	 */
	public String getWorkPlace() {
		return workPlace;
	}
	
	/**
	 * @param workPlace セットする workPlace
	 */
	public void setWorkPlace(String workPlace) {
		this.workPlace = workPlace;
	}
	
	/**
	 * @return employment
	 */
	public String getEmployment() {
		return employment;
	}
	
	/**
	 * @param employment セットする employment
	 */
	public void setEmployment(String employment) {
		this.employment = employment;
	}
	
	/**
	 * @return section
	 */
	public String getSection() {
		return section;
	}
	
	/**
	 * @param section セットする section
	 */
	public void setSection(String section) {
		this.section = section;
	}
	
	/**
	 * @return position
	 */
	public String getPosition() {
		return position;
	}
	
	/**
	 * @param position セットする position
	 */
	public void setPosition(String position) {
		this.position = position;
	}
	
	/**
	 * @return routeCode
	 */
	public String getRouteCode() {
		return routeCode;
	}
	
	/**
	 * @param routeCode セットする routeCode
	 */
	public void setRouteCode(String routeCode) {
		this.routeCode = routeCode;
	}
	
	/**
	 * @return routeName
	 */
	public String getRouteName() {
		return routeName;
	}
	
	/**
	 * @param routeName セットする routeName
	 */
	public void setRouteName(String routeName) {
		this.routeName = routeName;
	}
	
	/**
	 * @return approverCode
	 */
	public String getApproverCode() {
		return approverCode;
	}
	
	/**
	 * @param approverCode セットする approverCode
	 */
	public void setApproverCode(String approverCode) {
		this.approverCode = approverCode;
	}
	
	/**
	 * @return approverName
	 */
	public String getApproverName() {
		return approverName;
	}
	
	/**
	 * @param approverName セットする approverName
	 */
	public void setApproverName(String approverName) {
		this.approverName = approverName;
	}
	
	/**
	 * @return routeStage
	 */
	public String getRouteStage() {
		return routeStage;
	}
	
	/**
	 * @param routeStage セットする routeStage
	 */
	public void setRouteStage(String routeStage) {
		this.routeStage = routeStage;
	}
	
	/**
	 * @return firstApprovalName
	 */
	public String getFirstApprovalName() {
		return firstApprovalName;
	}
	
	/**
	 * @param firstApprovalName セットする firstApprovalName
	 */
	public void setFirstApprovalName(String firstApprovalName) {
		this.firstApprovalName = firstApprovalName;
	}
	
	/**
	 * @return endApprovalName
	 */
	public String getEndApprovalName() {
		return endApprovalName;
	}
	
	/**
	 * @param endApprovalName セットする endApprovalName
	 */
	public void setEndApprovalName(String endApprovalName) {
		this.endApprovalName = endApprovalName;
	}
	
	/**
	 * @return employmentContractCode
	 */
	public String getEmploymentContractCode() {
		return employmentContractCode;
	}
	
	/**
	 * @param employmentContractCode セットする employmentContractCode
	 */
	public void setEmploymentContractCode(String employmentContractCode) {
		this.employmentContractCode = employmentContractCode;
	}
	
	@Override
	public int getInactivateFlag() {
		// 処理なし
		return 0;
	}
	
	@Override
	public void setInactivateFlag(int inactivateFlag) {
		// 処理なし
		
	}
	
	@Override
	public String getPersonalId() {
		return personalId;
	}
	
	@Override
	public void setPersonalId(String personalId) {
		this.personalId = personalId;
	}
	
	@Override
	public Date getActivateDate() {
		return activateDate;
	}
	
	@Override
	public void setActivateDate(Date activateDate) {
		this.activateDate = activateDate;
		
	}
	
	@Override
	public String getRouteApplicationCode() {
		return routeApplicationCode;
	}
	
	@Override
	public String getRouteApplicationName() {
		return routeApplicationName;
	}
	
	@Override
	public void setRouteApplicationCode(String routeApplicationCode) {
		this.routeApplicationCode = routeApplicationCode;
	}
	
	@Override
	public void setRouteApplicationName(String routeApplicationName) {
		this.routeApplicationName = routeApplicationName;
	}
	
	@Override
	public int getWorkflowType() {
		return workflowType;
	}
	
	@Override
	public void setWorkflowType(int workflowType) {
		this.workflowType = workflowType;
	}
	
}
