/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.comsat;

import gnu.inet.comsat.ComsatInfo;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.StringTokenizer;

public class ComsatClient {
    public static final int DEFAULT_PORT = 512;
    protected DatagramSocket socket;

    public ComsatClient() throws IOException {
        this(512, 0);
    }

    public ComsatClient(int port, int timeout) throws IOException {
        if (port < 0) {
            port = 512;
        }
        this.socket = new DatagramSocket(port);
        if (timeout > 0) {
            this.socket.setSoTimeout(timeout);
        }
        this.socket.setReceiveBufferSize(1024);
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public ComsatInfo read() throws IOException {
        byte[] buf = new byte[this.socket.getReceiveBufferSize()];
        int len = buf.length;
        DatagramPacket packet = new DatagramPacket(buf, len);
        this.socket.receive(packet);
        buf = packet.getData();
        len = packet.getLength();
        String data = new String(buf, 0, len, "ISO-8859-1");
        ComsatInfo info = new ComsatInfo();
        StringTokenizer st = new StringTokenizer(data, "\n");
        String mailbox = st.nextToken();
        info.setMailbox(mailbox);
        boolean inBody = false;
        String lastHeader = null;
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (inBody) {
                String body = info.getBody();
                body = body == null ? line : body + "\n" + line;
                info.setBody(body);
                continue;
            }
            if (line.length() == 0) {
                inBody = true;
                continue;
            }
            int ci = line.indexOf(58);
            if (ci != -1) {
                lastHeader = line.substring(0, ci);
                info.setHeader(lastHeader, line.substring(ci + 1).trim());
                continue;
            }
            String val = info.getHeader(lastHeader);
            val = val + "\n" + line;
            info.setHeader(lastHeader, val);
        }
        return info;
    }
}

