/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.finger;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class FingerConnection {
    public static final int DEFAULT_PORT = 79;
    private static final String US_ASCII = "US-ASCII";
    protected Socket socket;
    protected boolean verbose;

    public FingerConnection(String host) throws IOException {
        this(host, 79);
    }

    public FingerConnection(String host, int port) throws IOException {
        this.socket = new Socket(host, port);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String list() throws IOException {
        return this.finger(null, null);
    }

    public String finger(String username) throws IOException {
        return this.finger(username, null);
    }

    public String finger(String username, String hostname) throws IOException {
        OutputStream out = this.socket.getOutputStream();
        out = new BufferedOutputStream(out);
        if (this.verbose) {
            out.write(47);
            out.write(87);
            if (username != null || hostname != null) {
                out.write(32);
            }
        }
        if (username != null) {
            out.write(username.getBytes(US_ASCII));
        }
        if (hostname != null) {
            out.write(64);
            out.write(hostname.getBytes(US_ASCII));
        }
        out.write(13);
        out.write(10);
        out.flush();
        InputStream in = this.socket.getInputStream();
        ByteArrayOutputStream acc = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        int len = in.read(buf);
        while (len != -1) {
            acc.write(buf, 0, len);
            len = in.read(buf);
        }
        return acc.toString(US_ASCII);
    }
}

