/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.ftp;

import gnu.inet.ftp.DTP;
import gnu.inet.ftp.DTPInputStream;
import java.io.IOException;
import java.io.InputStream;

class BlockInputStream
extends DTPInputStream {
    static final int EOF = 64;
    int descriptor;
    int max = -1;
    int count = -1;

    BlockInputStream(DTP dtp, InputStream in) {
        super(dtp, in);
    }

    @Override
    public int read() throws IOException {
        if (this.transferComplete) {
            return -1;
        }
        if (this.count == -1) {
            this.readHeader();
        }
        if (this.max < 1) {
            this.close();
            return -1;
        }
        int c = this.in.read();
        if (c == -1) {
            this.dtp.transferComplete();
        }
        ++this.count;
        if (this.count >= this.max) {
            this.count = -1;
            if (this.descriptor == 64) {
                this.close();
            }
        }
        return c;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (this.transferComplete) {
            return -1;
        }
        if (this.count == -1) {
            this.readHeader();
        }
        if (this.max < 1) {
            this.close();
            return -1;
        }
        int l = this.in.read(buf, off, len);
        if (l == -1) {
            this.dtp.transferComplete();
        }
        this.count += l;
        if (this.count >= this.max) {
            this.count = -1;
            if (this.descriptor == 64) {
                this.close();
            }
        }
        return l;
    }

    void readHeader() throws IOException {
        this.descriptor = this.in.read();
        int max_hi = this.in.read();
        int max_lo = this.in.read();
        this.max = max_hi << 8 | max_lo;
        this.count = 0;
    }
}

