/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.ftp;

import gnu.inet.ftp.FTPConnection;
import gnu.inet.util.GetLocalHostAction;
import gnu.inet.util.GetSystemPropertyAction;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;

public class FTPURLConnection
extends URLConnection {
    protected FTPConnection connection;
    protected boolean passive = true;
    protected int representationType = 3;
    protected int fileStructure = -1;
    protected int transferMode = -1;

    public FTPURLConnection(URL url) {
        super(url);
    }

    @Override
    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        String host = this.url.getHost();
        int port = this.url.getPort();
        String username = this.url.getUserInfo();
        String password = null;
        if (username != null) {
            int ci = username.indexOf(58);
            if (ci != -1) {
                password = username.substring(ci + 1);
                username = username.substring(0, ci);
            }
        } else {
            username = "anonymous";
            PrivilegedAction a = new GetSystemPropertyAction("user.name");
            String systemUsername = (String)AccessController.doPrivileged(a);
            a = new GetLocalHostAction();
            InetAddress localhost = (InetAddress)AccessController.doPrivileged(a);
            password = systemUsername + "@" + (localhost == null ? "localhost" : localhost.getHostName());
        }
        this.connection = new FTPConnection(host, port);
        if (!this.connection.authenticate(username, password)) {
            throw new SecurityException("Authentication failed");
        }
        this.connection.setPassive(this.passive);
        if (this.representationType != -1) {
            this.connection.setRepresentationType(this.representationType);
        }
        if (this.fileStructure != -1) {
            this.connection.setFileStructure(this.fileStructure);
        }
        if (this.transferMode != -1) {
            this.connection.setTransferMode(this.transferMode);
        }
    }

    @Override
    public void setDoInput(boolean doinput) {
        this.doInput = doinput;
    }

    @Override
    public void setDoOutput(boolean dooutput) {
        this.doOutput = dooutput;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        String path;
        if (!this.connected) {
            this.connect();
        }
        if ((path = this.url.getPath()).startsWith("/")) {
            path = path.substring(1);
        }
        String filename = null;
        int lsi = path.lastIndexOf(47);
        if (lsi != -1) {
            filename = path.substring(lsi + 1);
            if (!this.connection.changeWorkingDirectory(path = path.substring(0, lsi))) {
                throw new FileNotFoundException(path);
            }
        }
        if (filename != null && filename.length() > 0) {
            return new ClosingInputStream(this.connection.retrieve(filename));
        }
        return new ClosingInputStream(this.connection.list(null));
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        String path;
        if (!this.connected) {
            this.connect();
        }
        if ((path = this.url.getPath()).startsWith("/")) {
            path = path.substring(1);
        }
        String filename = null;
        int lsi = path.lastIndexOf(47);
        if (lsi != -1) {
            filename = path.substring(lsi + 1);
            if (!this.connection.changeWorkingDirectory(path = path.substring(0, lsi))) {
                throw new FileNotFoundException(path);
            }
        }
        if (filename != null && filename.length() > 0) {
            return new ClosingOutputStream(this.connection.store(filename));
        }
        throw new FileNotFoundException(filename);
    }

    @Override
    public String getRequestProperty(String key) {
        if ("passive".equals(key)) {
            return Boolean.toString(this.passive);
        }
        if ("representationType".equals(key)) {
            switch (this.representationType) {
                case 1: {
                    return "ASCII";
                }
                case 2: {
                    return "EBCDIC";
                }
                case 3: {
                    return "BINARY";
                }
            }
        } else if ("fileStructure".equals(key)) {
            switch (this.fileStructure) {
                case 1: {
                    return "FILE";
                }
                case 2: {
                    return "RECORD";
                }
                case 3: {
                    return "PAGE";
                }
            }
        } else if ("transferMode".equals(key)) {
            switch (this.transferMode) {
                case 1: {
                    return "STREAM";
                }
                case 2: {
                    return "BLOCK";
                }
                case 3: {
                    return "COMPRESSED";
                }
            }
        }
        return null;
    }

    public Map getRequestProperties() {
        HashMap map = new HashMap();
        this.addRequestPropertyValue(map, "passive");
        this.addRequestPropertyValue(map, "representationType");
        this.addRequestPropertyValue(map, "fileStructure");
        this.addRequestPropertyValue(map, "transferMode");
        return map;
    }

    private void addRequestPropertyValue(Map map, String key) {
        String value = this.getRequestProperty(key);
        map.put(key, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setRequestProperty(String key, String value) {
        if (this.connected) {
            throw new IllegalStateException();
        }
        if ("passive".equals(key)) {
            this.passive = Boolean.valueOf(value);
            return;
        } else if ("representationType".equals(key)) {
            if ("A".equalsIgnoreCase(value) || "ASCII".equalsIgnoreCase(value)) {
                this.representationType = 1;
                return;
            } else if ("E".equalsIgnoreCase(value) || "EBCDIC".equalsIgnoreCase(value)) {
                this.representationType = 2;
                return;
            } else {
                if (!"I".equalsIgnoreCase(value) && !"BINARY".equalsIgnoreCase(value)) throw new IllegalArgumentException(value);
                this.representationType = 3;
            }
            return;
        } else if ("fileStructure".equals(key)) {
            if ("F".equalsIgnoreCase(value) || "FILE".equalsIgnoreCase(value)) {
                this.fileStructure = 1;
                return;
            } else if ("R".equalsIgnoreCase(value) || "RECORD".equalsIgnoreCase(value)) {
                this.fileStructure = 2;
                return;
            } else {
                if (!"P".equalsIgnoreCase(value) && !"PAGE".equalsIgnoreCase(value)) throw new IllegalArgumentException(value);
                this.fileStructure = 3;
            }
            return;
        } else {
            if (!"transferMode".equals(key)) return;
            if ("S".equalsIgnoreCase(value) || "STREAM".equalsIgnoreCase(value)) {
                this.transferMode = 1;
                return;
            } else if ("B".equalsIgnoreCase(value) || "BLOCK".equalsIgnoreCase(value)) {
                this.transferMode = 2;
                return;
            } else {
                if (!"C".equalsIgnoreCase(value) && !"COMPRESSED".equalsIgnoreCase(value)) throw new IllegalArgumentException(value);
                this.transferMode = 3;
            }
        }
    }

    @Override
    public void addRequestProperty(String key, String value) {
        this.setRequestProperty(key, value);
    }

    class ClosingOutputStream
    extends FilterOutputStream {
        ClosingOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void close() throws IOException {
            super.close();
            FTPURLConnection.this.connection.logout();
        }
    }

    class ClosingInputStream
    extends FilterInputStream {
        ClosingInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
            super.close();
            FTPURLConnection.this.connection.logout();
        }
    }
}

