/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.http;

import gnu.inet.http.Request;
import gnu.inet.http.Response;
import gnu.inet.http.ResponseBodyReader;

public class ByteArrayResponseBodyReader
implements ResponseBodyReader {
    protected byte[] content;
    protected int pos;
    protected int len;

    public ByteArrayResponseBodyReader() {
        this(4096);
    }

    public ByteArrayResponseBodyReader(int size) {
        this.content = new byte[size];
        this.len = 0;
        this.pos = 0;
    }

    @Override
    public boolean accept(Request request, Response response) {
        return true;
    }

    @Override
    public void read(byte[] buffer, int offset, int length) {
        int l = length - offset;
        if (this.pos + l > this.content.length) {
            byte[] tmp = new byte[this.content.length * 2];
            System.arraycopy(this.content, 0, tmp, 0, this.pos);
            this.content = tmp;
        }
        System.arraycopy(buffer, offset, this.content, this.pos, l);
        this.pos += l;
        this.len = this.pos;
    }

    @Override
    public void close() {
        this.pos = 0;
    }

    public byte[] toByteArray() {
        byte[] ret = new byte[this.len];
        System.arraycopy(this.content, 0, ret, 0, this.len);
        return ret;
    }
}

