/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.imap;

import gnu.inet.imap.IMAPConnection;
import gnu.inet.imap.Namespaces;
import gnu.inet.imap.UTF7imap;
import java.util.ArrayList;
import java.util.List;

public class Quota {
    String quotaRoot;
    List resources;

    Quota(String text) {
        int len = text.length();
        ArrayList acc = new ArrayList();
        Namespaces.parse(text, 0, len, acc);
        this.quotaRoot = (String)acc.get(0);
        this.resources = new ArrayList();
        len = acc.size();
        for (int i = 1; i < len; ++i) {
            this.resources.add(this.parseResource((List)acc.get(i)));
        }
    }

    private Resource parseResource(List triple) {
        String name = (String)triple.get(0);
        String current = (String)triple.get(1);
        String limit = (String)triple.get(2);
        return new Resource(name, Integer.parseInt(current), Integer.parseInt(limit));
    }

    public String getQuotaRoot() {
        return this.quotaRoot;
    }

    public Resource[] getResources() {
        Resource[] ret = new Resource[this.resources.size()];
        this.resources.toArray(ret);
        return ret;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(IMAPConnection.quote(UTF7imap.encode(this.quotaRoot)));
        int len = this.resources.size();
        for (int i = 0; i < len; ++i) {
            buf.append(' ');
            buf.append(this.resources.get(i));
        }
        return buf.toString();
    }

    public static class Resource {
        String name;
        int current;
        int limit;

        public Resource(String name, int limit) {
            this(name, -1, limit);
        }

        Resource(String name, int current, int limit) {
            this.name = name;
            this.current = current;
            this.limit = limit;
        }

        public String getName() {
            return this.name;
        }

        public int getCurrentUsage() {
            return this.current;
        }

        public int getLimit() {
            return this.limit;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append('(');
            buf.append(this.name);
            if (this.current >= 0) {
                buf.append(' ');
                buf.append(this.current);
            }
            buf.append(' ');
            buf.append(this.limit);
            buf.append(')');
            return buf.toString();
        }
    }
}

