/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.ldap;

import gnu.inet.ldap.BERException;
import java.io.UnsupportedEncodingException;

public class BEREncoder {
    private byte[] buffer;
    private int offset;
    private int[] sequenceOffset;
    private int sequenceIndex;
    private boolean utf8;

    public BEREncoder(boolean utf8) {
        this(utf8, 1024);
    }

    public BEREncoder(boolean utf8, int initialSize) {
        this.utf8 = utf8;
        this.buffer = new byte[initialSize];
        this.offset = 0;
        this.sequenceOffset = new int[16];
        this.sequenceIndex = 0;
    }

    public void reset() {
        int i;
        for (i = 0; i < this.offset; ++i) {
            this.buffer[i] = 0;
        }
        this.offset = 0;
        for (i = 0; i < this.sequenceIndex; ++i) {
            this.sequenceOffset[i] = 0;
        }
        this.sequenceIndex = 0;
    }

    public int size() {
        return this.offset;
    }

    public byte[] toByteArray() {
        byte[] ret = new byte[this.offset];
        System.arraycopy(this.buffer, 0, ret, 0, this.offset);
        return ret;
    }

    public void append(boolean value) {
        this.append(value, 1);
    }

    public void append(boolean value, int code) {
        this.allocate(3);
        this.buffer[this.offset++] = (byte)code;
        this.buffer[this.offset++] = 1;
        this.buffer[this.offset++] = value ? -1 : 0;
    }

    public void append(int value) {
        this.append(value, 2);
    }

    public void append(int value, int code) {
        int mask = -8388608;
        int len = 4;
        while (((value & 0xFF800000) == 0 || (value & 0xFF800000) == -8388608) && len > 1) {
            --len;
            value <<= 8;
        }
        this.allocate(len + 2);
        this.buffer[this.offset++] = (byte)code;
        this.buffer[this.offset++] = (byte)len;
        while (len > 0) {
            this.buffer[this.offset++] = (byte)((value & 0xFF000000) >> 24);
            --len;
        }
    }

    public void append(byte[] bytes) throws BERException {
        this.append(bytes, 4);
    }

    public void append(byte[] bytes, int code) throws BERException {
        int len = bytes == null ? 0 : bytes.length;
        this.append(bytes, 0, len, code);
    }

    void append(byte[] bytes, int off, int len, int code) throws BERException {
        this.allocate(len + 5);
        this.buffer[this.offset++] = (byte)code;
        this.appendLength(len);
        if (len > 0) {
            System.arraycopy(bytes, off, this.buffer, this.offset, len);
            this.offset += len;
        }
    }

    public void append(String value) throws BERException {
        this.append(value, 12);
    }

    public void append(String value, int code) throws BERException {
        byte[] bytes = null;
        if (value == null) {
            bytes = new byte[]{};
        } else {
            String encoding = this.utf8 ? "UTF-8" : "ISO-8859-1";
            try {
                bytes = value.getBytes(encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new BERException("JVM does not support " + encoding);
            }
        }
        int len = bytes.length;
        this.allocate(len + 5);
        this.buffer[this.offset++] = (byte)code;
        this.appendLength(len);
        System.arraycopy(bytes, 0, this.buffer, this.offset, len);
        this.offset += len;
    }

    public void appendNull() {
        this.allocate(2);
        this.buffer[this.offset++] = 5;
        this.buffer[this.offset++] = 0;
    }

    private void allocate(int len) {
        if (this.buffer.length - this.offset < len) {
            int size = this.buffer.length;
            while ((size *= 2) - this.offset < len) {
            }
            byte[] ret = new byte[size];
            System.arraycopy(this.buffer, 0, ret, 0, this.offset);
            this.buffer = ret;
        }
    }

    private void appendLength(int len) throws BERException {
        if (len < 128) {
            this.buffer[this.offset++] = (byte)len;
        } else if (len < 256) {
            this.buffer[this.offset++] = -127;
            this.buffer[this.offset++] = (byte)len;
        } else if (len < 65536) {
            this.buffer[this.offset++] = -126;
            this.buffer[this.offset++] = (byte)(len >> 8);
            this.buffer[this.offset++] = (byte)(len & 0xFF);
        } else if (len < 0x1000000) {
            this.buffer[this.offset++] = -125;
            this.buffer[this.offset++] = (byte)(len >> 16);
            this.buffer[this.offset++] = (byte)(len >> 8);
            this.buffer[this.offset++] = (byte)(len & 0xFF);
        } else {
            throw new BERException("Data too long: " + len);
        }
    }

    public void appendFilter(String filter) throws BERException {
        byte[] bytes;
        if (filter == null || filter.length() == 0) {
            throw new BERException("Empty filter expression");
        }
        String charset = this.utf8 ? "UTF-8" : "ISO-8859-1";
        try {
            bytes = filter.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new BERException("JVM does not support " + charset);
        }
        this.appendFilter(bytes, 0);
    }

    int appendFilter(byte[] bytes, int off) throws BERException {
        int depth = 0;
        block8: while (off < bytes.length) {
            switch (bytes[off]) {
                case 32: {
                    ++off;
                    continue block8;
                }
                case 40: {
                    ++depth;
                    ++off;
                    continue block8;
                }
                case 41: {
                    if (--depth != 0) continue block8;
                    return off + 1;
                }
                case 38: {
                    off = this.appendFilterList(bytes, off + 1, 160);
                    continue block8;
                }
                case 44: {
                    off = this.appendFilterList(bytes, off + 1, 161);
                    continue block8;
                }
                case 33: {
                    off = this.appendFilterList(bytes, off + 1, 162);
                    continue block8;
                }
            }
            off = this.appendFilterItem(bytes, off);
        }
        if (depth != 0) {
            throw new BERException("Unbalanced parentheses");
        }
        return off;
    }

    int appendFilterList(byte[] bytes, int off, int code) throws BERException {
        BEREncoder sequence = new BEREncoder(this.utf8);
        while (off < bytes.length && bytes[off] == 40) {
            off = sequence.appendFilter(bytes, off);
        }
        this.append(sequence.toByteArray(), code);
        return off;
    }

    int appendFilterItem(byte[] bytes, int off) throws BERException {
        int code;
        int ei = BEREncoder.indexOf(bytes, (byte)61, off);
        if (ei == -1) {
            throw new BERException("Missing '='");
        }
        int end = ei;
        BEREncoder item = new BEREncoder(this.utf8);
        switch (bytes[ei - 1]) {
            case 126: {
                code = 168;
                --end;
                break;
            }
            case 62: {
                code = 165;
                --end;
                break;
            }
            case 60: {
                code = 166;
                --end;
                break;
            }
            case 58: {
                code = 169;
                break;
            }
            default: {
                int si = BEREncoder.indexOf(bytes, (byte)42, ei + 1);
                if (si == -1) {
                    code = 163;
                    break;
                }
                if (ei + 1 == bytes.length || bytes[ei + 2] == 41) {
                    code = 135;
                    --end;
                    break;
                }
                BEREncoder substring = new BEREncoder(this.utf8);
                substring.append(bytes, off, end, 4);
                end = BEREncoder.indexOf(bytes, (byte)41, ei + 1);
                if (end == -1) {
                    throw new BERException("No terminating ')'");
                }
                BEREncoder value = new BEREncoder(this.utf8);
                value.append(BEREncoder.unencode(bytes, ei + 1, end));
                substring.append(value.toByteArray(), 48);
                this.append(substring.toByteArray(), 164);
                off = end;
                return off;
            }
        }
        item.append(bytes, off, end - off, 4);
        end = BEREncoder.indexOf(bytes, (byte)41, ei + 1);
        if (end == -1) {
            throw new BERException("No terminating ')'");
        }
        if (code != 135) {
            item.append(BEREncoder.unencode(bytes, ei + 1, end));
        }
        this.append(item.toByteArray(), code);
        off = end;
        return off;
    }

    static int indexOf(byte[] bytes, byte c, int off) {
        for (int i = off; i < bytes.length; ++i) {
            if (bytes[i] == c) {
                return i;
            }
            if (bytes[i] != 41) continue;
            return -1;
        }
        return -1;
    }

    static byte[] unencode(byte[] bytes, int off, int end) throws BERException {
        int l;
        byte[] buf = new byte[end - off];
        int pos = 0;
        int bsi = BEREncoder.indexOf(bytes, (byte)92, off);
        while (bsi != -1) {
            if (bsi + 3 > end) {
                throw new BERException("Illegal filter value encoding");
            }
            l = bsi - off;
            System.arraycopy(bytes, off, buf, pos, l);
            pos += l;
            int c = Character.digit((char)bytes[bsi + 2], 16);
            buf[pos++] = (byte)(c += Character.digit((char)bytes[bsi + 1], 16) * 16);
            bsi = BEREncoder.indexOf(bytes, (byte)92, off += l + 3);
        }
        l = end - off;
        System.arraycopy(bytes, off, buf, pos, l);
        off += l;
        if ((pos += l) != buf.length) {
            byte[] swap = new byte[pos];
            System.arraycopy(buf, 0, swap, 0, pos);
            buf = swap;
        }
        return buf;
    }
}

