/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.pop3;

import gnu.inet.util.BASE64;
import gnu.inet.util.CRLFInputStream;
import gnu.inet.util.CRLFOutputStream;
import gnu.inet.util.EmptyX509TrustManager;
import gnu.inet.util.LineInputStream;
import gnu.inet.util.MessageInputStream;
import gnu.inet.util.SaslCallbackHandler;
import gnu.inet.util.SaslCramMD5;
import gnu.inet.util.SaslInputStream;
import gnu.inet.util.SaslLogin;
import gnu.inet.util.SaslOutputStream;
import gnu.inet.util.SaslPlain;
import gnu.inet.util.TraceLevel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class POP3Connection {
    public static final Logger logger = Logger.getLogger("gnu.inet.pop3");
    public static final Level POP3_TRACE = new TraceLevel("pop3");
    public static final int DEFAULT_PORT = 110;
    private static final String _OK = "+OK";
    private static final String _ERR = "-ERR";
    private static final String _READY = "+ ";
    protected static final String STAT = "STAT";
    protected static final String LIST = "LIST";
    protected static final String RETR = "RETR";
    protected static final String DELE = "DELE";
    protected static final String NOOP = "NOOP";
    protected static final String RSET = "RSET";
    protected static final String QUIT = "QUIT";
    protected static final String TOP = "TOP";
    protected static final String UIDL = "UIDL";
    protected static final String USER = "USER";
    protected static final String PASS = "PASS";
    protected static final String APOP = "APOP";
    protected static final String CAPA = "CAPA";
    protected static final String STLS = "STLS";
    protected static final String AUTH = "AUTH";
    protected static final int OK = 0;
    protected static final int ERR = 1;
    protected static final int READY = 2;
    protected Socket socket;
    protected LineInputStream in;
    protected CRLFOutputStream out;
    protected String response;
    protected byte[] timestamp;

    public POP3Connection(String hostname) throws UnknownHostException, IOException {
        this(hostname, -1, 0, 0, false, null);
    }

    public POP3Connection(String hostname, int port) throws UnknownHostException, IOException {
        this(hostname, port, 0, 0, false, null);
    }

    public POP3Connection(String hostname, int port, int connectionTimeout, int timeout) throws UnknownHostException, IOException {
        this(hostname, port, connectionTimeout, timeout, false, null);
    }

    public POP3Connection(String hostname, int port, int connectionTimeout, int timeout, boolean secure, TrustManager tm) throws UnknownHostException, IOException {
        if (port <= 0) {
            port = 110;
        }
        try {
            this.socket = new Socket();
            InetSocketAddress address = new InetSocketAddress(hostname, port);
            if (connectionTimeout > 0) {
                this.socket.connect(address, connectionTimeout);
            } else {
                this.socket.connect(address);
            }
            if (timeout > 0) {
                this.socket.setSoTimeout(timeout);
            }
            if (secure) {
                SSLSocketFactory factory = this.getSSLSocketFactory(tm);
                SSLSocket ss = (SSLSocket)factory.createSocket(this.socket, hostname, port, true);
                String[] protocols = new String[]{"TLSv1", "SSLv3"};
                ss.setEnabledProtocols(protocols);
                ss.setUseClientMode(true);
                ss.startHandshake();
                this.socket = ss;
            }
        }
        catch (GeneralSecurityException e) {
            IOException e2 = new IOException();
            e2.initCause(e);
            throw e2;
        }
        InputStream in = this.socket.getInputStream();
        in = new BufferedInputStream(in);
        in = new CRLFInputStream(in);
        this.in = new LineInputStream(in);
        OutputStream out = this.socket.getOutputStream();
        out = new BufferedOutputStream(out);
        this.out = new CRLFOutputStream(out);
        if (this.getResponse() != 0) {
            throw new ProtocolException("Connect failed: " + this.response);
        }
        this.timestamp = this.parseTimestamp(this.response);
    }

    public boolean auth(String mechanism, String username, String password) throws IOException {
        try {
            String[] m = new String[]{mechanism};
            SaslCallbackHandler ch = new SaslCallbackHandler(username, password);
            HashMap<String, String> p = new HashMap<String, String>();
            p.put("gnu.crypto.sasl.username", username);
            p.put("gnu.crypto.sasl.password", password);
            SaslClient sasl = Sasl.createSaslClient(m, null, "pop3", this.socket.getInetAddress().getHostName(), p, ch);
            if (sasl == null) {
                if ("LOGIN".equalsIgnoreCase(mechanism)) {
                    sasl = new SaslLogin(username, password);
                } else if ("PLAIN".equalsIgnoreCase(mechanism)) {
                    sasl = new SaslPlain(username, password);
                } else if ("CRAM-MD5".equalsIgnoreCase(mechanism)) {
                    sasl = new SaslCramMD5(username, password);
                } else {
                    return false;
                }
            }
            StringBuffer cmd = new StringBuffer(AUTH);
            cmd.append(' ');
            cmd.append(mechanism);
            this.send(cmd.toString());
            switch (this.getResponse()) {
                case 0: {
                    String qop = (String)sasl.getNegotiatedProperty("javax.security.sasl.qop");
                    if ("auth-int".equalsIgnoreCase(qop) || "auth-conf".equalsIgnoreCase(qop)) {
                        InputStream in = this.socket.getInputStream();
                        in = new BufferedInputStream(in);
                        in = new SaslInputStream(sasl, in);
                        in = new CRLFInputStream(in);
                        this.in = new LineInputStream(in);
                        OutputStream out = this.socket.getOutputStream();
                        out = new BufferedOutputStream(out);
                        out = new SaslOutputStream(sasl, out);
                        this.out = new CRLFOutputStream(out);
                    }
                    return true;
                }
                case 2: {
                    try {
                        byte[] c0 = this.response.getBytes("US-ASCII");
                        byte[] c1 = BASE64.decode(c0);
                        byte[] r0 = sasl.evaluateChallenge(c1);
                        byte[] r1 = BASE64.encode(r0);
                        this.out.write(r1);
                        this.out.write(13);
                        this.out.flush();
                        logger.log(POP3_TRACE, "> " + new String(r1, "US-ASCII"));
                        break;
                    }
                    catch (SaslException e) {
                        this.out.write(42);
                        this.out.write(13);
                        this.out.flush();
                        logger.log(POP3_TRACE, "> *");
                    }
                }
            }
            return false;
        }
        catch (SaslException e) {
            logger.log(POP3_TRACE, e.getMessage(), e);
            return false;
        }
        catch (RuntimeException e) {
            logger.log(POP3_TRACE, e.getMessage(), e);
            return false;
        }
    }

    public boolean apop(String username, String password) throws IOException {
        if (username == null || password == null || this.timestamp == null) {
            return false;
        }
        try {
            byte[] secret = password.getBytes("US-ASCII");
            byte[] target = new byte[this.timestamp.length + secret.length];
            System.arraycopy(this.timestamp, 0, target, 0, this.timestamp.length);
            System.arraycopy(secret, 0, target, this.timestamp.length, secret.length);
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] db = md5.digest(target);
            StringBuffer digest = new StringBuffer();
            for (int i = 0; i < db.length; ++i) {
                int c = db[i];
                if (c < 0) {
                    c += 256;
                }
                digest.append(Integer.toHexString((c & 0xF0) >> 4));
                digest.append(Integer.toHexString(c & 0xF));
            }
            String cmd = new StringBuffer(APOP).append(' ').append(username).append(' ').append(digest.toString()).toString();
            this.send(cmd);
            return this.getResponse() == 0;
        }
        catch (NoSuchAlgorithmException e) {
            logger.log(POP3_TRACE, "MD5 algorithm not found");
            return false;
        }
    }

    public boolean login(String username, String password) throws IOException {
        if (username == null || password == null) {
            return false;
        }
        String cmd = "USER " + username;
        this.send(cmd);
        if (this.getResponse() != 0) {
            return false;
        }
        cmd = "PASS " + password;
        this.send(cmd);
        return this.getResponse() == 0;
    }

    protected SSLSocketFactory getSSLSocketFactory(TrustManager tm) throws GeneralSecurityException {
        if (tm == null) {
            tm = new EmptyX509TrustManager();
        }
        SSLContext context = SSLContext.getInstance("TLS");
        TrustManager[] trust = new TrustManager[]{tm};
        context.init(null, trust, null);
        return context.getSocketFactory();
    }

    public boolean stls() throws IOException {
        return this.stls(new EmptyX509TrustManager());
    }

    public boolean stls(TrustManager tm) throws IOException {
        try {
            SSLSocketFactory factory = this.getSSLSocketFactory(tm);
            this.send(STLS);
            if (this.getResponse() != 0) {
                return false;
            }
            String hostname = this.socket.getInetAddress().getHostName();
            int port = this.socket.getPort();
            SSLSocket ss = (SSLSocket)factory.createSocket(this.socket, hostname, port, true);
            String[] protocols = new String[]{"TLSv1", "SSLv3"};
            ss.setEnabledProtocols(protocols);
            ss.setUseClientMode(true);
            ss.startHandshake();
            InputStream in = ss.getInputStream();
            in = new BufferedInputStream(in);
            in = new CRLFInputStream(in);
            this.in = new LineInputStream(in);
            OutputStream out = ss.getOutputStream();
            out = new BufferedOutputStream(out);
            this.out = new CRLFOutputStream(out);
            return true;
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }

    public int stat() throws IOException {
        this.send(STAT);
        if (this.getResponse() != 0) {
            throw new ProtocolException("STAT failed: " + this.response);
        }
        try {
            return Integer.parseInt(this.response.substring(0, this.response.indexOf(32)));
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("Not a number: " + this.response);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ProtocolException("Not a STAT response: " + this.response);
        }
    }

    public int list(int msgnum) throws IOException {
        String cmd = "LIST " + msgnum;
        this.send(cmd);
        if (this.getResponse() != 0) {
            throw new ProtocolException("LIST failed: " + this.response);
        }
        try {
            return Integer.parseInt(this.response.substring(this.response.indexOf(32) + 1));
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("Not a number: " + this.response);
        }
    }

    public InputStream retr(int msgnum) throws IOException {
        String cmd = "RETR " + msgnum;
        this.send(cmd);
        if (this.getResponse() != 0) {
            throw new ProtocolException("RETR failed: " + this.response);
        }
        return new MessageInputStream(this.in);
    }

    public void dele(int msgnum) throws IOException {
        String cmd = "DELE " + msgnum;
        this.send(cmd);
        if (this.getResponse() != 0) {
            throw new ProtocolException("DELE failed: " + this.response);
        }
    }

    public void noop() throws IOException {
        this.send(NOOP);
        if (this.getResponse() != 0) {
            throw new ProtocolException("NOOP failed: " + this.response);
        }
    }

    public void rset() throws IOException {
        this.send(RSET);
        if (this.getResponse() != 0) {
            throw new ProtocolException("RSET failed: " + this.response);
        }
    }

    public boolean quit() throws IOException {
        this.send(QUIT);
        int ret = this.getResponse();
        this.socket.close();
        return ret == 0;
    }

    public InputStream top(int msgnum) throws IOException {
        String cmd = "TOP " + msgnum + ' ' + '0';
        this.send(cmd);
        if (this.getResponse() != 0) {
            throw new ProtocolException("TOP failed: " + this.response);
        }
        return new MessageInputStream(this.in);
    }

    public String uidl(int msgnum) throws IOException {
        String cmd = "UIDL " + msgnum;
        this.send(cmd);
        if (this.getResponse() != 0) {
            throw new ProtocolException("UIDL failed: " + this.response);
        }
        return this.response.substring(this.response.indexOf(32) + 1);
    }

    public Map uidl() throws IOException {
        this.send(UIDL);
        if (this.getResponse() != 0) {
            throw new ProtocolException("UIDL failed: " + this.response);
        }
        LinkedHashMap<Integer, String> uids = new LinkedHashMap<Integer, String>();
        String line = this.in.readLine();
        while (line != null && !".".equals(line)) {
            int si = line.indexOf(32);
            if (si < 1) {
                throw new ProtocolException("Invalid UIDL response: " + line);
            }
            try {
                uids.put(new Integer(line.substring(0, si)), line.substring(si + 1));
            }
            catch (NumberFormatException e) {
                throw new ProtocolException("Invalid message number: " + line);
            }
        }
        return Collections.unmodifiableMap(uids);
    }

    public List capa() throws IOException {
        this.send(CAPA);
        if (this.getResponse() == 0) {
            String DOT = ".";
            ArrayList<String> list = new ArrayList<String>();
            String line = this.in.readLine();
            while (!".".equals(line)) {
                list.add(line);
                line = this.in.readLine();
            }
            return Collections.unmodifiableList(list);
        }
        return null;
    }

    protected void send(String command) throws IOException {
        logger.log(POP3_TRACE, "> " + command);
        this.out.write(command);
        this.out.writeln();
        this.out.flush();
    }

    protected int getResponse() throws IOException {
        this.response = this.in.readLine();
        logger.log(POP3_TRACE, "< " + this.response);
        if (this.response.indexOf(_OK) == 0) {
            this.response = this.response.substring(3).trim();
            return 0;
        }
        if (this.response.indexOf(_ERR) == 0) {
            this.response = this.response.substring(4).trim();
            return 1;
        }
        if (this.response.indexOf(_READY) == 0) {
            this.response = this.response.substring(2).trim();
            return 2;
        }
        throw new ProtocolException("Unexpected response: " + this.response);
    }

    byte[] parseTimestamp(String greeting) throws IOException {
        String mid;
        int at;
        int ket;
        int bra = greeting.indexOf(60);
        if (bra != -1 && (ket = greeting.indexOf(62, bra)) != -1 && (at = (mid = greeting.substring(bra, ket + 1)).indexOf(64)) != -1) {
            return mid.getBytes("US-ASCII");
        }
        return null;
    }
}

