/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxFontInfo;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.fonts.FontUtil;

public class XlsxFontHelper
extends BaseHelper {
    private Map<String, Integer> fontCache = new HashMap<String, Integer>();
    private Map<String, String> fontMap;
    private String exporterKey;
    private boolean isFontSizeFixEnabled;

    public XlsxFontHelper(JasperReportsContext jasperReportsContext, Writer writer, Map<String, String> fontMap, String exporterKey, boolean isFontSizeFixEnabled) {
        super(jasperReportsContext, writer);
        this.fontMap = fontMap;
        this.exporterKey = exporterKey;
        this.isFontSizeFixEnabled = isFontSizeFixEnabled;
    }

    public int getFont(JRExporterGridCell gridCell, Locale locale) {
        Object fontInfo;
        JRFont font;
        JRFont jRFont = font = gridCell.getElement() instanceof JRFont ? (JRFont)((Object)gridCell.getElement()) : null;
        if (font == null) {
            return -1;
        }
        String fontName = font.getFontName();
        if (this.fontMap != null && this.fontMap.containsKey(fontName)) {
            fontName = this.fontMap.get(fontName);
        } else {
            FontFamily family;
            String exportFont;
            fontInfo = FontUtil.getInstance(this.jasperReportsContext).getFontInfo(fontName, locale);
            if (fontInfo != null && (exportFont = (family = ((FontInfo)fontInfo).getFontFamily()).getExportFont(this.exporterKey)) != null) {
                fontName = exportFont;
            }
        }
        fontInfo = new XlsxFontInfo(gridCell, fontName);
        Integer fontIndex = this.fontCache.get(((XlsxFontInfo)fontInfo).getId());
        if (fontIndex == null) {
            fontIndex = this.fontCache.size();
            this.export((XlsxFontInfo)fontInfo);
            this.fontCache.put(((XlsxFontInfo)fontInfo).getId(), fontIndex);
        }
        return fontIndex;
    }

    private void export(XlsxFontInfo fontInfo) {
        this.write("<font><sz val=\"" + (this.isFontSizeFixEnabled ? fontInfo.fontSize - 1 : fontInfo.fontSize) + "\"/>" + "<color rgb=\"" + fontInfo.color + "\"/>" + "<name val=\"" + fontInfo.fontName + "\"/>" + "<b val=\"" + fontInfo.isBold + "\"/>" + "<i val=\"" + fontInfo.isItalic + "\"/>" + "<u val=\"" + (fontInfo.isUnderline ? "single" : "none") + "\"/>" + "<strike val=\"" + fontInfo.isStrikeThrough + "\"/>" + "<family val=\"2\"/></font>\n");
    }
}

