/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.platform.utils;

import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.constant.PlatformConst;

/**
 * 名称に関するユーティリティクラス。<br>
 * 
 * プラットフォームにおいて作成される名称は、
 * 全てこのクラスを通じて作成される(予定)。<br>
 * <br>
 */
public class PlatformNamingUtility {
	
	/**
	 * 他クラスからのインスタンス化を防止する。<br>
	 */
	private PlatformNamingUtility() {
		// 処理無し
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 住所情報
	 */
	public static String addressInfo(MospParams mospParams) {
		return mospParams.getName("Address", "Information");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 電話情報
	 */
	public static String phoneInfo(MospParams mospParams) {
		return mospParams.getName("Phone", "Information");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 社員コード
	 */
	public static String employeeCode(MospParams mospParams) {
		return mospParams.getName("EmployeeCode");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 承認者職位等級範囲
	 */
	public static String approverPositionGrade(MospParams mospParams) {
		return mospParams.getName("ApproverPositionGrade");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 、
	 */
	public static String touten(MospParams mospParams) {
		return mospParams.getName("Touten");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 空白
	 */
	public static String blank(MospParams mospParams) {
		return mospParams.getName("Blank");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 自動設定
	 */
	public static String autoNumbering(MospParams mospParams) {
		return mospParams.getName("AutoNumbering");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 有
	 */
	public static String exsistAbbr(MospParams mospParams) {
		return mospParams.getName("EffectivenessExistence");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 無
	 */
	public static String notExsistAbbr(MospParams mospParams) {
		return mospParams.getName("InactivateExistence");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 氏名
	 */
	public static String fullName(MospParams mospParams) {
		return mospParams.getName("FullName");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return ：
	 */
	public static String colon(MospParams mospParams) {
		return mospParams.getName("Colon");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 対象期間
	 */
	public static String targetPeriod(MospParams mospParams) {
		return mospParams.getName("Target", "Period");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 検索
	 */
	public static String search(MospParams mospParams) {
		return mospParams.getName("Search");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return ～
	 */
	public static String wave(MospParams mospParams) {
		return mospParams.getName("Wave");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 有効日
	 */
	public static String activateDate(MospParams mospParams) {
		return mospParams.getName("ActivateDate");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 有効/無効
	 */
	public static String inactivate(MospParams mospParams) {
		return mospParams.getName("Effectiveness", "Slash", "Inactivate");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 有/無
	 */
	public static String inactivateAbbr(MospParams mospParams) {
		return mospParams.getName("EffectivenessExistence", "Slash", "InactivateExistence");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 年
	 */
	public static String year(MospParams mospParams) {
		return mospParams.getName("Year");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 月
	 */
	public static String month(MospParams mospParams) {
		return mospParams.getName("Month");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 日
	 */
	public static String day(MospParams mospParams) {
		return mospParams.getName("Day");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 決定
	 */
	public static String decision(MospParams mospParams) {
		return mospParams.getName("Decision");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 変更
	 */
	public static String change(MospParams mospParams) {
		return mospParams.getName("Change");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 選択
	 */
	public static String select(MospParams mospParams) {
		return mospParams.getName("Select");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 新規登録
	 */
	public static String newInsert(MospParams mospParams) {
		return mospParams.getName("New", "Insert");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 登録
	 */
	public static String insert(MospParams mospParams) {
		return mospParams.getName("Insert");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 更新
	 */
	public static String update(MospParams mospParams) {
		return mospParams.getName("Update");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 一括更新
	 */
	public static String batchUpdate(MospParams mospParams) {
		return mospParams.getName("Bulk", "Update");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 編集
	 */
	public static String edit(MospParams mospParams) {
		return mospParams.getName("Edit");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 履歴追加
	 */
	public static String addHistory(MospParams mospParams) {
		return mospParams.getName("History", "Add");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 履歴編集
	 */
	public static String edtiHistory(MospParams mospParams) {
		return mospParams.getName("History", "Edit");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 複製
	 */
	public static String replication(MospParams mospParams) {
		return mospParams.getName("Replication");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 履歴削除
	 */
	public static String deleteHistory(MospParams mospParams) {
		return mospParams.getName("History", "Delete");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 履歴
	 */
	public static String history(MospParams mospParams) {
		return mospParams.getName("History");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return ▲ページの先頭へ
	 */
	public static String topOfPage(MospParams mospParams) {
		return mospParams.getName("UpperTriangular", "TopOfPage");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 基本情報
	 */
	public static String basisInfo(MospParams mospParams) {
		return mospParams.getName("Basis", "Information");
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @return 最新
	 */
	public static String latest(MospParams mospParams) {
		return mospParams.getName("Latest");
	}
	
	/**
	 * @param mospParams       MosP処理情報
	 * @param activateDateMode 有効日モード
	 * @return 決定or変更
	 */
	public static String activeteDateButton(MospParams mospParams, String activateDateMode) {
		return activateDateMode.equals(PlatformConst.MODE_ACTIVATE_DATE_FIXED) ? change(mospParams)
				: decision(mospParams);
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @param enclosed   カッコ内の文字列
	 * @return 【enclosed】
	 */
	public static String cornerParentheses(MospParams mospParams, String enclosed) {
		StringBuilder sb = new StringBuilder();
		sb.append(mospParams.getName("FrontWithCornerParentheses"));
		sb.append(enclosed);
		sb.append(mospParams.getName("BackWithCornerParentheses"));
		return sb.toString();
	}
	
	/**
	 * @param mospParams MosP処理情報
	 * @param count 件数
	 * @return 全count件
	 */
	public static String allCount(MospParams mospParams, int count) {
		StringBuilder sb = new StringBuilder();
		sb.append(mospParams.getName("All"));
		sb.append(count);
		sb.append(mospParams.getName("Count"));
		return sb.toString();
	}
	
}
