/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya;

import com.wiki.standalone.moxkiriya.util.FileIO;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;

public class SettingManager {
    public static final String SETTINGSKEY_USER_HOME = "USER_HOME";
    public static final String SETTINGSKEY_MOXKIRIYA_USER_DIR = "MOXKIRIYA_USER_DIR";
    public static final String SETINGKEY_MOXKIRIYAROOT = "moxkiriyaroot";
    public static final String SETTINGSKEY_WIKIROOT = "wikiroot";
    public static final String SETINGKEY_CLUSTER = "clustersetting";
    public static final String SETINGKEY_DBSERVER_URL = "dbserverurl";
    public static final String SETINGKEY_DBSERVER_PORT = "dbserverport";
    public static final String SETINGKEY_JDBC_DRIVER = "jdbcdriver";
    private static final String MOXKIRIYA_USER_DIR = "_moxkiriya";
    public static final String CONFIG_FILENAME = "_moxkiriya.config";
    private static final String PARTY_FILENAME = "_party.config";
    private static SettingManager singleton_ = null;
    private Hashtable<String, Boolean> partyTable_ = new Hashtable();
    private Hashtable<String, String> settingsTable_ = new Hashtable();
    private Hashtable<String, String> fullpathTable_ = new Hashtable();
    private String selectedParty_ = null;

    private SettingManager() {
    }

    public static SettingManager getInstance() {
        try {
            if (singleton_ == null) {
                singleton_ = new SettingManager();
                singleton_.initializeSettingsMap();
            }
        }
        catch (Exception e) {
            singleton_ = null;
            e.printStackTrace();
        }
        return singleton_;
    }

    private void initializeSettingsMap() throws Exception {
        String userHome = System.getProperty("user.home");
        File moxkiriyaUserDir = new File(String.valueOf(userHome) + "/" + MOXKIRIYA_USER_DIR);
        this.put(SETTINGSKEY_USER_HOME, userHome);
        this.put(SETTINGSKEY_MOXKIRIYA_USER_DIR, moxkiriyaUserDir.getAbsolutePath());
        if (!moxkiriyaUserDir.exists()) {
            moxkiriyaUserDir.mkdirs();
        }
        this.loadPartyFile(moxkiriyaUserDir.getAbsolutePath());
        if (this.selectedParty_ != null && !this.selectedParty_.isEmpty()) {
            this.loadSettingFiles(moxkiriyaUserDir.getAbsolutePath());
        }
    }

    private void loadPartyFile(String path) throws Exception {
        File partyFile = new File(String.valueOf(path) + "/" + PARTY_FILENAME);
        if (!partyFile.exists()) {
            partyFile.createNewFile();
        }
        BufferedReader buffreader = FileIO.bufferedReader(partyFile);
        String line = null;
        while ((line = buffreader.readLine()) != null) {
            String[] list = line.split("=", 2);
            String key = list[0].trim();
            String value = list[1].trim();
            this.putParty(key, Boolean.valueOf(value));
        }
        Hashtable<String, Boolean> partyTable = this.getPartyTable();
        if (!partyTable.isEmpty()) {
            this.selectedParty_ = "";
            Set<String> keySet = partyTable.keySet();
            for (String key : keySet) {
                boolean value = partyTable.get(key);
                if (!value) continue;
                this.selectedParty_ = key;
                break;
            }
        }
    }

    public void loadSettingFiles(String path) throws Exception {
        String wikiroot;
        String selectedParty = this.getSelectedParty();
        if (selectedParty != null && !selectedParty.isEmpty()) {
            this.settingsTable_ = this.loadConfigSettings(path, selectedParty);
        }
        if ((wikiroot = this.get(SETTINGSKEY_WIKIROOT)) != null) {
            String moxkiriya_userDir = this.get(SETTINGSKEY_MOXKIRIYA_USER_DIR);
            this.fullpathTable_.put("templateHtmlHead.txt", String.valueOf(moxkiriya_userDir) + "/" + selectedParty);
            this.fullpathTable_.put("user.css", String.valueOf(moxkiriya_userDir) + "/" + selectedParty);
            this.fullpathTable_.put("fixedstylesheet.css", wikiroot);
            this.fullpathTable_.put("defaultstylesheet.css", wikiroot);
            this.fullpathTable_.put("repository_cluster_derby.xml", String.valueOf(moxkiriya_userDir) + "/" + selectedParty);
            this.fullpathTable_.put("repository_local.xml", String.valueOf(moxkiriya_userDir) + "/" + selectedParty);
            if (Boolean.valueOf(this.get(SETINGKEY_CLUSTER)).booleanValue()) {
                this.fullpathTable_.put("Repository", String.valueOf(moxkiriya_userDir) + "/" + selectedParty);
            } else {
                this.fullpathTable_.put("Repository", wikiroot);
            }
        }
    }

    public Hashtable<String, String> loadConfigSettings(String path, String partyName) throws Exception {
        File inifile;
        Hashtable<String, String> settingsTable = new Hashtable<String, String>();
        File partyDir = new File(String.valueOf(path) + "/" + partyName);
        if (!partyDir.exists() && !partyDir.isDirectory()) {
            partyDir.mkdirs();
        }
        if (!(inifile = new File(String.valueOf(partyDir.getAbsolutePath()) + "/" + CONFIG_FILENAME)).exists()) {
            inifile.createNewFile();
        }
        BufferedReader buffreader = FileIO.bufferedReader(inifile);
        String userHome = System.getProperty("user.home");
        File moxkiriyaUserDir = new File(String.valueOf(userHome) + "/" + MOXKIRIYA_USER_DIR);
        settingsTable.put(SETTINGSKEY_USER_HOME, userHome);
        settingsTable.put(SETTINGSKEY_MOXKIRIYA_USER_DIR, moxkiriyaUserDir.getAbsolutePath());
        String line = null;
        while ((line = buffreader.readLine()) != null) {
            String key;
            String[] list = line.split("=", 2);
            if (list.length < 2 || (key = list[0].trim()).length() <= 0) continue;
            settingsTable.put(key, list[1].trim());
        }
        buffreader.close();
        return settingsTable;
    }

    public Hashtable<String, Boolean> getPartyTable() {
        return this.partyTable_;
    }

    public String getSelectedParty() {
        return this.selectedParty_;
    }

    public void setSelectedParty(String partyName) throws Exception {
        this.selectedParty_ = partyName;
        File moxkiriyaUserDir = new File(this.get(SETTINGSKEY_MOXKIRIYA_USER_DIR));
        this.loadSettingFiles(moxkiriyaUserDir.getAbsolutePath());
    }

    public ArrayList<String> getPartyList() {
        ArrayList<String> PartyList = new ArrayList<String>();
        Set<String> keySet = this.partyTable_.keySet();
        for (String key : keySet) {
            PartyList.add(key);
        }
        return PartyList;
    }

    public void putParty(String partyName, boolean isDefault) {
        if (!partyName.isEmpty()) {
            if (isDefault) {
                Set<String> keySet = this.partyTable_.keySet();
                for (String key : keySet) {
                    this.partyTable_.put(key, false);
                }
            }
            this.partyTable_.put(partyName, isDefault);
        }
    }

    public void put(String key, String val) {
        this.settingsTable_.put(key, val);
    }

    public String get(String key) {
        return this.settingsTable_.get(key);
    }

    public void save() throws Exception {
        String path = this.get(SETTINGSKEY_MOXKIRIYA_USER_DIR);
        File moxkiriyaHomeDir = new File(path);
        if (!moxkiriyaHomeDir.exists() || !moxkiriyaHomeDir.isDirectory()) {
            moxkiriyaHomeDir.mkdirs();
        }
        this.savePartyConfig(path);
        this.saveSettingConfig(path);
        this.loadSettingFiles(path);
    }

    public String getAbsolutePath(String filename) {
        String path = this.fullpathTable_.get(filename);
        return String.valueOf(path) + "/" + filename;
    }

    public void savePartyConfig(String path) throws Exception {
        StringBuffer stringBuf = new StringBuffer("");
        Enumeration<String> keys = this.partyTable_.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            boolean value = this.partyTable_.get(key);
            stringBuf.append(String.valueOf(key) + "=" + value + "\n");
        }
        File inifile = new File(String.valueOf(path) + "/" + PARTY_FILENAME);
        BufferedWriter writer = FileIO.bufferedWriter(inifile);
        writer.write(stringBuf.toString());
        writer.close();
    }

    public void saveSettingConfig(String path) throws Exception {
        this.saveSettingConfig(path, this.selectedParty_, this.settingsTable_);
    }

    public void saveSettingConfig(String path, String partyName, Hashtable<String, String> settingTable) throws Exception {
        StringBuffer stringBuf = new StringBuffer("");
        Enumeration<String> keys = settingTable.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String value = settingTable.get(key);
            stringBuf.append(String.valueOf(key) + "=" + value + "\n");
        }
        File partyDir = new File(String.valueOf(path) + "/" + partyName);
        if (!partyDir.exists()) {
            partyDir.mkdirs();
        }
        File inifile = new File(String.valueOf(partyDir.getAbsolutePath()) + "/" + CONFIG_FILENAME);
        BufferedWriter writer = FileIO.bufferedWriter(inifile);
        writer.write(stringBuf.toString());
        writer.close();
    }
}

