/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya;

import com.wiki.standalone.moxkiriya.PageData;
import com.wiki.standalone.moxkiriya.SettingManager;
import com.wiki.standalone.moxkiriya.WikiHistory;
import com.wiki.standalone.moxkiriya.WikiRepository;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiBodyBlockParser;
import com.wiki.standalone.moxkiriya.util.FileIO;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.Value;
import javax.jcr.version.Version;
import javax.jcr.version.VersionIterator;

public class WikiEngine {
    public static final String WIKIROOT_DIRECTORY = "wikiroot";
    public static final String MAINPAGE_TITLE = "MainPage";
    public static final String TEMPLATE_HTMLHEADER_FILE = "templateHtmlHead.txt";
    public static final String FIXED_STYLESHEET_FILENAME = "fixedstylesheet.css";
    public static final String USER_STYLESHEET_FILENAME = "user.css";
    public static final String DEFAULT_STYLESHEET_FILENAME = "defaultstylesheet.css";
    public static final String ATTRIBUTE_JCR_UUID = "data-jcr_uuid";
    public static final String NAMESPACE_CATEGORY = "Category";
    public static final String NAMESPACE_FILE = "File";
    protected WikiRepository wikiRepository_;
    private HashMap<String, PageData> pageDataMap_ = null;
    private WikiHistory wikiHistory_ = new WikiHistory();

    public WikiRepository getWikiRepository() {
        return this.wikiRepository_;
    }

    public void setWikiRepository(WikiRepository wikiRepository) {
        this.wikiRepository_ = wikiRepository;
    }

    public void buildWikiRepository(File wikirootPath) throws Exception {
        this.wikiRepository_ = new WikiRepository(wikirootPath);
        PageData mainPageData = new PageData();
        mainPageData.setNamespace("Main");
        mainPageData.setTitle(MAINPAGE_TITLE);
        this.wikiRepository_.buildWikiRepository(mainPageData);
    }

    public void setPageDataMap(HashMap<String, PageData> map) {
        this.pageDataMap_ = map;
    }

    public void setPageDataMap(PageData pageData) throws Exception {
        String uuid = pageData.getNode().getProperty("{http://www.jcp.org/jcr/1.0}uuid").getString();
        this.pageDataMap_ = this.queryPageUUID(uuid);
    }

    public void setPageDataMap(String title) throws Exception {
        this.pageDataMap_ = this.queryPageTitle(title);
    }

    public HashMap<String, PageData> getPageDataMap() {
        return this.pageDataMap_;
    }

    public ArrayList<String> getNamespaceList() throws Exception {
        Value[] namespaces;
        ArrayList<String> namespaceList = new ArrayList<String>();
        Value[] valueArray = namespaces = this.wikiRepository_.getNamespaceList();
        int n = namespaces.length;
        int n2 = 0;
        while (n2 < n) {
            Value value = valueArray[n2];
            namespaceList.add(value.getString());
            ++n2;
        }
        return namespaceList;
    }

    public void checkout() throws Exception {
        PageData currentPageData = null;
        if (this.pageDataMap_.size() == 1) {
            currentPageData = this.pageDataMap_.values().iterator().next();
        }
        if (currentPageData != null) {
            this.wikiRepository_.checkout(currentPageData);
        }
    }

    public PageData checkin(PageData pageData) throws Exception {
        return this.wikiRepository_.checkin(pageData);
    }

    public void cancelCheckout() throws Exception {
        PageData currentPageData = null;
        if (this.pageDataMap_.size() == 1) {
            currentPageData = this.pageDataMap_.values().iterator().next();
        }
        if (currentPageData != null) {
            this.wikiRepository_.cancelCheckout(currentPageData);
        }
    }

    public String parse() throws Exception {
        PageData pageData = null;
        String bodyHtml = "";
        if (this.pageDataMap_.size() == 1) {
            pageData = this.pageDataMap_.values().iterator().next();
            this.wikiHistory_.add(pageData);
            bodyHtml = this.markupContents(pageData);
        } else {
            bodyHtml = this.markupContentsList();
        }
        String headerHtml = WikiEngine.buildHtmlHeader();
        StringBuffer buf = new StringBuffer();
        buf.append(headerHtml);
        buf.append(bodyHtml);
        buf.append("</html>");
        return buf.toString();
    }

    public String parse(PageData pageData) throws Exception {
        String bodyHtml = this.markupContents(pageData);
        String headerHtml = WikiEngine.buildHtmlHeader();
        StringBuffer buf = new StringBuffer();
        buf.append(headerHtml);
        buf.append(bodyHtml);
        buf.append("</html>");
        return buf.toString();
    }

    public String markupContents(PageData pageData) throws Exception {
        WikiBodyBlockParser bodyBlockParser = new WikiBodyBlockParser(this);
        String bodyHtml = "";
        bodyBlockParser.parsePageTitle(pageData.getTitle());
        BufferedReader buffreader = FileIO.bufferedReader(new StringReader(pageData.getContent()));
        bodyHtml = String.valueOf(bodyBlockParser.parse(buffreader)) + this.buildCategoryList(pageData);
        buffreader.close();
        return bodyHtml;
    }

    public String markupContentsList() throws Exception {
        StringBuffer bodybuf = new StringBuffer();
        ResourceBundle resources_ = ResourceBundle.getBundle("com.wiki.standalone.moxkiriya.resources.moxkiriya");
        bodybuf.append("<h1>" + resources_.getString("key.Search.Result") + "</h1>\n");
        if (this.pageDataMap_.size() > 1) {
            bodybuf.append("<div>\n");
            bodybuf.append(String.valueOf(resources_.getString("key.Message.found.pages")) + "\n");
            bodybuf.append("</div>\n");
            for (String uuid : this.pageDataMap_.keySet()) {
                PageData pageData = this.pageDataMap_.get(uuid);
                bodybuf.append("<h3>\n");
                bodybuf.append("<a href=\"" + pageData.getTitle() + "\" " + ATTRIBUTE_JCR_UUID + "=" + pageData.getNode().getProperty("{http://www.jcp.org/jcr/1.0}uuid").getString() + ">");
                bodybuf.append(pageData.getTitle());
                bodybuf.append("</a>\n");
                bodybuf.append("</h3>\n");
                bodybuf.append("<div>\n");
                bodybuf.append(pageData.getIntroduction());
                bodybuf.append("</div>\n");
            }
        } else {
            bodybuf.append("<div>\n");
            bodybuf.append(String.valueOf(resources_.getString("key.search.result.message.nopage")) + "\n");
            bodybuf.append("</div>\n");
        }
        return bodybuf.toString();
    }

    public static String buildHtmlHeader() throws IOException {
        int size;
        StringBuffer stringBuf = new StringBuffer();
        SettingManager settingMgr = SettingManager.getInstance();
        File headerTemplate = new File(settingMgr.getAbsolutePath(TEMPLATE_HTMLHEADER_FILE));
        FileInputStream in = new FileInputStream(headerTemplate);
        byte[] byteBuf = new byte[255];
        while ((size = ((InputStream)in).read(byteBuf)) != -1) {
            stringBuf.append(new String(byteBuf, 0, size));
        }
        ((InputStream)in).close();
        File stylesheetFile = new File(settingMgr.getAbsolutePath(DEFAULT_STYLESHEET_FILENAME));
        stringBuf.append("\t<link rel=\"stylesheet\" type=\"text/css\" href=\"" + stylesheetFile.toURI().toString() + "\">\n");
        stylesheetFile = new File(settingMgr.getAbsolutePath(USER_STYLESHEET_FILENAME));
        stringBuf.append("\t<link rel=\"stylesheet\" type=\"text/css\" href=\"" + stylesheetFile.toURI().toString() + "\">\n");
        stylesheetFile = new File(settingMgr.getAbsolutePath(FIXED_STYLESHEET_FILENAME));
        stringBuf.append("\t<link rel=\"stylesheet\" type=\"text/css\" href=\"" + stylesheetFile.toURI().toString() + "\">\n");
        stringBuf.append("<script>\nfunction scrollTo(elementId) {\n\tdocument.getElementById(elementId).scrollIntoView()\n}\n</script>");
        stringBuf.append("</head>\n");
        return stringBuf.toString();
    }

    private String buildCategoryList(PageData pageData) throws Exception {
        StringBuffer buf = new StringBuffer("");
        ArrayList<String> categoryies = pageData.getCategories();
        for (String category : categoryies) {
            HashMap<String, PageData> categoryPageMap;
            if (category.isEmpty() || (categoryPageMap = this.queryPageTitle(category, NAMESPACE_CATEGORY)).size() != 1) continue;
            PageData categoryPage = categoryPageMap.values().iterator().next();
            Node node = categoryPage.getNode();
            buf.append("<a href=\"" + category + "\" ");
            buf.append("data-jcr_uuid=\"");
            buf.append(node.getProperty("{http://www.jcp.org/jcr/1.0}uuid").getString());
            buf.append("\">");
            buf.append(category);
            buf.append("</a> ");
        }
        String startElem = "";
        String endElem = "";
        if (buf.length() > 0) {
            startElem = "<div class=\"categorylist\"> Categories: \n";
            endElem = "</div>";
        }
        return String.valueOf(startElem) + buf.toString() + endElem;
    }

    public HashMap<String, PageData> queryPageNamespace(String namespace) throws Exception {
        return this.wikiRepository_.queryPageNamespace(namespace);
    }

    public HashMap<String, PageData> queryPageUUID(String uuid) throws Exception {
        return this.wikiRepository_.queryPageUUID(uuid);
    }

    public HashMap<String, PageData> queryPageTitle(String pageTitle, String namespace) throws Exception {
        return this.wikiRepository_.queryPageTitle(pageTitle, namespace);
    }

    public HashMap<String, PageData> queryPageTitle(String pageTitle) throws Exception {
        return this.wikiRepository_.queryPageTitle(pageTitle);
    }

    public HashMap<String, PageData> queryPageFullTextSearch(String searchKey) throws Exception {
        return this.wikiRepository_.queryPageFullTextSearch(searchKey);
    }

    public boolean isContainsNamespaceList(String namespace) throws Exception {
        return this.wikiRepository_.isContainsNamespaceList(namespace);
    }

    public void deletePage(PageData pagedata) throws Exception {
        this.wikiRepository_.deletePage(pagedata);
    }

    public void refreshSession() throws Exception {
        this.wikiRepository_.refreshSession();
        if (this.pageDataMap_ != null && this.pageDataMap_.size() == 1) {
            PageData pageData = this.pageDataMap_.values().iterator().next();
            String uuid = pageData.getNode().getProperty("{http://www.jcp.org/jcr/1.0}uuid").getString();
            this.pageDataMap_ = this.wikiRepository_.queryPageUUID(uuid);
        }
    }

    public boolean canBack() {
        return this.wikiHistory_.canBack();
    }

    public boolean canForward() {
        return this.wikiHistory_.canForward();
    }

    public String back() throws Exception {
        PageData pageData = this.wikiHistory_.back();
        this.setPageDataMap(pageData);
        return this.parse(pageData);
    }

    public String forward() throws Exception {
        PageData pageData = this.wikiHistory_.forward();
        this.setPageDataMap(pageData);
        return this.parse(pageData);
    }

    public void clearHistory() {
        this.wikiHistory_.clear();
    }

    public VersionIterator getVersionHistory() throws Exception {
        PageData pageData = this.pageDataMap_.values().iterator().next();
        String uuid = pageData.getNode().getProperty("{http://www.jcp.org/jcr/1.0}uuid").getString();
        return this.wikiRepository_.getVersionHistory(uuid);
    }

    public Version getBaseVersion() throws Exception {
        PageData pageData = this.pageDataMap_.values().iterator().next();
        return this.wikiRepository_.getBaseVersion(pageData.getNode());
    }

    public void restoreVersion(Version version) throws Exception {
        PageData pageData = this.pageDataMap_.values().iterator().next();
        this.wikiRepository_.restoreVersion(version, pageData.getNode());
    }

    public void importSystemView(File outputFile) throws Exception {
        this.wikiRepository_.importSystemView(outputFile);
    }

    public void exportSystemView(File outputFile) throws Exception {
        this.wikiRepository_.exportSystemView(outputFile);
    }

    public void closeSession() {
        this.wikiRepository_.closeSession();
    }
}

